<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Utilities\Utility;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Language\Text;
defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);

TourOperatorProHtmlBackendAlias::load_jquery_library('select2');


$id_by_name = "element_field_". $name;
$name_format = str_replace(array('[', ']'), '_', $name);
$list_actionsms = array('first_send','second_send',);

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-actionsms">
        <select class="table-view" name="<?php echo (esc_attr($name)); ?>">
            <option value=""><?php esc_attr_e('Select Action SMS','touroperatorpro') ?></option>
            <?php foreach ($list_actionsms as $actionsms) { ?>
                <option <?php echo ($actionsms == $value ? ' selected ' : '') ?>
                        value="<?php echo (esc_attr($actionsms)) ?>"><?php (esc_html_e(ucfirst(str_replace("_"," ",$actionsms)))) ?></option>
            <?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/actionsms/actionsms.less');
$doc->addScriptApplySelector('.field-actionsms','field_actionsms',array(
    "field_name"=>  $name,
    "value"=> $value
),'admin/app/layouts/WooBooking/form/field/actionsms/actionsms.jquery.js');