<?php
namespace TourOperatorProAdmin\app\helpers;

use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\Model;

class CurrencyHelper
{
    public static function getRatesCurrenciesbyAPI(){
        $appConfig = Factory::getAppConfig();
        $based = $appConfig->get('currencies_in_list','');
        $url = 'https://api.exchangeratesapi.io/latest?base='.$based.'';
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $json = curl_exec($ch);
        curl_close($ch);
        $exchangeRates = json_decode($json, true);
        return $exchangeRates;
        }
    public static function convertCurrency($amount = 0)
    {
        $appConfig = Factory::getAppConfig();
        $from = $appConfig->get('currencies_in_list', '');
        isset($_SESSION["currency"])?$currency_converter = $_SESSION["currency"]:$currency_converter = "";
        if ($currency_converter == "" && empty($currency_converter)) {
            if ($from == "EUR"){
                $from = 1.0;
                $rate = $from / $from;
                $result = round($amount * $rate);
                return "$result";
            }
            $url = 'https://api.exchangeratesapi.io/latest?base=' . $from . '&symbols=' . $from . ',' . $from . '';
            $response_json = file_get_contents($url);
            $exchangeRates = json_decode($response_json, true);
            if ($exchangeRates) {
                if (!empty($exchangeRates['rates'] && $exchangeRates['rates'] != '')) {
                    $from = $exchangeRates['rates'][$from];
                    $rate = $from / $from;
                    $result = round($amount * $rate);
                    return "$result";
                }
            }
        }else{
            if ($from == $currency_converter){
                $from = 1.0;
                $rate = $from / $from;
                $result = round($amount * $rate);
                return "$result";
            }
            if ($from == "EUR"){
                $url = "https://api.exchangeratesapi.io/latest?symbols=".$currency_converter;
                $from = 1.0;
                $response_json = file_get_contents($url);
                $exchangeRates = json_decode($response_json, true);
                if ($exchangeRates) {
                    if (!empty($exchangeRates['rates'] && $exchangeRates['rates'] != '')) {
                        $to = $exchangeRates['rates'][$currency_converter];
                        $rate = $to / $from;
                        $result = round($amount * $rate);
                        return "$result";
                    }
                }
            }
            $url = 'https://api.exchangeratesapi.io/latest?base=' . $from . '&symbols=' . $from . ',' . $currency_converter . '';
            $response_json = file_get_contents($url);
            $exchangeRates = json_decode($response_json, true);
            if ($exchangeRates) {
                if (!empty($exchangeRates['rates'] && $exchangeRates['rates'] != '')) {
                    $from = $exchangeRates['rates'][$from];
                    $to = $exchangeRates['rates'][$currency_converter];
                    $rate = $to / $from;
                    $result = round($amount * $rate);
                    return "$result";
                }
            }
        }
    }
    public static function convertSymbols($cost = 0){
        $appConfig = Factory::getAppConfig();
        $to = $appConfig->get('currencies_in_list','');
        $currencyModel = Model::getInstance('currency');
        $symbol = $currencyModel->format_currency($to);
        $currency = reset($symbol);
        if($currency)
        {
          return "$currency $cost";
        }
    }


}