<?php
namespace TourOperatorProAdmin\app\controllers;
defined('_TOUROPERATOR_EXEC') or die;

use TourOperatorPro\Factory;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Mvc\Controller\Controller;
use TourOperatorPro\Filesystem\File;
use TourOperatorPro\Filesystem\Folder;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\OpenSource\WordPress\WooBookingOnWordpress;
use TourOperatorPro\Utilities\Utility;
use TourOperatorProAdmin\app\helpers\AdminHelper;
use ZipArchive;

class ToolController extends Controller
{
    /**
     * @return mixed
     * @throws Exception
     */
    public function next()
    {
        $input = Factory::getInput();
        $tool = $input->get('tool', array(), 'array');
        return $this->view("tool.form");
    }
    public function import_data_tour()
    {
        $input = Factory::getInput();
        $tool = $input->get('tool', array(), 'array');
        return $this->view("tool.import_data_tour");
    }
    /**
     * @return bool
     */
    public function setup_sample_database()
    {
        return true;
    }

    /**
     * @return bool
     */
    public function setup_sample_page()
    {
        return WooBookingOnWordpress::pluginprefix_activation();
    }

    /**
     * @return mixed
     * @throws Exception
     */
    public function create_view()
    {
        return $this->view("tool.create_view");
    }

    /**
     *
     */
    public function download_package()
    {
        $path = TOUROPERATORPRO_PATH_ROOT;
        $list = array();
        $exclude = array(
            '.DS_Store',
            '.git',
            '.idea',
            '.gitignore',
            'lib',
            'Licensing',
            'wpbookingpro.zip',
            'resources',
            'admin/resources',
            'upload',
            'note.txt',
            'note_android.txt',
            'note_function_wc.txt',
            'son_note.txt',
            'dev_tut'
        );
        $filter = array(
            'php',
            'js',
            'xml',
            'jpg',
            'png',
            'gif',
            'html',
            'json',
            'less',
            'css',
            'ini',
            'pot',
            'md',
            'eot',
            'svg',
            'ttf',
            'woff'
        );
        $pattern = '/(?:(?:\/\*(?:[^*]|(?:\*+[^*\/]))*\*+\/)|(?:(?<!\:|\\\|\')\/\/.*))/';
        //get all file and folder to var list
        AdminHelper::getDirContents($path, $list, $exclude, $filter);

        # create new zip object
        $zip_plugin = new ZipArchive();
        $file_zip_plugin_name = "touroperatorpro.zip";
        # create a temp file & open it
        $short_folder_plugin_path = "tmp/plugin";
        $short_zip_plugin_path = "$short_folder_plugin_path/$file_zip_plugin_name";
        $full_path_file_zip_plugin = TOUROPERATORPRO_PATH_ROOT . DS . $short_zip_plugin_path;
        $zip_plugin->open($full_path_file_zip_plugin, (ZipArchive::CREATE | ZipArchive::OVERWRITE));
        # loop through each file
        foreach ($list as $file) {
            if (!is_dir($file)) {

                $file_content = File::read($file);
                $extension = File::getExt($file);
                if (strpos($file, "touroperatorconfig.php") !== false) {
                    $pattern_tool = '/(\$environment)(.*)(development)(.*)/';
                    $matches = array();
                    preg_match($pattern_tool, $file_content, $matches);
                    $first = array_shift($matches);
                    $file_content = str_replace($first, "$matches[0]$matches[1]production$matches[3]", $file_content);

                    $pattern_tool = '/(\$live_site)(.*)/';
                    $matches = array();
                    preg_match($pattern_tool, $file_content, $matches);
                    $first = array_shift($matches);
                    $file_content = str_replace($first, "$matches[0]=\"\";", $file_content);
                }
                if ($extension == "php") {

                }
                $zip_plugin->addFromString(Utility::get_path_file($file), $file_content);
            }
        }
        $list_include_folder = array(
        );
        if(!empty($list_include_folder))
        {
            foreach ($list_include_folder as $folder) {
                $zip_plugin->addEmptyDir($folder);
                $source = realpath(TOUROPERATORPRO_PATH_ROOT . DS . $folder);
                if (is_dir($source) === true) {
                    AdminHelper::getDirContents($source, $files, array(), array());
                    foreach ($files as $file) {
                        if (!is_dir($file)) {
                            $zip_plugin->addFile($file, Utility::get_path_file($file));
                        }
                    }
                }
            }
        }
        $zip_plugin->addEmptyDir('upload');
        $file_plugin = TOUROPERATORPRO_PATH_ROOT . DS . 'touroperatorpro.php';
        $file_content = File::read($file_plugin);
        preg_match_all($pattern, $file_content, $matches);
        $matches = reset($matches);
        array_shift($matches);
        $file_content = str_replace($matches, "\r\n", $file_content);
        $zip_plugin->addFromString(Utility::get_path_file($file_plugin), $file_content);
        $root_url = Factory::getRootUrlPlugin();
        # close zip
        $zip_plugin->close();

        //zip to main file
        $config = Factory::getConfig();
        $version = $config->get('version', '1.0');

        $main_files_zip = "MainFiles_v$version.zip";
        $short_main_files_zip_path = "tmp/$main_files_zip";
        $zip_main_file = new ZipArchive();
        # create a temp file & open it
        $main_files_full_path = TOUROPERATORPRO_PATH_ROOT . DS . $short_main_files_zip_path;

        $zip_main_file->open($main_files_full_path, (ZipArchive::CREATE | ZipArchive::OVERWRITE));


        $zip_main_file->addFile(TOUROPERATORPRO_PATH_ROOT . DS . "changelog.txt", "changelog.txt");
        $zip_main_file->addEmptyDir("Main_files");
        $zip_main_file->addFile($full_path_file_zip_plugin, "Main_files" . DS . $file_zip_plugin_name);
        $zip_main_file->addEmptyDir("Main_files/Licensing");
        //add folder Licensing
        $full_path_folder_licensing = TOUROPERATORPRO_PATH_ROOT . DS . "Licensing/";
        if (is_dir($full_path_folder_licensing) === true) {
            $files = Folder::files($full_path_folder_licensing);
            foreach ($files as $file) {
                $zip_main_file->addFile($full_path_folder_licensing . DS . $file, "Main_files/Licensing/" . $file);
            }
        }
        $zip_main_file->close();
        Utility::redirect($root_url . "tmp/$main_files_zip");
    }

    /**
     * @param string $content
     * @return string|string[]|null
     */
    static function remove_html_comments($content = '')
    {
        return preg_replace('/<!--(.|\s)*?-->/', "\r\n", $content);
    }

    /**
     * @return mixed
     * @throws Exception
     */
    public function setup_view()
    {
        return $this->view("tool.setup_view");
    }

    /**
     * @return mixed
     * @throws Exception
     */
    public function create_sample_data_order()
    {
        return $this->view("tool.create_sample_data_order");
    }

    /**
     * @return mixed
     * @throws Exception
     */
    public function list_page_front_end()
    {
        return $this->view("tool.list_page_front_end");
    }

    /**
     * @return mixed
     * @throws Exception
     */
    public function create_sample_data()
    {
        return $this->view("tool.create_sample_data");
    }

    /**
     * @return mixed
     * @throws Exception
     */
    public function save_setup_view()
    {
        $input = Factory::getInput();
        $data = $input->getData();
        $viewAppModel = Model::getInstance('viewapp');
        $viewAppModel->setup_view($data);
        return $this->view("tool.setup_view");
    }
}

?>