"use strict";
(function ($) {
    $.view_order_form = function (element, options) {
        let defaults = {
            row_state_template: ""
        };
        let plugin = this;
        plugin.settings = {};
        let $element = $(element);
        plugin.change_status_order = function (order_id, tour_id) {
            let data = {
                order_id: order_id,
                tour_id: tour_id,
                task: "order.ajax_change_order_status"
            };
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: data,
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);
                }
            });
        };

        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('.order-status').change(function (e) {
                let $tr = $(this).closest('.table-bordered');
                let order_id = $tr.data('order_id');
                let tour_id = $(this).val();
                plugin.change_status_order(order_id, tour_id);
            });

        };
        plugin.example_function = function () {
        };
        plugin.init();
    }
    $.fn.view_order_form = function (options) {
        return this.each(function () {
            if (undefined === $(this).data('view_order_form')) {
                let plugin = new $.view_order_form(this, options);
                $(this).data('view_order_form'
                    , plugin);
            }
        });
    }
})(jQuery);
