"use strict";
(function ($) {
    $.view_edit_form = function (element, options) {
        let defaults = {
            row_state_template: "",
            tour:{},
            group_size:20,
            customer:{},
            lastname:{
                current:0,
            },
            adult:{
                min:1,
                max:10,
                current:1,
                price:200,
            },
            children:{
                min:0,
                max:10,
                current:0,
                price:180,
            },
            infant:{
                min:0,
                max:10,
                current:0,
                price:100,
            },
            format_currency:'$'
        };
        let plugin = this;
        plugin.settings = {};
        let $element = $(element);
        plugin.change_status_order = function (order_id, tour_id) {
            let data = {
                order_id: order_id,
                tour_id: tour_id,
                task: "order.ajax_change_order_status"
            };
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: data,
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);
                }
            });
        };
        plugin.change_country_code_order = function (customer_id, country_code) {
            let data = {
                customer_id: customer_id,
                country_code: country_code,
                task: "order.ajax_change_country_code_order"
            };
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: data,
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);
                }
            });
        };

        plugin.save_order_edit = function (first_name,last_name,customer_id,time_booking,mobile,description,orderdetail_id,adult_number,children_number,infant_number) {
            let data = {
                customer_id : customer_id,
                first_name: first_name,
                last_name: last_name,
                time_booking : time_booking,
                mobile : mobile,
                description : description,
                adult_number : adult_number,
                children_number : children_number,
                infant_number : infant_number,
                orderdetail_id : orderdetail_id,
                task: "order.save"
            };
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: data,
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);
                }
            });
        };

        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('.order-status').change(function (e) {
                let $tr = $(this).closest('.table-bordered');
                let order_id = $tr.data('order_id');
                let tour_id = $(this).val();
                plugin.change_status_order(order_id, tour_id);
            });
            $element.find('.list-countries').change(function (e) {
                let $tr = $(this).closest('.table-bordered');
                let customer_id = $tr.data('customer_id');
                let country_code = $(this).val();
                plugin.change_country_code_order(customer_id,country_code);
            });
            $element.find(".form_datetime").datetimepicker({format: "yyyy-mm-dd hh:ii"});
            $element.find('.save-submit').click(function (e){
                let $tr =$element.find('.table-bordered');
                let customer_id = $tr.data('customer_id');
                let orderdetail_id = $tr.data('order_id');
                let first_name = $element.find(".first_name").val();
                let last_name = $element.find(".last_name").val();
                let time_booking = $element.find(".time-booking").val();
                let mobile = $element.find(".mobile").val();
                let description = $element.find(".description").val();
                let adult_number = $element.find('input[name="adult_number"]').val();
                let children_number = $element.find('input[name="children_number"]').val();
                let infant_number = $element.find('input[name="infant_number"]').val();
                plugin.save_order_edit(first_name,last_name,customer_id,time_booking,mobile,description,orderdetail_id,adult_number,children_number,infant_number);
            });


            $element.find(`input[name="adult_number"]`).val(plugin.settings.adult.current);
            $element.find('.fas.fa-plus').click(function (e) {
                let total=plugin.get_total_person();
                let $a_group=$(this).closest('.group-adult-children-infant');
                let group_key=$a_group.data('group_key');
                let current_object=plugin.settings[group_key];
                if(total<plugin.settings.group_size &&  current_object.current<current_object.max){
                    current_object.current++;
                }else{
                    return false;
                }
                $element.find(`input.input-${group_key}`).val(current_object.current);
                $element.find(`input[name="${group_key}_number"]`).val(current_object.current);
                plugin.update_price();
            });
            $element.find('.fas.fa-minus').click(function (e) {
                let $a_group=$(this).closest('.group-adult-children-infant');
                let group_key=$a_group.data('group_key');
                let current_object=plugin.settings[group_key];
                console.log(current_object)
                if(current_object.current>current_object.min){
                    current_object.current--;
                }else{
                    return false;
                }
                $element.find(`input.input-${group_key}`).val(current_object.current);
                $element.find(`input[name="${group_key}_number"]`).val(current_object.current);
                plugin.update_price();
            });
            plugin.update_price = function () {
                let total_price= parseFloat(plugin.settings.adult.current*plugin.settings.adult.price+plugin.settings.children.current*plugin.settings.children.price+plugin.settings.infant.current*plugin.settings.infant.price).toFixed(2);
                if(plugin.settings.discount_amount > 0 || plugin.settings.discount_percent > 0) {
                    $element.find('.price-original').html(`${parseFloat(total_price).toFixed(2)}`);
                }
                if(plugin.settings.discount_amount > 0){
                    $element.find('.total-price').html(`${plugin.settings.format_currency} ${parseFloat(total_price - plugin.settings.discount_amount).toFixed(2)}`);
                } else if(plugin.settings.discount_percent > 0) {
                    $element.find('.total-price').html(`${plugin.settings.format_currency} ${parseFloat(total_price - total_price * plugin.settings.discount_percent / 100).toFixed(2)}`);
                } else {
                    $element.find('.total-price').html(`${plugin.settings.format_currency} ${parseFloat(total_price).toFixed(2)}`);
                }

            };
            plugin.get_total_person = function () {
                $element.find('.total-price').prop( "disabled", true );
                let total;
                total = plugin.settings.adult.current+plugin.settings.children.current+plugin.settings.infant.current;
                return total;
            };
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }
    $.fn.view_edit_form = function (options) {
        return this.each(function () {
            if (undefined === $(this).data('view_edit_form')) {
                let plugin = new $.view_edit_form(this, options);
                $(this).data('view_edit_form'
                    , plugin);
            }
        });
    }
})(jQuery);
