"use strict";
(function ($) {
    $.field_boolean = function (element, options) {
        let defaults = {
            field_name: ""
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let field_name = plugin.settings.field_name;
            $element.find('input.yes-no').lc_switch();
            $element.delegate('input.yes-no', 'lcs-statuschange', function () {
                var status = ($(this).is(':checked')) ? 'checked' : 'unchecked';
                if (status === "checked") {
                    $element.find(`input[name="${field_name}"]`).val(1);
                } else {
                    $element.find(`input[name="${field_name}"]`).val(0);
                }
            });
            $element.find('.tooltipster').tooltipster();
        };
        plugin.getValue = function () {
            let field_name = plugin.settings.field_name;
            return $element.find(`input[name="${field_name}"]`).val();
        }
        plugin.example_function = function () {
        };
        plugin.init();
    };
    
    $.fn.field_boolean = function (options) {
        
        return this.each(function () {
            
            if (undefined == $(this).data('field_boolean')) {
                let plugin = new $.field_boolean(this, options);
                $(this).data('field_boolean', plugin);
            }
        });
    }
})(jQuery);
