<?php 

/**
 * new WordPress Widget format
 * Wordpress 2.8 and above
 * @see http://codex.wordpress.org/Widgets_API#Developing_Widgets
 */
class NB_Video_Widget extends WP_Widget {

	public $_default = array(
		'title' => '',
		'link' => '',
		'heading' => '',
		'image_uri' => '',
	);

	/**
	 * Constructor
	 *
	 * @return void
	 */
	function __construct() {
		$widget_ops = array( 'classname' => 'nb-video-widget', 'description' => 'NB Video Widget' );
		parent::__construct( 'nb-video-widget', 'NB Video', $widget_ops );
		add_action( 'admin_enqueue_scripts', [$this,'nb_video_enqueue'] );
		add_action( 'wp_enqueue_scripts', [$this,'nb_video_frontend_enqueue'] );
	}

	public function nb_video_enqueue($hook) {
		if ($hook === 'widgets.php') {
			wp_enqueue_media();
			wp_enqueue_script('nb-video', plugin_dir_url( dirname(__FILE__) ) . '/assets/js/admin/nb-video.js', array('jquery'),'1.0.0',true);
		}
	}

	public function nb_video_frontend_enqueue() {
		if ( is_single() || is_archive() ) {
			wp_enqueue_script('nb-video', plugin_dir_url( dirname(__FILE__) ) . '/assets/js/admin/nb-video-popup.js', array('jquery'),'1.0.0',true);
		}
	}

	/**
	 * Outputs the HTML for this widget.
	 *
	 * @param array  An array of standard parameters for widgets in this theme
	 * @param array  An array of settings for this widget instance
	 * @return void Echoes it's output
	 */
	function widget( $args, $instance ) {
		echo $args['before_widget'];
		$title = $instance['title'];
		if ( ! empty( $title ) ){
			if($title){
				echo $args['before_title'] . $title . $args['after_title'];
			}
        }

		?>
		
		<div class="background-video" style="background-image: url(<?php echo !empty( $instance['image_uri'] ) ? esc_url($instance['image_uri']) : esc_url($this->_default['image_uri']) ?>);">
			<a class="popup-youtube" href="<?php echo !empty( $instance['link'] ) ? esc_url($instance['link']) : esc_url($this->_default['link']) ?>">
				<span class="icon-nb-circular"></span>
				<h5><?php echo !empty( $instance['heading'] ) ? esc_attr($instance['heading']) : esc_attr($this->_default['heading']) ?></h5>
			</a>
		</div>

		<?php

		echo $args['after_widget'];
	}

	/**
	 * Deals with the settings when they are saved by the admin. Here is
	 * where any validation should be dealt with.
	 *
	 * @param array  An array of new settings as submitted by the admin
	 * @param array  An array of the previous settings
	 * @return array The validated and (if necessary) amended settings
	 */
	function update( $new_instance, $old_instance ) {

		// update logic goes here
		$updated_instance = $new_instance;
		return $updated_instance;
	}

	/**
	 * Displays the form for this widget on the Widgets page of the WP Admin area.
	 *
	 * @param array  An array of the current settings for this widget
	 * @return void Echoes it's output
	 */
	function form( $instance ) {
		?>
		<p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'torhub-elements'); ?></label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
                   name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo esc_attr(isset( $instance['title'] ) ? $instance['title'] : $this->_default['title']) ?>"/>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('link'); ?>"><?php _e('Link:', 'torhub-elements'); ?></label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id('link'); ?>"
                   name="<?php echo $this->get_field_name('link'); ?>" value="<?php echo esc_url(isset( $instance['link'] ) ? $instance['link'] : $this->_default['link']) ?>"/>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('heading'); ?>"><?php _e('Heading:', 'torhub-elements'); ?></label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id('heading'); ?>"
                   name="<?php echo $this->get_field_name('heading'); ?>" value="<?php echo esc_attr(isset( $instance['heading'] ) ? $instance['heading'] : $this->_default['heading']) ?>"/>
        </p>

        <p>
	        <label for="<?= $this->get_field_id( 'image_uri' ); ?>">Image</label>
	        <img class="<?= $this->id ?>_img" src="<?= esc_url((!empty($instance['image_uri'])) ? $instance['image_uri'] : ''); ?>" style="margin:0;padding:0;max-width:100%;display:block"/>
	        <input type="text" hidden class="widefat <?= $this->id ?>_url" name="<?= $this->get_field_name( 'image_uri' ); ?>" value="<?php echo esc_url(isset( $instance['image_uri'] ) ? $instance['image_uri'] : $this->_default['image_uri']) ?>" style="margin-top:5px;" />
	        <input type="button" id="<?= $this->id ?>" class="button button-primary js_custom_upload_media" value="Upload Image" style="margin-top:5px;" />
	    </p>
		<?php
	}
}

function nb_video_register_widget() {
	register_widget( 'NB_Video_Widget' );
}
add_action( 'widgets_init', 'nb_video_register_widget' );