<?php
function Netbase_Load_Social_Links_Widget()
{
    register_widget( 'NB_Widgets_Social_Links');
}
add_action( 'widgets_init', 'Netbase_Load_Social_Links_Widget' );

class NB_Widgets_Social_Links extends WP_Widget {
	protected $default;
	protected $socials;

	function __construct() {
		$this->socials = array(
			'facebook-f'  => esc_html__( 'Facebook', 'torhub-elements' ),
			'facebook-square'  => esc_html__( 'Facebook Square', 'torhub-elements' ),
			'twitter'     => esc_html__( 'Twitter', 'torhub-elements' ),
			'twitter-square'     => esc_html__( 'Twitter Square', 'torhub-elements' ),
			'linkedin-in'    => esc_html__( 'Linkedin', 'torhub-elements' ),
			'linkedin-square'    => esc_html__( 'Linkedin Square', 'torhub-elements' ),
			'google-plus' => esc_html__( 'Google Plus', 'torhub-elements' ),
			'google-plus-g' => esc_html__( 'Google Plus G', 'torhub-elements' ),
			'pinterest-p'   => esc_html__( 'Pinterest', 'torhub-elements' ),
			'pinterest-square'   => esc_html__( 'Pinterest Square', 'torhub-elements' ),
			'tumblr'      => esc_html__( 'Tumblr', 'torhub-elements' ),
			'flickr'      => esc_html__( 'Flickr', 'torhub-elements' ),
			'instagram'   => esc_html__( 'Instagram', 'torhub-elements' ),
			'bitbucket'   => esc_html__( 'Bitbucket', 'torhub-elements' ),
			'youtube'     => esc_html__( 'Youtube', 'torhub-elements' ),
			'github'      => esc_html__( 'Github', 'torhub-elements' ),
			'dribbble'    => esc_html__( 'Dribbble', 'torhub-elements' ),
			'rss'         => esc_html__( 'RSS', 'torhub-elements' ),
			'android'     => esc_html__( 'Android ', 'torhub-elements' ),
			'apple'       => esc_html__( 'Apple', 'torhub-elements' ),
			'windows'     => esc_html__( 'Windows', 'torhub-elements' ),
			'vimeo-square'     => esc_html__( 'Vimeo Square', 'torhub-elements' ),
		);
		$this->default = array(
			'title' => '',
		);
		foreach ( $this->socials as $k => $v ) {
			$this->default["{$k}_title"] = '';
			$this->default["{$k}_url"]   = '';
		}

		parent::__construct(
			'nbelement-social-links-widget',
			esc_html__( 'NB - Social Links', 'torhub-elements' ),
			array(
				'classname'   => 'nbfw-social-links widget__social-link',
				'description' => esc_html__( 'Display links to social media networks.', 'torhub-elements' ),
			),
			array( 'width' => 600, 'height' => 350 )
		);
	}

	/**
	 * Outputs the HTML for this widget.
	 *
	 * @param array $args An array of standard parameters for widgets in this theme
	 * @param array $instance An array of settings for this widget instance
	 *
	 * @return void Echoes it's output
	 */
	function widget( $args, $instance ) {
		$instance = wp_parse_args( $instance, $this->default );

		extract( $args );
		
		echo wp_kses_post( $before_widget );

		if ( $title = apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base ) ) {
			echo wp_kses_post( $before_title . $title . $after_title );
		}
		$style 	= $instance['style'];
		$size 	= $instance['size'];
		$align 	= 'align-' . $instance['align'];

		echo '<ul class="nbfw-social-link-widget ' . esc_attr($style) . ' ' . esc_attr($size). ' ' . esc_attr($align) . '">';
		foreach ( $this->socials as $social => $label ) {
			if ( ! empty( $instance[ $social . '_title' ] ) || ! empty( $instance[ $social . '_url' ] ) ) {
				printf( '<li><a href="%1$s" rel="nofollow" title="%2$s"><span class="icon-fa-%3$s"></span></a></li>',
					$instance[ $social . '_url' ],
					$instance[ $social . '_title' ],
					$social
				);
			}
		}
		echo '</ul>';

		echo wp_kses_post( $after_widget);
	}


	/**
	 * Deals with the settings when they are saved by the admin.
	 *
	 * @param array $new_instance
	 * @param array $old_instance
	 *
	 * @return array
	 */
	function update( $new_instance, $old_instance ) {
		return $new_instance;
	}

	/**
	 * Displays the form for this widget on the Widgets page of the WP Admin area.
	 *
	 * @param array $instance
	 *
	 * @return array
	 */
	function form( $instance ) {
		$instance = wp_parse_args( $instance, $this->default );

		// echo "<pre>";
		// print_r($instance);
		// echo "</pre>";

		$style					= esc_attr( $instance[ 'style' ] );
		$size					= esc_attr( $instance[ 'size' ] );
		$align					= esc_attr( $instance[ 'align' ] );
		?>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'torhub-elements' ); ?></label>
			<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $instance['title'] ); ?>"/>
		</p>

		<?php

		$html = '';
		// Style
		$black_style 					= $style == 'black-icon' ? 'selected="selected"' : '';
		$gray_style 					= $style == 'gray-icon' ? 'selected="selected"' : '';
		$white_style 					= $style == 'white-icon' ? 'selected="selected"' : '';

		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Style', 'torhub-elements' ) . ': </label>';
		$html  .= '<select class="widefat" name="' . $this->get_field_name( 'style' ) . '">
						<option value="black-icon"' . esc_attr($black_style) . '>' . esc_html__( 'Black Icon', 'torhub-elements' ) . '</option>
						<option value="gray-icon"' . esc_attr($gray_style) . '>' . esc_html__( 'Gray Icon', 'torhub-elements' ) . '</option>
						<option value="white-icon"' . esc_attr($white_style) . '>' . esc_html__( 'White Icon', 'torhub-elements' ) . '</option>
				   </select>
					';
		$html  .= '</p>';

		// Size
		$small_size 					= $size == 'small-size' ? 'selected="selected"' : '';
		$big_size 						= $size == 'big-size' ? 'selected="selected"' : '';

		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Size', 'torhub-elements' ) . ': </label>';
		$html  .= '<select class="widefat" name="' . $this->get_field_name( 'size' ) . '">
						<option value="small-size"' . esc_attr($small_size) . '>' . esc_html__( 'Small', 'torhub-elements' ) . '</option>
						<option value="big-size"' . esc_attr($big_size) . '>' . esc_html__( 'Big', 'torhub-elements' ) . '</option>
				   </select>
					';
		$html  .= '</p>';

		// Size
		$align_left 					= $align == 'left' ? 'selected="selected"' : '';
		$align_center 					= $align == 'center' ? 'selected="selected"' : '';
		$align_right 					= $align == 'right' ? 'selected="selected"' : '';

		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Align', 'torhub-elements' ) . ': </label>';
		$html  .= '<select class="widefat" name="' . $this->get_field_name( 'align' ) . '">
						<option value="left"' . esc_attr($align_left) . '>' . esc_html__( 'Left', 'torhub-elements' ) . '</option>
						<option value="center"' . esc_attr($align_center) . '>' . esc_html__( 'Center', 'torhub-elements' ) . '</option>
						<option value="right"' . esc_attr($align_right) . '>' . esc_html__( 'Right', 'torhub-elements' ) . '</option>
				   </select>
					';
		$html  .= '</p>';

		echo $html;
		?>

		
		<?php
		foreach ( $this->socials as $social => $label ) {
			printf(
				'<div style="width: 280px; float: left; margin-right: 10px;">
					<label>%s</label>
					<p><input type="text" class="widefat" name="%s" placeholder="%s" value="%s"></p>
					<p><input type="text" class="widefat" name="%s" placeholder="%s" value="%s"></p>
				</div>',
				$label,
				esc_attr( $this->get_field_name( $social . '_title' ) ),
				esc_html__( 'Title', 'torhub-elements' ),
				esc_attr( $instance[ $social . '_title' ] ),
				esc_attr( $this->get_field_name( $social . '_url' ) ),
				esc_html__( 'URL', 'torhub-elements' ),
				esc_url( $instance[ $social . '_url' ] )
			);
		}
	}
}
