<?php 
$tour_list = $settings['tour_list'];
if(!empty($tour_list)):
?>
<div class="tour-suggest-wrap">
    <div class="swiper-container gallery-top">
        <div class="swiper-wrapper">
            <?php foreach( $tour_list as $item ): ?>
            <div class="swiper-slide">
                <img src="<?php echo esc_url($item['image']['url']) ?>" alt="<?php echo esc_attr( get_bloginfo('title') ) ?>">
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    <div class="swiper-container gallery-thumbs">
        <div class="box-info">
            <p class="font-segoe"><?php echo esc_attr($settings['description']); ?></p>
            <h2 class="title"><?php echo esc_attr($settings['title']); ?></h2>
            <p class="content"><?php echo esc_attr($settings['content']); ?></p>
        </div>
        <div class="swiper-wrapper">
            <?php foreach( $tour_list as $item ): ?>
            <div class="swiper-slide">
                <div class="img-inner">
                    <div class="img" style="background-image: url('<?php echo esc_url($item['image']['url']) ?>')"></div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>        
    </div>
    <!-- Add Arrows -->
    <div class="bottom-action">
        <div class="navigation">
            <div class="swiper-button-prev swiper-button-white"></div>
            <div class="swiper-button-next swiper-button-white"></div>
        </div>
        <div class="viewpackage">
            <a href="<?php echo esc_url( $settings['link'] ) ?>"><?php echo esc_attr( $settings['text_link'] ) ?> <span class="icon-fa-angle-right"></span></a>
        </div>
    </div>
</div>
<?php endif; ?>