<?php 

$query_args = array(
    'post_type' => 'post',
    'post_status' => 'publish',
    'posts_per_page' => $settings['posts_per_page']
);
$nb_posts = new WP_Query($query_args);
?>

<div class="nb-post-wrapper">
    <?php while ($nb_posts->have_posts()) : $nb_posts->the_post();?>
        <div class="nb-post-item">
            <?php
            $featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'medium');
            ?>
            <div class="nb-post-thumbnail">
                <a href="<?php the_permalink(); ?>" style="background-image:url(<?php echo esc_url($featured_img_url); ?>);"></a>
                <div class="nb-post-date">
                    <span class="nb-post-day"><?php echo esc_attr(date_i18n('j', strtotime(get_the_date('')))); ?></span> 
                    <span class="nb-post-month"><?php echo esc_attr(date_i18n('M', strtotime(get_the_date('')))); ?></span>
                </div>
            </div>

            <div class="nb-post-data">

                <?php the_title( '<h5 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h5>' );?>
                <div class="nb-post-meta">
                    <div class="nb-post-author">
                        <p><?php the_author(); ?></p>
                    </div>

                    <div class="nb-post-date">
                        <p><?php echo esc_attr(get_the_date( '', get_the_ID() )); ?></p>
                    </div>
                </div>
                <div class="nb-post-excerpt">
                    <p>
                        <?php  
                        $excerpt="";
                        $limit = 25;
                        if (has_excerpt()) {
                            $excerpt = wp_strip_all_tags(get_the_excerpt());
                            $excerpt = wp_trim_words($excerpt, $limit, '...');
                            
                        }else {
                            $excerpt = wp_strip_all_tags(get_the_content());
                            $excerpt = wp_trim_words($excerpt, $limit, '...');
                        }
                        echo $excerpt;
                        ?>
                    </p>
                </div>

                <div class="read-more-link">
                    <a class="nb-primary-button" href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html__('Read More', 'torhub-elements'); ?></a>
                </div>
                
            </div>
        </div>
    <?php endwhile;?>
    <?php wp_reset_postdata();?>
</div>