"use strict";
(function ($) {
    $.view_list_tours = function (element, options) {
        let defaults = {
            row_state_template: "",
            data_input:[],
            render_tour_item_grid:"",
            render_tour_item_list:"",
            items_per_page: 8,
            visiblePages: 3,
            min_price:0,
            max_price:1099
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        var a;
        var $height = $('.nojq').height();
        var $height1 = 0;
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let min_price=parseInt(plugin.settings.min_price);
            let max_price=parseInt(plugin.settings.max_price);
            plugin.filterSystem(10, 100);
            $element.find('select[name="destination"]').select2();
            $element.find('input[class="datetimes"]').daterangepicker({
                showDropdowns: true,
                minYear: 1970,
                locale: {
                    format: 'YYYY/MM/DD'
                },
                maxYear: '+10',
                minDate: moment().format('YYYY-MM-DD')
            }, function (start, end, label) {
                var years = moment().diff(start, 'years');
                let rate = `${start.format('YYYY-MM-DD')};${end.format('YYYY-MM-DD')}`;
                $element.find('input[name="rate"]').val(rate)
            });
            $element.find('#slider-container-1').slider({
                range: true,
                min: 0,
                max: plugin.settings.max_prices,
                values: [min_price, max_price],
                create: function () {
                    $("#amount_1").text("$0");
                    $("#amount_2").text("$1099");
                },
                slide: function (event, ui) {
                    $("#amount_1").text("$" + ui.values[0]);
                    $("#amount_2").text("$" + ui.values[1]);
                    var mi = ui.values[0];
                    var mx = ui.values[1];
                    plugin.filterSystem(mi, mx);
                },
                change: function(event, ui) {
                    var mi = ui.values[0];
                    var mx = ui.values[1];
                    let price_value=[];
                    price_value.push(mi);
                    price_value.push(mx);
                    $element.find(`input[name="price_search"]`).val(JSON.stringify(price_value)).trigger('change');
                }
            });
            $element.find('input[name="sorting_by"]').iCheck({
                checkboxClass: 'icheckbox_minimal',
                radioClass: 'iradio_minimal',
                increaseArea: '20%'
            });
            $element.find('.block-filter-price-more-option').slideUp();
            $element.find('.block-tour-categories').slideUp();
            $element.find('p.more-option').click(function (e) {
                let $block_more_option = $(this).closest('.block-more-option');
                $block_more_option.find('.block-filter-price-more-option').slideToggle();
                $block_more_option.find('.block-tour-categories').slideToggle();
            });
            $element.find('.title-item').click(function (e) {
                let $parent = $(this).parent();
                $parent.find('div:nth-child(2)').slideToggle();
                $(this).toggleClass('slide-up')
            });


            // FILTER AJAX

            var $limit = parseInt($element.find('input[name="limit"]').val());
            var listingAjaxEvent = plugin.debounce(function(listing_event) {
                if(listing_event != 'loadMore'){
                    $element.find('input[name="start"]').val(0);
                    $element.find('input[name="total_show"]').val($limit);
                }
                var output = plugin.convert_data_form();
                let dataObj = {}
                $(output).each(function(i,field) {
                    dataObj[field.name] = field.value;
                })
                plugin.listing_ajax(dataObj,listing_event);
            }, 300);
            $element.find("select[name='destination']").on('change',listingAjaxEvent);
            $element.find("input[name='datetimes']").on('change',listingAjaxEvent);
            $element.find("input[name='price_search']").on('change',listingAjaxEvent);
            $element.find("input[name='tour_type[]']").on('change',listingAjaxEvent);
            $('body').find(".applyBtn").on('click',function(){
                listingAjaxEvent();
            });
            $element.find(".block-display-button .nav-tabs li").on('click',function(){
                let layout = $(this).data('layout');
                $element.find('input[name="tab"]').val(layout);
                listingAjaxEvent('tab');
            });
            $element.find("#pagination-tours-ajax").on('click',function(){
                let $start = parseInt($element.find('input[name="start"]').val());
                let $total_show = parseInt($element.find('input[name="total_show"]').val());
                $start +=$limit;
                $total_show +=$limit;
                $element.find('input[name="start"]').val($start);
                $element.find('input[name="total_show"]').val($total_show);
                listingAjaxEvent('loadMore');
            });
            $element.find('.sort-display a').click(function(){
                let sort=$(this).data('key_sort');
                let direction=$(this).data('direction');
                $element.find('input[name="key_sort"]').val(sort);
                $element.find('input[name="start"]').val(0);
                $element.find('input[name="direction"]').val(direction);
                $element.find('.sort-by-block .dropdown').removeClass('open');
                plugin.sortBy()
            });  
            $element.find('.sort-display a').click(listingAjaxEvent); 

            

            plugin.sticky_sidebar();
            $(window).on('resize', function () {
                plugin.sticky_sidebar();
            });
            plugin.sortBy();
            $(window).scroll(function() {
                $height1 = $('.header-middle.stuck').height();
                a = $height1 + $height + 30;
                $element.find('.wrapper-search-tour.custom-sticky.is_stuck').css({
                    'top' : a+'px' ,
                    'transition':'top 0.3s'
                })
            });
            $(window).on('load', function () {
                let $total_record = plugin.settings.total_record;
                let $total_show = $element.find('input[name="total_show"]').val();
                if ($total_show >= $total_record) {
                    $element.find('#pagination-tours-ajax').hide();
                }
            });
        };
        plugin.sortBy = function(){
            var $direction = $element.find('input[name="direction"]').val();
            var $sort = $element.find('input[name="key_sort"]').val();
            if($direction === "ASC" && $sort === "a.name"){
                $element.find('.select-by-default').text('Sort by name from A-Z');
            } else if($direction === "DESC" && $sort === "a.name"){
                $element.find('.select-by-default').text('Sort by name from Z-A');
            } else if($direction === "ASC" && $sort === "a.price"){
                $element.find('.select-by-default').text('Sort by ascending price');
            } else if($direction === "DESC" && $sort === "a.price"){
                $element.find('.select-by-default').text('Sort by descending price');
            } else {
                $element.find('.select-by-default').text('Sort by');
            }
        }
        var $y;
        plugin.listing_ajax= function(dataObj,listing_event){
            $.ajax({
                url:wpbookingpro_root_url + wpbookingpro_api_task,
                type: 'POST',
                dataType: 'json',
                data: {
                    dataObj: JSON.stringify(dataObj),
                    task: "tours.get_list_tours_ajax_form",
                    page_tour_detail: plugin.settings.page_tour_detail
                },
                beforeSend: function(){
                    $y = window.pageYOffset;
                    $('body').loadingModal();
                    if (listing_event =='loadMore'){
                        $element.find('#pagination-tours-ajax').hide();
                    }
                    console.log(a);
                },
                success: function(res){
                    let data= JSON.parse(res);
                    if (listing_event !='tab'){
                        $element.find('#pagination-tours-ajax').show();
                        if( data.data.template1 || data.data.template2) {
                            if (listing_event !='loadMore'){
                                $element.find('.wrapper-tour-list').empty(data.data.template2);
                                $element.find('.wrapper-tour-grid').empty(data.data.template1);
                            }

                            $element.find('.wrapper-tour-list').append(data.data.template2);
                            $element.find('.wrapper-tour-grid').append(data.data.template1);

                            if (listing_event ='loadMore'){
                                $height1 = $('.header-middle.stuck').height();
                                a = $height1 + $height + 30;
                                $element.find('.wrapper-search-tour.is_stuck').css({
                                    'top' : a+'px' ,
                                    'transition':'top 0.3s',
                                    'position' : 'fixed',
                                })
                            }

                        }
                        if( data.data.total) {
                            $element.find('.block-top-result .result-title h3').text(data.data.total + " Tours found");
                        }else{
                            $element.find('.block-top-result .result-title h3').text("0 Tours found");
                        }
                        if (data.data.total_show >= data.data.total) {
                            $element.find('#pagination-tours-ajax').hide();
                        }else {
                            $element.find('#pagination-tours-ajax').show();
                        }
                        plugin.sortBy();
                    }else {
                        if(data.data.tab) {
                            $element.find('.nav-tabs li').each(function(index, el) {
                                $(el).removeClass('active');
                                if($(el).attr('data-layout') == data.data.tab) {
                                    $(el).addClass('active');
                                }
                            });
                            $element.find('.tab-contents > div').each(function(index, el) {
                                $(el).removeClass('in active');
                                if($(el).attr('data-layout') == data.data.tab) {
                                    $(el).addClass('in active');
                                }

                            });
                        }
                    }
                },
                error: function(){

                },
                complete: function(){
                    $('body').loadingModal('destroy');
                    if (history.pushState) {
                        var $params = "";
                        $.each(dataObj, function(index, val) {
                            if (index == 'start' || index == 'limit' || index == 'total_show' || index == 'page' || index == 'curent_user_id'){
                                delete dataObj[index];
                            }else{
                                if( index == "destination" ) {
                                    $params += "?"+index+"="+val;
                                }else{
                                    $params += "&"+index+"="+val;
                                }
                            }
                        });
                        var newurl = window.location.protocol + "//" + window.location.host + window.location.pathname + $params;
                        window.history.pushState({path:newurl},'',newurl);
                    }
                    window.scrollTo(0,$y);
                }
                
            })
        };
        plugin.convert_data_form = function() {
            var dataArray = $element.find('.form-search-tour').serializeArray();
            var output = [];
            dataArray.forEach(function(item) {
                var existing = output.filter(function(v, i) {
                    return v.name == item.name;
                });
                if (existing.length) {
                    var existingIndex = output.indexOf(existing[0]);
                    output[existingIndex].value = output[existingIndex].value.concat(item.value);
                } else {
                    if (typeof item.value == 'string')
                        item.value = [item.value];
                    output.push(item);
                }
            });
            return output;
        };

        // STICKY SIDEBAR

        plugin.sticky_sidebar=function(){
            var $sticky = $element.find('.wrapper-search-tour');
            if ($sticky.length > 0) {
                $($sticky).stick_in_parent()
                    .on('sticky_kit:bottom', function(e) {
                        $($sticky).removeClass('custom-sticky');
                        
                    })
                    .on('sticky_kit:unbottom', function(e) {
                        $($sticky).addClass('custom-sticky');
                    });

                $(window).on('resize', function () {
                    $($sticky).trigger('sticky_kit:detach');
                });
            }
        }

        // WISHLIST
        
        $('body').on('click','.view-list-tours .category-name-heart .heart',function(e){
            let $tour_item = $(this).closest('.wishlist-hover');
            let tour_id = $tour_item.data('tour_id');
            let user_id = $tour_item.data('user_id');
            let $wishlist_icon = $(this);
            if(user_id=="" && user_id==0){
                if ( $('.alert-warning').length == 0){
                    $("body").append('<div class="alert alert-warning" role="alert" style="display: inline-block;position: fixed;right: 60px;top: 30px;z-index:999;" >Please login to use the feature!<button type="button" class="close" data-dismiss="alert" aria-label="Close" style="margin-left: 30px"><span aria-hidden="true">&times;</span></button></div>');
                    setTimeout(function(){
                        $('.alert-warning').remove();
                    },1500)
                }
                return;
            }
            let data = {
                task: "wishlist.change_wishlist",
                state: 1,
                tour_id: tour_id,
                user_id: user_id,
            };
            $.ajax({
                type: "POST",
                dataType: "json",
                url:wpbookingpro_root_url + wpbookingpro_api_task,
                data: data,
                beforeSend: function () {
                    if($wishlist_icon.hasClass('active')){
                        $wishlist_icon.toggleClass("active");
                    }
                    else{
                        $wishlist_icon.addClass('icon-loading animate-spin');
                        $wishlist_icon.find('span').hide();

                    }
                },
                error: function (xhr) {
                    
                },
                complete: function () {
                    if($wishlist_icon.hasClass('icon-loading animate-spin')){
                        $wishlist_icon.removeClass('icon-loading animate-spin');
                        $wishlist_icon.find('span').show();
                        $wishlist_icon.toggleClass("active");
                    }
                },
                success: function (response) {
                    response = JSON.parse(response);
                }
            });
        });
        

        plugin.filterSystem = function (minPrice, maxPrice) {
            $("#computers div.system").hide().filter(function () {
                var price = parseInt($(this).data("price"), 10);
                return price >= minPrice && price <= maxPrice;
            }).show();
        };
        plugin.debounce = function(func, wait) {
            var timeout;

            return function() {
                var context = this,
                    args = arguments;

                var executeFunction = function() {
                    func.apply(context, args);
                };

                clearTimeout(timeout);
                timeout = setTimeout(executeFunction, wait);
            };
        };
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_list_tours = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_list_tours')) {
                let plugin = new $.view_list_tours(this, options);
                $(this).data('view_list_tours', plugin);
            }
        });
    }
})(jQuery);
