"use strict";
(function ($) {
    if ( $('body').hasClass('home-2') ) {
        $.block_top_tour = function (element, options) {
            let defaults = {
                row_state_template: ""
            };
            let plugin = this;
            plugin.settings = {}
            let $element = $(element);
            plugin.init = function () {
                plugin.settings = $.extend({}, defaults, options);
                $element.find('#owl-carousel-top-tour').owlCarousel({
                    loop: true,
                    margin: 30,
                    autoplay:false,
                    autoHeight:true,
                    items:1,
                    nav: true,
                    dots: true,
                    navText: ["<span class='icon-nb-prev sprite left'></span>", "<span class='icon-nb-next sprite right'></span>"],
                })

            }
            plugin.example_function = function () {
            }
            plugin.init();
        }
    }else {
        $.block_top_tour = function (element, options) {
            let defaults = {
                row_state_template: ""
            };
            let plugin = this;
            plugin.settings = {}
            let $element = $(element);
            plugin.init = function () {
                plugin.settings = $.extend({}, defaults, options);
                setTimeout(function(){ 
                    $element.find('#owl-carousel-top-tour').owlCarousel({
                    loop: true,                    
                    autoplay:false,
                    nav: true,
                    autoHeight:true,
                    dots: false,
                        navText: ["<span class='icon-nb-prev sprite left'></span>", "<span class='icon-nb-next sprite right'></span>"],
                    responsive:{
                        0:{
                            items:1,
                            nav:false,
                            dots:true,
                            margin: 0,
                        },
                        768:{
                            items:2,
                            dots:true,
                            nav:false,
                            margin: 15,
                        },
                        992:{
                            items:3,
                            dots:true,
                            nav:true,
                            margin: 30,
                        }

                    }
                }) }, 10);
                
            }
            plugin.example_function = function () {
            }
            plugin.init();
        }
    }
    // WISHLIST
        
    $('body').on('click','.block_top_tour .category-name-heart .heart',function(e){
        let $tour_item = $(this).closest('.wishlist-hover');
        let tour_id = $tour_item.data('tour_id');
        let user_id = $tour_item.data('user_id');
        let $wishlist_icon = $(this);
        if(user_id=="" && user_id==0){
            if ( $('.alert-warning').length == 0){
                $("body").append('<div class="alert alert-warning" role="alert" style="display: inline-block;position: fixed;right: 60px;top: 30px;z-index:999;" >Please login to use the feature!<button type="button" class="close" data-dismiss="alert" aria-label="Close" style="margin-left: 30px"><span aria-hidden="true">&times;</span></button></div>');
                setTimeout(function(){
                    $('.alert-warning').remove();
                },1500)
            }
            return;
        }
        let data = {
            task: "wishlist.change_wishlist",
            state: 1,
            tour_id: tour_id,
            user_id: user_id,
        };
        $.ajax({
            type: "POST",
            dataType: "json",
            url:wpbookingpro_root_url + wpbookingpro_api_task,
            data: data,
            beforeSend: function () {
                if($wishlist_icon.hasClass('active')){
                    $wishlist_icon.toggleClass("active");
                }
                else{
                    $wishlist_icon.addClass('icon-loading animate-spin');
                    $wishlist_icon.find('span').hide();

                }
            },
            error: function (xhr) {
                
            },
            complete: function () {
                if($wishlist_icon.hasClass('icon-loading animate-spin')){
                    $wishlist_icon.removeClass('icon-loading animate-spin');
                    $wishlist_icon.find('span').show();
                    $wishlist_icon.toggleClass("active");
                }
            },
            success: function (response) {
                response = JSON.parse(response);
            }
        });
    });
    $.fn.block_top_tour = function (options) {
        return this.each(function () {
            if (undefined === $(this).data('block_top_tour')) {
                let plugin = new $.block_top_tour(this, options);
                $(this).data('block_top_tour' , plugin);
            }
        });
    }
})(jQuery);
