"use strict";
(function ($) {
    $.block_recent_articles = function (element, options) {
        let defaults = {
            row_state_template: ""
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            setTimeout(function () {
                $element.find('#owl-carousel-blog').owlCarousel({
                    loop: true,
                    margin: 30,
                    autoplay:false,
                    autoHeight:true,
                    nav: true,
                    dots: false,
                    navText: ["<span class='icon-nb-prev sprite left'></span>", "<span class='icon-nb-next sprite right'></span>"],
                    responsive:{
                        0:{
                            items:1,
                            nav:false,
                            dots:true
                        },
                        576:{
                            items:2,
                            nav:false,
                            dots:true
                        },
                        768:{
                            items:2,
                            dots:true,
                            nav:false,
                        },
                        992:{
                            items:3,
                            dots: true,
                            nav: true,
                        }

                    }
                })
            }, 10)
        }
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.block_recent_articles = function (options) {
        return this.each(function () {
            if (undefined === $(this).data('block_recent_articles')) {
                let plugin = new $.block_recent_articles(this, options);
                $(this).data('block_recent_articles'
                    , plugin);
            }
        });
    }
})(jQuery);

"use strict";
(function ($) {
    $.block_search_tour = function (element, options) {
        let defaults = {
            row_state_template: ""
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('select[name="destination"]').select2();
            $element.find('input[name="datetimes"]').daterangepicker({
                showDropdowns: true,
                minYear: 1970,
                locale: {
                    format: 'DD/MM/YYYY'
                },
                maxYear: '+10',
                minDate: moment().format('DD/MM/YYYY')
            }, function (start, end, label) {
                var years = moment().diff(start, 'years');
            });
            $element.find('#slider-container-1').slider({
                range: true,
                min: 0,
                max: 1099,
                values: [0, 1099],
                create: function () {
                    $("#amount_1").text("$0");
                    $("#amount_2").text("$1099");
                },
                slide: function (event, ui) {
                    $("#amount_1").text("$" + ui.values[0]);
                    $("#amount_2").text("$" + ui.values[1]);
                    var mi = ui.values[0];
                    var mx = ui.values[1];
                    plugin.filterSystem(mi, mx);
                },
                change: function(event, ui) {
                    var mi = ui.values[0];
                    var mx = ui.values[1];
                    let price_value=[];
                    price_value.push(mi);
                    price_value.push(mx);
                    $element.find(`input[name="price_search"]`).val(JSON.stringify(price_value));
                }
            });
            $element.find('#slider-container-2').slider({
                range: true,
                min: 0,
                max: 1099,
                values: [0, 1099],
                create: function () {
                    $("#amount_2").val("$0 - $1099");
                },
                slide: function (event, ui) {
                    $("#amount_2").val("$" + ui.values[0] + " - $" + ui.values[1]);
                    var mi = ui.values[0];
                    var mx = ui.values[1];
                    plugin.filterSystem(mi, mx);
                },
                change: function(event, ui) {
                    var mi = ui.values[0];
                    var mx = ui.values[1];
                    let price_value=[];
                    price_value.push(mi);
                    price_value.push(mx);
                    $element.find(`input[name="price_filter"]`).val(JSON.stringify(price_value));
                }
            });
            $element.find('.block-filter-price-more-option-2').slideUp();
            $element.find('.block-tour-categories-2').slideUp();
            $element.find('p.more-option').click(function (e) {
                let $block_more_option = $(this).closest('.block-more-option');
                $block_more_option.find('.block-filter-price-more-option-2').slideToggle();
                $block_more_option.find('.block-tour-categories-2').slideToggle();
            });

        };
        plugin.filterSystem = function (minPrice, maxPrice) {
            $("#computers div.system").hide().filter(function () {
                var price = parseInt($(this).data("price"), 10);
                return price >= minPrice && price <= maxPrice;
            }).show();
        }
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.block_search_tour = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('block_search_tour')) {
                let plugin = new $.block_search_tour(this, options);
                $(this).data('block_search_tour', plugin);
            }
        });
    }
    $('div.dropdown-menu').on('click', function(event){
        // The event won't be propagated up to the document NODE and
        // therefore delegated events won't be fired
        event.stopPropagation();
    });
})(jQuery);

"use strict";
(function ($) {
    if ( $('body').hasClass('home-2') != true ) {
        $.block_top_destination = function (element, options) {
            let defaults = {
                row_state_template: ""
            };
            let plugin = this;
            plugin.settings = {}
            let $element = $(element);
            plugin.init = function () {
                plugin.settings = $.extend({}, defaults, options);
                setTimeout(function () {
                    $element.find('#owl-carousel-top-destinations').owlCarousel({
                        loop: true,
                        margin: 30,
                        autoplay:false,
                        nav: true,
                        dots: false,
                        navText: ["<span class='icon-nb-prev sprite left'></span>", "<span class='icon-nb-next sprite right'></span>"],
                        responsive:{
                            0:{
                                items:1,
                                nav:false,
                                dots:true
                            },
                            576:{
                                items:2,
                                nav:false,
                                dots:true
                            },
                            768:{
                                items:2,
                                dots:true,
                                nav:false,
                            },
                            992:{
                                items:3,
                                dots: true,
                                nav: true,
                            }

                        }
                    })
                }, 10)

            }
            plugin.example_function = function () {
            }
            plugin.init();
        }
        $.fn.block_top_destination = function (options) {
            return this.each(function () {
                if (undefined === $(this).data('block_top_destination')) {
                    let plugin = new $.block_top_destination(this, options);
                    $(this).data('block_top_destination' , plugin);
                }
            });
        }
    }else {
        $.block_top_destination = function (element, options) {
            let defaults = {
                row_state_template: ""
            };
            let plugin = this;
            plugin.settings = {}
            let $element = $(element);
            plugin.init = function () {
            }
            plugin.example_function = function () {
            }
            plugin.init();
        }
        $.fn.block_top_destination = function (options) {
        }
    }
    
})(jQuery);

"use strict";
(function ($) {
    if ( $('body').hasClass('home-2') ) {
        $.block_top_tour = function (element, options) {
            let defaults = {
                row_state_template: ""
            };
            let plugin = this;
            plugin.settings = {}
            let $element = $(element);
            plugin.init = function () {
                plugin.settings = $.extend({}, defaults, options);
                $element.find('#owl-carousel-top-tour').owlCarousel({
                    loop: true,
                    margin: 30,
                    autoplay:false,
                    autoHeight:true,
                    items:1,
                    nav: true,
                    dots: true,
                    navText: ["<span class='icon-nb-prev sprite left'></span>", "<span class='icon-nb-next sprite right'></span>"],
                })

            }
            plugin.example_function = function () {
            }
            plugin.init();
        }
    }else {
        $.block_top_tour = function (element, options) {
            let defaults = {
                row_state_template: ""
            };
            let plugin = this;
            plugin.settings = {}
            let $element = $(element);
            plugin.init = function () {
                plugin.settings = $.extend({}, defaults, options);
                setTimeout(function(){ 
                    $element.find('#owl-carousel-top-tour').owlCarousel({
                    loop: true,                    
                    autoplay:false,
                    nav: true,
                    autoHeight:true,
                    dots: false,
                        navText: ["<span class='icon-nb-prev sprite left'></span>", "<span class='icon-nb-next sprite right'></span>"],
                    responsive:{
                        0:{
                            items:1,
                            nav:false,
                            dots:true,
                            margin: 0,
                        },
                        768:{
                            items:2,
                            dots:true,
                            nav:false,
                            margin: 15,
                        },
                        992:{
                            items:3,
                            dots:true,
                            nav:true,
                            margin: 30,
                        }

                    }
                }) }, 10);
                
            }
            plugin.example_function = function () {
            }
            plugin.init();
        }
    }
    // WISHLIST
        
    $('body').on('click','.block_top_tour .category-name-heart .heart',function(e){
        let $tour_item = $(this).closest('.wishlist-hover');
        let tour_id = $tour_item.data('tour_id');
        let user_id = $tour_item.data('user_id');
        let $wishlist_icon = $(this);
        if(user_id=="" && user_id==0){
            if ( $('.alert-warning').length == 0){
                $("body").append('<div class="alert alert-warning" role="alert" style="display: inline-block;position: fixed;right: 60px;top: 30px;z-index:999;" >Please login to use the feature!<button type="button" class="close" data-dismiss="alert" aria-label="Close" style="margin-left: 30px"><span aria-hidden="true">&times;</span></button></div>');
                setTimeout(function(){
                    $('.alert-warning').remove();
                },1500)
            }
            return;
        }
        let data = {
            task: "wishlist.change_wishlist",
            state: 1,
            tour_id: tour_id,
            user_id: user_id,
        };
        $.ajax({
            type: "POST",
            dataType: "json",
            url:wpbookingpro_root_url + wpbookingpro_api_task,
            data: data,
            beforeSend: function () {
                if($wishlist_icon.hasClass('active')){
                    $wishlist_icon.toggleClass("active");
                }
                else{
                    $wishlist_icon.addClass('icon-loading animate-spin');
                    $wishlist_icon.find('span').hide();

                }
            },
            error: function (xhr) {
                
            },
            complete: function () {
                if($wishlist_icon.hasClass('icon-loading animate-spin')){
                    $wishlist_icon.removeClass('icon-loading animate-spin');
                    $wishlist_icon.find('span').show();
                    $wishlist_icon.toggleClass("active");
                }
            },
            success: function (response) {
                response = JSON.parse(response);
            }
        });
    });
    $.fn.block_top_tour = function (options) {
        return this.each(function () {
            if (undefined === $(this).data('block_top_tour')) {
                let plugin = new $.block_top_tour(this, options);
                $(this).data('block_top_tour' , plugin);
            }
        });
    }
})(jQuery);

"use strict";
(function ($) {
    $.block_tour_destination = function (element, options) {
        let defaults = {
            row_state_template: ""
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('#owl-carousel-top-destinations').owlCarousel({
                loop: true,
                margin: 30,
                autoplay:false,
                nav: true,
                dots: false,
                navText: ["<span class='icon-nb-prev sprite left'></span>", "<span class='icon-nb-next sprite right'></span>"],
                responsive:{
                    0:{
                        items:1,
                        nav:false,
                        dots:true
                    },
                    576:{
                        items:2,
                        nav:false,
                        dots:true
                    },
                    768:{
                        items:2,
                        dots:true,
                        nav:false,
                    },
                    992:{
                        items:3,
                        dots:true,
                        nav:true,
                    }

                }
            })
        }
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.block_tour_destination = function (options) {
        return this.each(function () {
            if (undefined === $(this).data('block_tour_destination')) {
                let plugin = new $.block_tour_destination(this, options);
                $(this).data('block_tour_destination'
                    , plugin);
            }
        });
    }
})(jQuery);

"use strict";
(function ($) {
    $.block_tour_popular_in_month = function (element, options) {
        let defaults = {
            row_state_template: ""
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            setTimeout(function(){
                $element.find('#owl-carousel-top-tour-popular').owlCarousel({
                loop: true,
                margin: 30,
                autoplay:false,
                autoHeight:true,
                nav: true,
                dots: false,
                    navText: ["<span class='icon-nb-prev sprite left'></span>", "<span class='icon-nb-next sprite right'></span>"],
                responsive:{
                    0:{
                        items:1,
                        nav:false,
                        dots:true
                    },
                    768:{
                        items:2,
                        dots:true,
                        nav:false,
                    },
                    992:{
                        items:3,
                        dots:true,
                        nav:true,
                    }

                }
            }) }, 10);
            // WISHLIST
        
            $('body').on('click','.block_tour_popular_in_month .category-name-heart .heart',function(e){
                let $tour_item = $(this).closest('.wishlist-hover');
                let tour_id = $tour_item.data('tour_id');
                let user_id = $tour_item.data('user_id');
                let $wishlist_icon = $(this);
                if(user_id=="" && user_id==0){
                    if ( $('.alert-warning').length == 0){
                        $("body").append('<div class="alert alert-warning" role="alert" style="display: inline-block;position: fixed;right: 60px;top: 30px;z-index:999;" >Please login to use the feature!<button type="button" class="close" data-dismiss="alert" aria-label="Close" style="margin-left: 30px"><span aria-hidden="true">&times;</span></button></div>');
                        setTimeout(function(){
                            $('.alert-warning').remove();
                        },1500)
                    }
                    return;
                }
                let data = {
                    task: "wishlist.change_wishlist",
                    state: 1,
                    tour_id: tour_id,
                    user_id: user_id,
                };
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url:wpbookingpro_root_url + wpbookingpro_api_task,
                    data: data,
                    beforeSend: function () {
                        if($wishlist_icon.hasClass('active')){
                            $wishlist_icon.toggleClass("active");
                        }
                        else{
                            $wishlist_icon.addClass('icon-loading animate-spin');
                            $wishlist_icon.find('span').hide();

                        }
                    },
                    error: function (xhr) {
                        
                    },
                    complete: function () {
                        if($wishlist_icon.hasClass('icon-loading animate-spin')){
                            $wishlist_icon.removeClass('icon-loading animate-spin');
                            $wishlist_icon.find('span').show();
                            $wishlist_icon.toggleClass("active");
                        }
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                    }
                });
            });
        }
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.block_tour_popular_in_month = function (options) {
        return this.each(function () {
            if (undefined === $(this).data('block_tour_popular_in_month')) {
                let plugin = new $.block_tour_popular_in_month(this, options);
                $(this).data('block_tour_popular_in_month'
                    , plugin);
            }
        });
    }
})(jQuery);

jQuery(document).ready(function ($) {
    "use strict";
    $(window).on('elementor/frontend/init', function () {

        elementorFrontend.hooks.addAction('frontend/element_ready/section', function ($element) {
            var galleryTop = new Swiper('.elementor-nb_icon_box-wrapper', {
                spaceBetween: 30,
                slidesPerView: 1,
                autoHeight: true,
                observer: true,
                observeParents: true,
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                },
                pagination: {
                    el: '.swiper-pagination',
                    clickable: true,
                },
                breakpoints: {
                    // when window width is >= 576px
                    576: {
                        slidesPerView: 2,
                        spaceBetween: 20
                    },
                    // when window width is >= 768px
                    768: {
                        slidesPerView: 3,
                        spaceBetween: 20
                    }
                }
            });
        });

    });
});
jQuery(document).ready(function() {
    jQuery(".has-account a,.lost").click(function() {
        jQuery(".tab_content_login").hide();
        var activeTab = jQuery(this).attr("href");
        jQuery(activeTab).show();
    });
});
jQuery(document).ready(function($) {
    $('a#show_login,a.show_login').on('click', function(e){
        $('.torhub-singup-register').after('<div class="login_overlay"></div>');
        $('.torhub-singup-register').fadeIn(500);
        $('div.login_overlay, #login-register-password a.close').on('click', function(event){
            event.preventDefault();
            $('div.login_overlay').remove();
            $('.torhub-singup-register').hide();
        });
        e.preventDefault();
    });
});
jQuery(document).ready(function($) {
    let $login = $('.torhub-singup-register').find('.tab_container_login');
    let $url_add = torhub_elements.siteUrl+'/sellercenter/wb_hotel/?layout=form';
    if ($login.length > 0) {
        $('li.button-header,.add-hotel a').on('click', function(e){
            $('.torhub-singup-register').after('<div class="login_overlay"></div>');
            $('.torhub-singup-register').fadeIn(500);
            $('div.login_overlay, #login-register-password a.close').on('click', function(event){
                event.preventDefault();
                $('div.login_overlay').remove();
                $('.torhub-singup-register').hide();
            });
            e.preventDefault();
        });
    }
    else{
        $('li.button-header>a,.add-hotel a').attr('href',$url_add);
    }
});


jQuery(document).ready(function () {
    // Show the first tab and hide the rest
    jQuery('.widget_nb_recent_posts_widget #tabs-nav li:first-child').addClass('active');
    jQuery('.widget_nb_recent_posts_widget .tab-content').hide();
    jQuery('.widget_nb_recent_posts_widget .tab-content:first').show();

    // Click function
    jQuery('.widget_nb_recent_posts_widget #tabs-nav li').click(function () {
        jQuery('.widget_nb_recent_posts_widget #tabs-nav li').removeClass('active');
        jQuery(this).addClass('active');
        jQuery('.widget_nb_recent_posts_widget .tab-content').hide();

        var activeTab = jQuery(this).find('a').attr('href');
        jQuery(activeTab).fadeIn();
        return false;
    });
});

jQuery(document).ready(function ($) {

    "use strict";
    $(window).on('elementor/frontend/init', function() {
        
        elementorFrontend.hooks.addAction( 'frontend/element_ready/section', function( $element ) {
            $(".nb-testimonials-container").each(function(){
        
                var $this           = $(this),
                    currentID       = $this.attr('id'),
                    style           = $this.attr('data-style'),
                    currentSelector = '#' + currentID + ' .nb-testimonials-wrapper';
    
                
                if(style == "multiple_column") {
                    var testimonialParams = {
                        grabCursor: false,
                        slidesPerView: 1,                        
                        spaceBetween: 30,
                        pagination: {
                            el: '#' + currentID + ' .swiper-pagination',
                            clickable: true,
                        },
                        navigation: {
                            nextEl: '#' + currentID + ' .swiper-button-next',
                            prevEl: '#' + currentID + ' .swiper-button-prev',
                        },
                        observer: true,
                        observeParents: true,
                        breakpoints: {
                            // when window width is >= 576px
                            576: {
                                slidesPerView: 1,
                                spaceBetween: 20
                            },
                            // when window width is >= 768px
                            768: {
                                slidesPerView: 2,
                                spaceBetween: 20
                            },
                            // when window width is >= 992px
                            992: {
                                slidesPerView: 2
                            }
                        }
                    }
                    var testimonialSwiper = new Swiper(currentSelector, testimonialParams);                    
                }
                else if(style == "one_column") {
                    var testimonialParams = {
                        grabCursor: false,
                        slidesPerView: 1,
                        slidesPerColumn: 1,
                        pagination: {
                            el: '#' + currentID + ' .swiper-pagination',
                            clickable: true,
                        },
                        observer: true,
                        observeParents: true,
                        navigation: {
                            nextEl: '#' + currentID + ' .swiper-button-next',
                            prevEl: '#' + currentID + ' .swiper-button-prev',
                        },
                    }
                    var testimonialSwiper = new Swiper(currentSelector, testimonialParams);

                    testimonialSwiper.on('slideChange', function () {
                        $('#' + currentID + " .swiper-pagination-bullet").removeClass("swiper-pagination-bullet-active");
                        $('#' + currentID + " .swiper-pagination-bullet:eq("+testimonialSwiper.activeIndex+")").addClass("swiper-pagination-bullet-active");
                    });
                }
                else if(style == "sync_thumbnail_content") {
    
                    var avatarParams = {
                        initialSlide: 1,
                        slidesPerView: 3,
                        centeredSlides: true,
                        slideToClickedSlide: true,
                        observer: true,
                        observeParents: true,
                        // spaceBetween:
                    };
    
                    var contentParams = {
                        grabCursor: false,
                        initialSlide: 1,
                        slidesPerView: 1,
                        centeredSlides: true,
                        observer: true,
                        observeParents: true,
                        pagination: {
                            el: '.testimonial-pagination',
                            clickable: true,
                        },
                        navigation: {
                            nextEl: '.swiper-button-next',
                            prevEl: '.swiper-button-prev',
                        },
                    };
    
    
                    var avatarSelector = '#' + currentID + ' .nb-testimonials-avatar-wrapper';
                    var contentSelector = '#' + currentID + ' .nb-testimonials-content-wrapper';
                    
                    var avatarSwiper = new Swiper(avatarSelector, avatarParams);
                    var contentSwiper = new Swiper(contentSelector, contentParams);
    
                    avatarSwiper.on( 'slideChange', function () {
    
                        var currentIndex = avatarSwiper.activeIndex;
                        contentSwiper.slideTo( currentIndex, 300, false );
    
                    });
    
                    contentSwiper.on('slideChange', function () {
    
                        var currentIndex = contentSwiper.activeIndex;
                        avatarSwiper.slideTo( currentIndex, 300, false );
                        contentSwiper.update();
    
                    });
                }
    
                
            });
        });

    });
});
jQuery(document).ready(function ($) {

    "use strict";
    $(window).on('elementor/frontend/init', function () {

        elementorFrontend.hooks.addAction('frontend/element_ready/section', function ($element) {
            var galleryThumbs = new Swiper('.gallery-thumbs', {
                spaceBetween: 10,
                slidesPerView: 4,
                observer: true,
                observeParents: true,
                freeMode: true,
                watchSlidesVisibility: true,
                watchSlidesProgress: true,
            });
            var galleryTop = new Swiper('.gallery-top', {
                spaceBetween: 10,
                observer: true,
                observeParents: true,
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                },
                thumbs: {
                    swiper: galleryThumbs
                }
            });
        });

    });
});
"use strict";
(function ($) {
    $.view_list_tourlocator = function (element, options) {
        let defaults = {
            row_state_template: "",
            data_input:[],
            render_tour_item_grid:"",
            render_tour_item_list:"",
            items_per_page: 8,
            visiblePages: 3,
            min_price:0,
            max_price:1099
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let min_price=parseInt(plugin.settings.min_price);
            let max_price=parseInt(plugin.settings.max_price);
            plugin.filterSystem(10, 100);
            $element.find('select[name="destination"]').select2();
            $element.find('input[name="datetimes"]').daterangepicker({
                showDropdowns: true,
                minYear: 1970,
                locale: {
                    format: 'DD/MM/YYYY'
                },
                maxYear: '+10',
                minDate: moment().format('DD/MM/YYYY')
            }, function (start, end, label) {
                var years = moment().diff(start, 'years');
            });
            $element.find('#slider-container-1').slider({
                range: true,
                min: 0,
                max: plugin.settings.max_price,
                values: [min_price, max_price],
                create: function () {
                    $("#amount_1").text("$0");
                    $("#amount_2").text("$1099");
                },
                slide: function (event, ui) {
                    $("#amount_1").text("$" + ui.values[0]);
                    $("#amount_2").text("$" + ui.values[1]);
                    var mi = ui.values[0];
                    var mx = ui.values[1];
                    plugin.filterSystem(mi, mx);
                },
                change: function(event, ui) {
                    var mi = ui.values[0];
                    var mx = ui.values[1];
                    let price_value=[];
                    price_value.push(mi);
                    price_value.push(mx);
                    $element.find(`input[name="price_search"]`).val(JSON.stringify(price_value)).trigger('change');
                }
            });
            $element.find('input[name="sorting_by"]').iCheck({
                checkboxClass: 'icheckbox_minimal',
                radioClass: 'iradio_minimal',
                increaseArea: '20%'
            });
            // $element.find('.block-filter-price-more-option').slideUp();
            // $element.find('.block-tour-categories').slideUp();
            $element.find('p.more-option').click(function (e) {
                let $block_more_option = $(this).closest('.block-more-option');
                $block_more_option.find('.block-filter-price-more-option').slideToggle();
                $block_more_option.find('.block-tour-categories').slideToggle();
            });
            $element.find('.title-item').click(function (e) {
                let $parent = $(this).parent();
                $parent.find('div:nth-child(2)').slideToggle();
                $(this).toggleClass('slide-up')
            });

            // Map locator

            var scrollMap = plugin.debounce(function () {
                var $sticky = $element.find('#bh-sl-map');
                if ($sticky.length > 0) {
                    $($sticky).stick_in_parent()
                        .on('sticky_kit:bottom', function(e) {
                            $($sticky).removeClass('custom-sticky');
                        })
                        .on('sticky_kit:unbottom', function(e) {
                            $($sticky).addClass('custom-sticky');
                        });

                    $(window).on('resize', function () {
                        $($sticky).trigger('sticky_kit:detach');
                    });
                }
            }, 250);
            $(window).scroll(scrollMap);

            var filterAjax = plugin.debounce(function () {
                let $form = $('form[name="filter-form"]');
                $form.submit();
            }, 1000);

            // $element.find("select[name='destination']").on('change',filterAjax);
            // $element.find("input[name='datetimes']").on('change',filterAjax);
            // $element.find("input[name='price_search']").on('change',filterAjax);
            // $element.find("input[name='tour_type[]']").on('change',filterAjax);
            // $element.find(".block-display-button .nav-tabs li").on('click',filterAjax);
            
            $('.title-load-more').next('.block-filter-load-more').slideUp();
            $('body').on('click','.title-load-more', function() {
                $(this).addClass('active');
                $(this).find("span").toggleClass("icon-minus icon-plus",300);
                $(this).next('.block-filter-load-more').slideToggle("slow");
            });

            $('#bh-sl-map-container').storeLocator({
                ajaxData:function (e) {
                    var output = plugin.convert_data_form();
                    let dataObj = {};
                    $(output).each(function(i, field){
                        dataObj[field.name] = field.value;
                    });
                    return dataObj;
                },
                'test': 'test',
                'querystringParams' : true,
                'fullMapStart': true,
                'pagination': true,
                'dataLocation': `${wpbookingpro_root_url}${wpbookingpro_api_task}/?task=tours.ajax_get_list_tour`,
                'infowindowTemplatePath': `${wpbookingpro_root_url}/wp-content/plugins/touroperatorpro/frontend/resources/store_locator/assets/js/plugins/storeLocator/templates/infowindow-description.html`,
                'listTemplatePath': `${wpbookingpro_root_url}/wp-content/plugins/touroperatorpro/frontend/resources/store_locator/assets/js/plugins/storeLocator/templates/location-list-description.html`,
                'gridTemplatePath': `${wpbookingpro_root_url}/wp-content/plugins/touroperatorpro/frontend/resources/store_locator/assets/js/plugins/storeLocator/templates/location-grid-description.html`,
            });

            // FILTER AJAX

            var $limit = parseInt($element.find('input[name="limit"]').val());
            var listingAjaxEvent = plugin.debounce(function(listing_event) {
                if(listing_event != 'loadMore'){
                    $element.find('input[name="start"]').val(0);
                    $element.find('input[name="total_show"]').val($limit);
                }
                var output = plugin.convert_data_form();
                let dataObj = {}
                $(output).each(function(i,field) {
                    dataObj[field.name] = field.value;
                })
                plugin.listing_ajax(dataObj,listing_event);
            }, 300);
            $element.find("select[name='destination']").on('change',filterAjax);
            $element.find("input[name='datetimes']").on('change',filterAjax);
            $element.find("input[name='price_search']").on('change',filterAjax);
            $element.find("input[name='tour_type[]']").on('change',filterAjax);
            $element.find(".block-display-button .nav-tabs li").on('click',function(){
                let layout = $(this).data('layout');
                $element.find('input[name="tab"]').val(layout);
                filterAjax();
            });
            $element.find('.sort-display a').click(function(){
                let sort=$(this).data('key_sort');
                let direction=$(this).data('direction');
                $element.find('input[name="key_sort"]').val(sort);
                $element.find('input[name="start"]').val(0);
                $element.find('input[name="direction"]').val(direction);
                $element.find('.sort-by-block .dropdown').removeClass('open');
                plugin.sortBy();
            });
            $element.find('.sort-display a').click(filterAjax); 
            $element.find("#pagination-tours-ajax").on('click',function(){
                let $start = parseInt($element.find('input[name="start"]').val());
                let $total_show = parseInt($element.find('input[name="total_show"]').val());
                $start +=$limit;
                $total_show +=$limit;
                $element.find('input[name="start"]').val($start);
                $element.find('input[name="total_show"]').val($total_show);
                filterAjax();
            });


            var $height = $('.nojq').height();
            var $height1 = 0;
            

            // plugin.sticky_sidebar()
            $(window).on('resize', function () {
                // plugin.sticky_sidebar()
            });

            $(window).scroll(function() {
                $height1 = $('.header-middle.stuck').height();
                var a = $height1 + $height + 30;
                $element.find('.wrapper-search-tour.custom-sticky.is_stuck').css({
                    'top' : a+'px' ,
                    'transition':'top 0.3s'
                })
            });
            plugin.sortBy();
        };
        plugin.sortBy = function(){
            var $direction = $element.find('input[name="direction"]').val();
            var $sort = $element.find('input[name="key_sort"]').val();
            if($direction === "ASC" && $sort === "a.name"){
                $element.find('.select-by-default').text('Sort by name from A-Z');
            } else if($direction === "DESC" && $sort === "a.name"){
                $element.find('.select-by-default').text('Sort by name from Z-A');
            } else if($direction === "ASC" && $sort === "a.price"){
                $element.find('.select-by-default').text('Sort by ascending price');
            } else if($direction === "DESC" && $sort === "a.price"){
                $element.find('.select-by-default').text('Sort by descending price');
            } else {
                $element.find('.select-by-default').text('Sort by');
            }
        }
        var $y;
        plugin.listing_ajax= function(dataObj,listing_event){
            $.ajax({
                url:wpbookingpro_root_url + wpbookingpro_api_task,
                type: 'POST',
                dataType: 'json',
                data: {
                    dataObj: JSON.stringify(dataObj),
                    task: "tours.get_list_tours_ajax_form",
                    page_tour_detail: plugin.settings.page_tour_detail
                },
                beforeSend: function(){
                    $y = window.pageYOffset;
                },
                success: function(res){
                    let data= JSON.parse(res);
                    if (listing_event !='tab'){
                        $element.find('#pagination-tours-ajax').show();
                        if( data.data.template1 || data.data.template2) {
                            if (listing_event !='loadMore'){
                                $element.find('.wrapper-tour-list').empty(data.data.template2);
                                $element.find('.wrapper-tour-grid').empty(data.data.template1);
                            }
    
                            $element.find('.wrapper-tour-list').append(data.data.template2);
                            $element.find('.wrapper-tour-grid').append(data.data.template1);
                        }
                        if( data.data.total) {
                            $element.find('.block-top-result .result-title h3').text(data.data.total + " Tours found");
                        }else{
                            $element.find('.block-top-result .result-title h3').text("0 Tours found");
                        }
                        if (data.data.total_show >= data.data.total) {
                            $element.find('#pagination-tours-ajax').hide();
                        }
                        plugin.sortBy();

                    }
                },
                error: function(){

                },
                complete: function(){
                    if (history.pushState) {
                        var $params = "";
                        $.each(dataObj, function(index, val) {
                            if (index == 'start' || index == 'limit' || index == 'total_show' || index == 'page' || index == 'curent_user_id'){
                                delete dataObj[index];
                            }else{
                                if( index == "destination" ) {
                                    $params += "?"+index+"="+val;
                                }else{
                                    $params += "&"+index+"="+val;
                                }
                            }
                        });
                        var newurl = window.location.protocol + "//" + window.location.host + window.location.pathname + $params;
                        window.history.pushState({path:newurl},'',newurl);
                    }
                    window.scrollTo(0,$y);
                }
                
            })
        };
        plugin.convert_data_form = function() {
            var dataArray = $element.find('.form-search-tour').serializeArray();
            var output = [];
            dataArray.forEach(function(item) {
                var existing = output.filter(function(v, i) {
                    return v.name == item.name;
                });
                if (existing.length) {
                    var existingIndex = output.indexOf(existing[0]);
                    output[existingIndex].value = output[existingIndex].value.concat(item.value);
                } else {
                    if (typeof item.value == 'string')
                        item.value = [item.value];
                    output.push(item);
                }
            });
            return output;
        };

        // STICKY SIDEBAR

        // plugin.sticky_sidebar=function(){
        //     var $sticky = $element.find('.wrapper-search-tour');
        //     if ($sticky.length > 0) {
        //         $($sticky).stick_in_parent()
        //             .on('sticky_kit:bottom', function(e) {
        //                 $($sticky).removeClass('custom-sticky');
                        
        //             })
        //             .on('sticky_kit:unbottom', function(e) {
        //                 $($sticky).addClass('custom-sticky');
        //             });

        //         $(window).on('resize', function () {
        //             $($sticky).trigger('sticky_kit:detach');
        //         });
        //     }
        // }

        // WISHLIST
        
        $('body').on('click','.view-list-tours .category-name-heart .heart',function(e){
            let $tour_item = $(this).closest('.wishlist-hover');
            let tour_id = $tour_item.data('tour_id');
            let user_id = $('.view-list-tourlocator').data('user_id');
            let $wishlist_icon = $(this);
            if(user_id=="" && user_id==0){
                if ( $('.alert-warning').length == 0){
                    $("body").append('<div class="alert alert-warning" role="alert" style="display: inline-block;position: fixed;right: 60px;top: 30px;z-index:999;" >Please login to use the feature!<button type="button" class="close" data-dismiss="alert" aria-label="Close" style="margin-left: 30px"><span aria-hidden="true">&times;</span></button></div>');
                    setTimeout(function(){
                        $('.alert-warning').remove();
                    },1500)
                }
                return;
            }
            let data = {
                task: "wishlist.change_wishlist",
                state: 1,
                tour_id: tour_id,
                user_id: user_id,
            };
            $.ajax({
                type: "POST",
                dataType: "json",
                url:wpbookingpro_root_url + wpbookingpro_api_task,
                data: data,
                beforeSend: function () {
                    if($wishlist_icon.hasClass('active')){
                        $wishlist_icon.toggleClass("active");
                    }
                    else{
                        $wishlist_icon.addClass('icon-loading animate-spin');
                        $wishlist_icon.find('span').hide();

                    }
                },
                error: function (xhr) {
                    
                },
                complete: function () {
                    if($wishlist_icon.hasClass('icon-loading animate-spin')){
                        $wishlist_icon.removeClass('icon-loading animate-spin');
                        $wishlist_icon.find('span').show();
                        $wishlist_icon.toggleClass("active");
                    }
                },
                success: function (response) {
                    response = JSON.parse(response);
                }
            });
        });
        

        plugin.filterSystem = function (minPrice, maxPrice) {
            $("#computers div.system").hide().filter(function () {
                var price = parseInt($(this).data("price"), 10);
                return price >= minPrice && price <= maxPrice;
            }).show();
        };
        plugin.debounce = function(func, wait) {
            var timeout;

            return function() {
                var context = this,
                    args = arguments;

                var executeFunction = function() {
                    func.apply(context, args);
                };

                clearTimeout(timeout);
                timeout = setTimeout(executeFunction, wait);
            };
        };
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_list_tourlocator = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_list_tourlocator')) {
                let plugin = new $.view_list_tourlocator(this, options);
                $(this).data('view_list_tourlocator', plugin);
            }
        });
    }
})(jQuery);

"use strict";
(function ($) {
    $.view_list_tours = function (element, options) {
        let defaults = {
            row_state_template: "",
            data_input:[],
            render_tour_item_grid:"",
            render_tour_item_list:"",
            items_per_page: 8,
            visiblePages: 3,
            min_price:0,
            max_price:1099
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let min_price=parseInt(plugin.settings.min_price);
            let max_price=parseInt(plugin.settings.max_price);
            plugin.filterSystem(10, 100);
            $element.find('select[name="destination"]').select2();
            $element.find('input[class="datetimes"]').daterangepicker({
                showDropdowns: true,
                minYear: 1970,
                locale: {
                    format: 'YYYY/MM/DD'
                },
                maxYear: '+10',
                minDate: moment().format('YYYY-MM-DD')
            }, function (start, end, label) {
                var years = moment().diff(start, 'years');
                let rate = `${start.format('YYYY-MM-DD')};${end.format('YYYY-MM-DD')}`;
                $element.find('input[name="rate"]').val(rate)
            });
            $element.find('#slider-container-1').slider({
                range: true,
                min: 0,
                max: plugin.settings.max_prices,
                values: [min_price, max_price],
                create: function () {
                    $("#amount_1").text("$0");
                    $("#amount_2").text("$1099");
                },
                slide: function (event, ui) {
                    $("#amount_1").text("$" + ui.values[0]);
                    $("#amount_2").text("$" + ui.values[1]);
                    var mi = ui.values[0];
                    var mx = ui.values[1];
                    plugin.filterSystem(mi, mx);
                },
                change: function(event, ui) {
                    var mi = ui.values[0];
                    var mx = ui.values[1];
                    let price_value=[];
                    price_value.push(mi);
                    price_value.push(mx);
                    $element.find(`input[name="price_search"]`).val(JSON.stringify(price_value)).trigger('change');
                }
            });
            $element.find('input[name="sorting_by"]').iCheck({
                checkboxClass: 'icheckbox_minimal',
                radioClass: 'iradio_minimal',
                increaseArea: '20%'
            });
            $element.find('.block-filter-price-more-option').slideUp();
            $element.find('.block-tour-categories').slideUp();
            $element.find('p.more-option').click(function (e) {
                let $block_more_option = $(this).closest('.block-more-option');
                $block_more_option.find('.block-filter-price-more-option').slideToggle();
                $block_more_option.find('.block-tour-categories').slideToggle();
            });
            $element.find('.title-item').click(function (e) {
                let $parent = $(this).parent();
                $parent.find('div:nth-child(2)').slideToggle();
                $(this).toggleClass('slide-up')
            });


            // FILTER AJAX

            var $limit = parseInt($element.find('input[name="limit"]').val());
            var listingAjaxEvent = plugin.debounce(function(listing_event) {
                if(listing_event != 'loadMore'){
                    $element.find('input[name="start"]').val(0);
                    $element.find('input[name="total_show"]').val($limit);
                }
                var output = plugin.convert_data_form();
                let dataObj = {}
                $(output).each(function(i,field) {
                    dataObj[field.name] = field.value;
                })
                plugin.listing_ajax(dataObj,listing_event);
            }, 300);
            $element.find("select[name='destination']").on('change',listingAjaxEvent);
            $element.find("input[name='datetimes']").on('change',listingAjaxEvent);
            $element.find("input[name='price_search']").on('change',listingAjaxEvent);
            $element.find("input[name='tour_type[]']").on('change',listingAjaxEvent);
            $('body').find(".applyBtn").on('click',function(){
                listingAjaxEvent();
            });
            $element.find(".block-display-button .nav-tabs li").on('click',function(){
                let layout = $(this).data('layout');
                $element.find('input[name="tab"]').val(layout);
                listingAjaxEvent('tab');
            });
            $element.find("#pagination-tours-ajax").on('click',function(){
                let $start = parseInt($element.find('input[name="start"]').val());
                let $total_show = parseInt($element.find('input[name="total_show"]').val());
                $start +=$limit;
                $total_show +=$limit;
                $element.find('input[name="start"]').val($start);
                $element.find('input[name="total_show"]').val($total_show);
                listingAjaxEvent('loadMore');
            });
            $element.find('.sort-display a').click(function(){
                let sort=$(this).data('key_sort');
                let direction=$(this).data('direction');
                $element.find('input[name="key_sort"]').val(sort);
                $element.find('input[name="start"]').val(0);
                $element.find('input[name="direction"]').val(direction);
                $element.find('.sort-by-block .dropdown').removeClass('open');
                plugin.sortBy()
            });  
            $element.find('.sort-display a').click(listingAjaxEvent); 

            var $height = $('.nojq').height();
            var $height1 = 0;
            

            plugin.sticky_sidebar();
            $(window).on('resize', function () {
                plugin.sticky_sidebar();
            });
            plugin.sortBy();
            $(window).scroll(function() {
                $height1 = $('.header-middle.stuck').height();
                var a = $height1 + $height + 30;
                $element.find('.wrapper-search-tour.custom-sticky.is_stuck').css({
                    'top' : a+'px' ,
                    'transition':'top 0.3s'
                })
            });
            $(window).on('load', function () {
                let $total_record = plugin.settings.total_record;
                let $total_show = $element.find('input[name="total_show"]').val();
                if ($total_show >= $total_record) {
                    $element.find('#pagination-tours-ajax').hide();
                }
            });
        };
        plugin.sortBy = function(){
            var $direction = $element.find('input[name="direction"]').val();
            var $sort = $element.find('input[name="key_sort"]').val();
            if($direction === "ASC" && $sort === "a.name"){
                $element.find('.select-by-default').text('Sort by name from A-Z');
            } else if($direction === "DESC" && $sort === "a.name"){
                $element.find('.select-by-default').text('Sort by name from Z-A');
            } else if($direction === "ASC" && $sort === "a.price"){
                $element.find('.select-by-default').text('Sort by ascending price');
            } else if($direction === "DESC" && $sort === "a.price"){
                $element.find('.select-by-default').text('Sort by descending price');
            } else {
                $element.find('.select-by-default').text('Sort by');
            }
        }
        var $y;
        plugin.listing_ajax= function(dataObj,listing_event){
            $.ajax({
                url:wpbookingpro_root_url + wpbookingpro_api_task,
                type: 'POST',
                dataType: 'json',
                data: {
                    dataObj: JSON.stringify(dataObj),
                    task: "tours.get_list_tours_ajax_form",
                    page_tour_detail: plugin.settings.page_tour_detail
                },
                beforeSend: function(){
                    $y = window.pageYOffset;
                    $('body').loadingModal();
                    if (listing_event =='loadMore'){
                        $element.find('#pagination-tours-ajax').hide();
                    }
                },
                success: function(res){
                    let data= JSON.parse(res);
                    if (listing_event !='tab'){
                        $element.find('#pagination-tours-ajax').show();
                        if( data.data.template1 || data.data.template2) {
                            if (listing_event !='loadMore'){
                                $element.find('.wrapper-tour-list').empty(data.data.template2);
                                $element.find('.wrapper-tour-grid').empty(data.data.template1);
                            }
    
                            $element.find('.wrapper-tour-list').append(data.data.template2);
                            $element.find('.wrapper-tour-grid').append(data.data.template1);
                        }
                        if( data.data.total) {
                            $element.find('.block-top-result .result-title h3').text(data.data.total + " Tours found");
                        }else{
                            $element.find('.block-top-result .result-title h3').text("0 Tours found");
                        }
                        if (data.data.total_show >= data.data.total) {
                            $element.find('#pagination-tours-ajax').hide();
                        }else {
                            $element.find('#pagination-tours-ajax').show();
                        }
                        plugin.sortBy();
                    }else {
                        if(data.data.tab) {
                            $element.find('.nav-tabs li').each(function(index, el) {
                                $(el).removeClass('active');
                                if($(el).attr('data-layout') == data.data.tab) {
                                    $(el).addClass('active');
                                }
                            });
                            $element.find('.tab-contents > div').each(function(index, el) {
                                $(el).removeClass('in active');
                                if($(el).attr('data-layout') == data.data.tab) {
                                    $(el).addClass('in active');
                                }

                            });
                        }
                    }
                },
                error: function(){

                },
                complete: function(){
                    $('body').loadingModal('destroy');
                    if (history.pushState) {
                        var $params = "";
                        $.each(dataObj, function(index, val) {
                            if (index == 'start' || index == 'limit' || index == 'total_show' || index == 'page' || index == 'curent_user_id'){
                                delete dataObj[index];
                            }else{
                                if( index == "destination" ) {
                                    $params += "?"+index+"="+val;
                                }else{
                                    $params += "&"+index+"="+val;
                                }
                            }
                        });
                        var newurl = window.location.protocol + "//" + window.location.host + window.location.pathname + $params;
                        window.history.pushState({path:newurl},'',newurl);
                    }
                    window.scrollTo(0,$y);
                }
                
            })
        };
        plugin.convert_data_form = function() {
            var dataArray = $element.find('.form-search-tour').serializeArray();
            var output = [];
            dataArray.forEach(function(item) {
                var existing = output.filter(function(v, i) {
                    return v.name == item.name;
                });
                if (existing.length) {
                    var existingIndex = output.indexOf(existing[0]);
                    output[existingIndex].value = output[existingIndex].value.concat(item.value);
                } else {
                    if (typeof item.value == 'string')
                        item.value = [item.value];
                    output.push(item);
                }
            });
            return output;
        };

        // STICKY SIDEBAR

        plugin.sticky_sidebar=function(){
            var $sticky = $element.find('.wrapper-search-tour');
            if ($sticky.length > 0) {
                $($sticky).stick_in_parent()
                    .on('sticky_kit:bottom', function(e) {
                        $($sticky).removeClass('custom-sticky');
                        
                    })
                    .on('sticky_kit:unbottom', function(e) {
                        $($sticky).addClass('custom-sticky');
                    });

                $(window).on('resize', function () {
                    $($sticky).trigger('sticky_kit:detach');
                });
            }
        }

        // WISHLIST
        
        $('body').on('click','.view-list-tours .category-name-heart .heart',function(e){
            let $tour_item = $(this).closest('.wishlist-hover');
            let tour_id = $tour_item.data('tour_id');
            let user_id = $tour_item.data('user_id');
            let $wishlist_icon = $(this);
            if(user_id=="" && user_id==0){
                if ( $('.alert-warning').length == 0){
                    $("body").append('<div class="alert alert-warning" role="alert" style="display: inline-block;position: fixed;right: 60px;top: 30px;z-index:999;" >Please login to use the feature!<button type="button" class="close" data-dismiss="alert" aria-label="Close" style="margin-left: 30px"><span aria-hidden="true">&times;</span></button></div>');
                    setTimeout(function(){
                        $('.alert-warning').remove();
                    },1500)
                }
                return;
            }
            let data = {
                task: "wishlist.change_wishlist",
                state: 1,
                tour_id: tour_id,
                user_id: user_id,
            };
            $.ajax({
                type: "POST",
                dataType: "json",
                url:wpbookingpro_root_url + wpbookingpro_api_task,
                data: data,
                beforeSend: function () {
                    if($wishlist_icon.hasClass('active')){
                        $wishlist_icon.toggleClass("active");
                    }
                    else{
                        $wishlist_icon.addClass('icon-loading animate-spin');
                        $wishlist_icon.find('span').hide();

                    }
                },
                error: function (xhr) {
                    
                },
                complete: function () {
                    if($wishlist_icon.hasClass('icon-loading animate-spin')){
                        $wishlist_icon.removeClass('icon-loading animate-spin');
                        $wishlist_icon.find('span').show();
                        $wishlist_icon.toggleClass("active");
                    }
                },
                success: function (response) {
                    response = JSON.parse(response);
                }
            });
        });
        

        plugin.filterSystem = function (minPrice, maxPrice) {
            $("#computers div.system").hide().filter(function () {
                var price = parseInt($(this).data("price"), 10);
                return price >= minPrice && price <= maxPrice;
            }).show();
        };
        plugin.debounce = function(func, wait) {
            var timeout;

            return function() {
                var context = this,
                    args = arguments;

                var executeFunction = function() {
                    func.apply(context, args);
                };

                clearTimeout(timeout);
                timeout = setTimeout(executeFunction, wait);
            };
        };
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_list_tours = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_list_tours')) {
                let plugin = new $.view_list_tours(this, options);
                $(this).data('view_list_tours', plugin);
            }
        });
    }
})(jQuery);
