var gulp = require('gulp');
var sass = require('gulp-sass');
var autoprefixer = require('gulp-autoprefixer');
var plumber = require('gulp-plumber');
var gcmq = require('gulp-group-css-media-queries');
var concat = require('gulp-concat');
var del = require('del');

var onError = function (err) {
    console.log('An error occurred:',err.message);
    this.emit('end');
};

gulp.task('elementscss',function(){
    return gulp.src('./src/sass/frontend/**/*.scss')
        .pipe(plumber({ errorHandler: onError }))
        .pipe(sass())
        .pipe(concat('main.css'))
        .pipe(autoprefixer())
        .pipe(gcmq())
        .pipe(gulp.dest('./css'))

});

gulp.task('elementsjs',function(){
    return gulp.src('./src/js/frontend/**/*.js')
        .pipe(plumber({ errorHandler: onError }))
        .pipe(concat('main.js'))
        .pipe(gulp.dest('./js'))

});

gulp.task('elementsadminjs',function(){
    return gulp.src('./src/js/admin/**/*.js')
        .pipe(plumber({ errorHandler: onError }))
        .pipe(gulp.dest('./js/admin'))

});

gulp.task('watch', function() {
    gulp.watch('./src/sass/**/*.scss',gulp.parallel('elementscss'));
    gulp.watch('./src/js/frontend/**/*.js',gulp.parallel('elementsjs'));
    gulp.watch('./src/js/admin/**/*.js',gulp.parallel('elementsadminjs'));
});

gulp.task('cleanAssets', function() {
    return del([
        './css/**/*',
        './js/**/*'
    ]);
});

gulp.task('compileAssets', gulp.parallel('elementscss', 'elementsjs', 'elementsadminjs'));

gulp.task('build', gulp.series('cleanAssets', 'compileAssets'));
