---
layout: default
title: "Hybridauth Installation"
description: "System requirements, installation process and namespace auto-loading."
---

System requirements
===================

* PHP 5.4 or above,
* PHP session,
* Curl extension (However it can be substituted with other non Curl clients such as [Guzzle](http://docs.guzzlephp.org/en/latest/index.html))

Installation
============

To install Hybridauth, we recommend [Composer](https://getcomposer.org/) — the now defacto dependency manager for PHP. Otherwise you may always use the latest release available at [Github](https://github.com/hybridauth/hybridauth/releases) and install it manually.

#### Using Composer

If Composer is not installed on your system yet, you may go ahead and install it using this command line:

<pre>
$ curl -sS https://getcomposer.org/installer | php
</pre>

Next, add the following require entry to the `composer.json` file in the root of your project.

<pre>
{
    "require" : {
        "hybridauth/hybridauth" : "~3.0"
    }
}
</pre>

Finally, instruct Composer to install Hybridauth and its dependencies:

<pre>
$ php composer.phar install
</pre>

Composer will then download the latest version of Hybridauth Library and place it inside the `/vendor/` directory.

#### Manual Installation

In case you can't/don't want to use Composer, or if you never heard of it, you can still include Hybridauth in you application 
the traditional way by downloading the library archive and unzipping it into your project's folder.

The required steps are typically the following:

1. Download the latest available release at [https://github.com/hybridauth/hybridauth/releases](https://github.com/hybridauth/hybridauth/releases)
2. Next, simply unzip the archive file to your project's directory.

Autoloading
===========

Hybridauth 3 is coded in compliance with [PSR-4](http://www.php-fig.org/psr/psr-4/) which means it relies heavily on namespaces so that
class files can be loaded automatically. 

#### Using Composer

In case you're using Composer, include its autoloader `vendor/autoload.php` at the top of your script. That autoloader script is generated by Composer for your project and it should be able to locate Hybridauth source code and auto-load all the required classes.

<pre>
//Include Composer's autoloader
include 'vendor/autoload.php';

//Import Hybridauth's namespace
use Hybridauth\Hybridauth; 

//Now we may proceed and instantiate Hybridauth's classes
$instance = new Hybridauth([ /* ... */ ]); 
</pre>

#### Manual Installation

Alternatively, and in case you opted to install Hybridauth manually, the library comes bundled with a basic autoloader which can be found inside its source folder `src/autoload.php` and it should function in a similar way to Composer's.

<pre>
//Include Hybridauth's basic autoloader
include 'hybridauth/src/autoload.php';

//Import Hybridauth's namespace
use Hybridauth\Hybridauth; 

//And so on
</pre>
