---
layout: default
title: "Hybridauth Documentation"
---

Hybridauth Documentation
========================

Welcome to Hybridauth documentation. We recommend to start by reading [Installation](install.html) then [Introduction](introduction.html) and then you may move to Developer References for advanced usage. To make sure you can sign in your users with a certain social network or identity provider, refer to [Supported Providers](providers.html). 

### Getting started

. | .
------------------------------------- | -----------------------------------------------------------------------------------
[Installation](install.html)          | System requirements, installation process and namespace auto-loading.
[Introduction](introduction.html)     | Contains introductory examples of how to use Hybridauth to sign in users with social networks.
[Supported Providers](providers.html) | Listing of supported social networks and identity providers and their enabled features.

### Developer References

. | .
--------------------------------------------------------------- | ---------------------------------------------------------
[User Authentication](developer-ref-user-authentication.html)   | Examples of how to authenticate users with a given providers and how to make use of access tokens.
[User Profile](developer-ref-user-profile.html)                 | Describes how to retrieve users profiles in standardized structure across all the social networks.
[User Contacts list](developer-ref-user-contacts.html)          | Describes how to retrieve users contacts lists.
[User Activity Stream](developer-ref-user-activity.html)        | Describes how to retrieve users activity stream such as tweets and Facebook's wall.
[User Status](developer-ref-user-status.html)                   | Outlines how to update user's status.
[Providers APIs](developer-ref-providers-apis.html)             | Outlines how to access social networks APIs in behalf of connected users.
[Exceptions](developer-ref-exceptions.html)                     | Errors and exceptions handling.
[Extending Hybridauth](developer-ref-extend-hybridauth.html)    | Describes how to add new providers adapters to Hybridauth, and how to port them from 2.x.

### Migration

. | .
--------------------------------------------------------------- | ---------------------------------------------------------
[Migrating from 2.x](developer-ref-migrating.html)              | (not done yet)

<style>
    thead { display:none !important; }
    h1, h2, h3{ border: 0 none !important; }
</style>
