<?php
function Netbase_Load_Social_Links_Widget()
{
    register_widget( 'NB_Widgets_Social_Links');
}
add_action( 'widgets_init', 'Netbase_Load_Social_Links_Widget' );

class NB_Widgets_Social_Links extends WP_Widget {
	protected $default;
	protected $socials;

	function __construct() {
		$this->socials = array(
			'facebook'    => esc_html__( 'Facebook', 'teepro-elements' ),
			'twitter'     => esc_html__( 'Twitter', 'teepro-elements' ),
			'linkedin'    => esc_html__( 'Linkedin', 'teepro-elements' ),
			'google-plus' => esc_html__( 'Google Plus', 'teepro-elements' ),
			'pinterest'   => esc_html__( 'Pinterest', 'teepro-elements' ),
			'tumblr'      => esc_html__( 'Tumblr', 'teepro-elements' ),
			'flickr'      => esc_html__( 'Flickr', 'teepro-elements' ),
			'instagram'   => esc_html__( 'Instagram', 'teepro-elements' ),
			'bitbucket'   => esc_html__( 'Bitbucket', 'teepro-elements' ),
			'youtube'     => esc_html__( 'Youtube', 'teepro-elements' ),
			'github'      => esc_html__( 'Github', 'teepro-elements' ),
			'dribbble'    => esc_html__( 'Dribbble', 'teepro-elements' ),
			'rss'         => esc_html__( 'RSS', 'teepro-elements' ),
			'android'     => esc_html__( 'Android ', 'teepro-elements' ),
			'apple'       => esc_html__( 'Apple', 'teepro-elements' ),
			'windows'     => esc_html__( 'Windows', 'teepro-elements' ),
		);
		$this->default = array(
			'title' => '',
		);
		foreach ( $this->socials as $k => $v ) {
			$this->default["{$k}_title"] = '';
			$this->default["{$k}_url"]   = '';
		}

		parent::__construct(
			'nbelement-social-links-widget',
			esc_html__( 'NB - Social Links', 'teepro-elements' ),
			array(
				'classname'   => 'nbfw-social-links widget__social-link',
				'description' => esc_html__( 'Display links to social media networks.', 'teepro-elements' ),
			),
			array( 'width' => 600, 'height' => 350 )
		);
	}

	/**
	 * Outputs the HTML for this widget.
	 *
	 * @param array $args An array of standard parameters for widgets in this theme
	 * @param array $instance An array of settings for this widget instance
	 *
	 * @return void Echoes it's output
	 */
	function widget( $args, $instance ) {
		$instance = wp_parse_args( $instance, $this->default );

		extract( $args );
		
		echo wp_kses_post( $before_widget );

		if ( $title = apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base ) ) {
			echo wp_kses_post( $before_title . $title . $after_title );
		}
		$style 	= $instance['style'];
		$size 	= $instance['size'];
		$align 	= 'align-' . $instance['align'];

		echo '<ul class="nbfw-social-link-widget ' . $style . ' ' . $size. ' ' . $align . '">';
		foreach ( $this->socials as $social => $label ) {
			if ( ! empty( $instance[ $social . '_title' ] ) || ! empty( $instance[ $social . '_url' ] ) ) {
				printf( '<li><a href="%s" rel="nofollow" title="%s"><i class="fa fa-%s"></i></a></li>',
					$instance[ $social . '_url' ],
					$instance[ $social . '_title' ],
					$social
				);
			}
		}
		echo '</ul>';

		echo wp_kses_post( $after_widget);
	}


	/**
	 * Deals with the settings when they are saved by the admin.
	 *
	 * @param array $new_instance
	 * @param array $old_instance
	 *
	 * @return array
	 */
	function update( $new_instance, $old_instance ) {
		return $new_instance;
	}

	/**
	 * Displays the form for this widget on the Widgets page of the WP Admin area.
	 *
	 * @param array $instance
	 *
	 * @return array
	 */
	function form( $instance ) {
		$instance = wp_parse_args( $instance, $this->default );

		$style					= esc_attr( $instance[ 'style' ] );
		$size					= esc_attr( $instance[ 'size' ] );
		$align					= esc_attr( $instance[ 'align' ] );
		?>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'teepro-elements' ); ?></label>
			<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $instance['title'] ); ?>"/>
		</p>

		<?php

		$html = '';
		// Style
		$black_style 					= $style == 'black-icon' ? 'selected="selected"' : '';
		$gray_style 					= $style == 'gray-icon' ? 'selected="selected"' : '';
		$white_style 					= $style == 'white-icon' ? 'selected="selected"' : '';

		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Style', 'teepro-elements' ) . ': </label>';
		$html  .= '<select class="widefat" name="' . $this->get_field_name( 'style' ) . '">
						<option value="black-icon"' . $black_style . '>' . esc_html__( 'Black Icon', 'teepro-elements' ) . '</option>
						<option value="gray-icon"' . $gray_style . '>' . esc_html__( 'Gray Icon', 'teepro-elements' ) . '</option>
						<option value="white-icon"' . $white_style . '>' . esc_html__( 'White Icon', 'teepro-elements' ) . '</option>
				   </select>
					';
		$html  .= '</p>';

		// Size
		$small_size 					= $size == 'small-size' ? 'selected="selected"' : '';
		$big_size 						= $size == 'big-size' ? 'selected="selected"' : '';

		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Size', 'teepro-elements' ) . ': </label>';
		$html  .= '<select class="widefat" name="' . $this->get_field_name( 'size' ) . '">
						<option value="small-size"' . $small_size . '>' . esc_html__( 'Small', 'teepro-elements' ) . '</option>
						<option value="big-size"' . $big_size . '>' . esc_html__( 'Big', 'teepro-elements' ) . '</option>
				   </select>
					';
		$html  .= '</p>';

		// Size
		$align_left 					= $align == 'left' ? 'selected="selected"' : '';
		$align_center 					= $align == 'center' ? 'selected="selected"' : '';
		$align_right 					= $align == 'right' ? 'selected="selected"' : '';

		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Align', 'teepro-elements' ) . ': </label>';
		$html  .= '<select class="widefat" name="' . $this->get_field_name( 'align' ) . '">
						<option value="left"' . $align_left . '>' . esc_html__( 'Left', 'teepro-elements' ) . '</option>
						<option value="center"' . $align_center . '>' . esc_html__( 'Center', 'teepro-elements' ) . '</option>
						<option value="right"' . $align_right . '>' . esc_html__( 'Right', 'teepro-elements' ) . '</option>
				   </select>
					';
		$html  .= '</p>';

		echo $html;
		?>

		
		<?php
		foreach ( $this->socials as $social => $label ) {
			printf(
				'<div style="width: 280px; float: left; margin-right: 10px;">
					<label>%s</label>
					<p><input type="text" class="widefat" name="%s" placeholder="%s" value="%s"></p>
					<p><input type="text" class="widefat" name="%s" placeholder="%s" value="%s"></p>
				</div>',
				$label,
				esc_attr( $this->get_field_name( $social . '_title' ) ),
				esc_html__( 'Title', 'teepro-elements' ),
				esc_attr( $instance[ $social . '_title' ] ),
				esc_attr( $this->get_field_name( $social . '_url' ) ),
				esc_html__( 'URL', 'teepro-elements' ),
				esc_url( $instance[ $social . '_url' ] )
			);
		}
	}
}
