<?php
// Register and load the widget
function NB_recentposts_widget() {
    register_widget( 'NB_recent_posts_widget' );
}
add_action( 'widgets_init', 'NB_recentposts_widget' );
 
// Creating the widget 
class NB_recent_posts_widget extends WP_Widget {
 
	function __construct() {
		parent::__construct(
		 
			// Base ID of your widget
			'NB_recent_posts_widget', 
			 
			// Widget name will appear in UI
			__('NB - Recent Posts Widget', 'teepro-elements'), 
			 
			// Widget description
			array( 'description' => __( 'Sample widget based on WPBeginner Tutorial', 'teepro-elements' ), ) 
		);
	}
 
	// Creating widget front-end
	public function widget( $args, $instance ) {
		global $post;
		$title = apply_filters( 'widget_title', $instance['title'] );
        $limit = (int) $instance['limit'];
		// before and after widget arguments are defined by themes
        echo $args['before_widget'];
        
		if ( ! empty( $title ) ){
			if($title){
				echo $args['before_title'] . $title . $args['after_title'];
			}
        }
        
	    $arg = array(
	      'posts_per_page'    => $limit,
	      'post_type' => 'post',
	    );
        
	    // The Query
	    $the_query = new WP_Query( $arg );
        
	    if ( $the_query->have_posts() ) {?>
	    <ul class="widget-post-lists">
	    	<?php while ( $the_query->have_posts() ) {
            $the_query->the_post();
            $thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id(), 'thumbnail');?>
	    	<li>
	    		<a href="<?php echo esc_url( get_permalink( $post->ID ) );?>"><img src="<?php echo esc_url( $thumbnail[0] );?>"></a>
	    		<div class="wpl-info">
					<h6><a href="<?php echo esc_url( get_permalink( $post->ID ) );?>"><?php echo esc_attr( $post->post_title );?></a></h6>
					<p><?php echo wp_trim_words( $post->post_content , 10 ,'...');?></p>
                    <a href="<?php echo esc_url( get_permalink( $post->ID ) );?>"><?php _e( 'read more' ) ?></a>
	    		</div>
	    	</li>
	    	<?php }?>
	    </ul>

		<?php
		}
		wp_reset_postdata();
		echo $args['after_widget'];
	}
         
	// Widget Backend 
	public function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) ) {
			$title = $instance[ 'title' ];
		}
		else {
			$title = __( 'New title', 'teepro-elements' );
        }
        $limit = isset( $instance['limit'] ) ? absint($instance['limit']) : 4;
		// Widget admin form
		?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
        <p>
		<label for="<?php echo $this->get_field_id( 'limit' ); ?>"><?php _e( 'Limit:' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'limit' ); ?>" name="<?php echo $this->get_field_name( 'limit' ); ?>" type="text" value="<?php echo esc_attr( $limit ); ?>" />
		</p>
		<?php 
	}
     
	// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['limit'] = (!empty($new_instance['limit']) ) ? (int) $new_instance['limit'] : '4';
		return $instance;
	}
} // Class wpb_widget ends here