<?php
if ( ! class_exists( 'Netbase_Element_Widgets_Contact_Info' ) ):

    add_action( 'widgets_init', 'NB_Load_Contact_Info_Widget' );

    function NB_Load_Contact_Info_Widget() {
        register_widget( 'Netbase_Element_Widgets_Contact_Info' );
    }
class Netbase_Element_Widgets_Contact_Info extends WP_Widget {

	function __construct() {
        $widget_ops  = array(
            'description' => __( 'Displays the Infomation Contact', 'teepro-elements' )
        );

        $control_ops = array(
            'width'  => 'auto',
            'height' => 'auto'
        );

        parent::__construct( 'nbelement_contact_info', __( 'NB - Contact Info', 'teepro-elements' ), $widget_ops, $control_ops );
    }
    /**
     * How to display the widget on the screen.
     */
    function widget($args, $instance) {
        extract($args);       

        $title     = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );      
        $showsocial      = $instance['showsocial'] ? '1' : '0';
        $street1 = $instance['street1'];
        $phone = $instance['phone'];
        $email = $instance['email'];
        $infodes = $instance['infodes'];
        $website = $instance['website'];


        echo wp_kses_post( $before_widget );

        if ( ! empty( $title ) ) {
            echo wp_kses_post( $before_title . $title . $after_title );
        }       

         if ( ! empty( $infodes ) ) {
            echo '<p>'.$infodes.'</p>';
         }
    
        echo '<ul class="nbelement-info">';
			
			if (!empty($street1)){
                echo '<li class="info-address">';                
                echo '<i class="fa fa-home"></i>';
                echo '<span class="street1">'. esc_html( $street1 ).'</span>';
                echo '</li>';
            }	        
            
            if (!empty($phone)){
                echo '<li><i class="fa fa-phone"></i>';
                echo '<span class="phone">'. esc_html($phone ).'</span>';
                echo '</li>';
            }            
             
			if (!empty($email)){
                echo '<li><i class="fa fa-envelope"></i>';           
                echo '<span class="email"><a href="mailto:'. esc_html($email).'" title="send mail">'. esc_html($email ).'</a></span>';
                echo '</li>';
             }	

            if (!empty($website)){
                echo '<li><i class="fa fa-globe"></i>';           
                echo '<span class="website"><a href="'. esc_url($website).'" title="website">'. esc_url($website ).'</a></span>';
                echo '</li>';
             }  						
			
		echo '</ul>'; 
        
        /*if ( $showsocial == true ) : 
            $show_contact_social = get_theme_mod( 'edusite_social_on', array( 'facebook', 'twitter', 'google' ) );

                        if ( ! empty( $show_contact_social ) && is_array( $show_contact_social ) ) {
                            echo '<div class="social-link-footer">';
                            foreach ( $show_contact_social as $part ) { ?>
                                <?php if(get_theme_mod('edusite_acc_'.$part)!=''): ?>

                                <a href="<?php echo esc_attr( get_theme_mod('edusite_acc_'.$part) ); ?>">
                                    <i class="fa fa-<?php echo esc_html( $part );  ?>"></i>      
                                </a>            
                                <?php
                                endif;
                            }
                            echo '</div>';
                        }
                        
                        
        endif;*/
        
        echo wp_kses_post( $after_widget );
    }

    /**
     * Update the widget settings.
     */
    function update($new_instance, $old_instance) {
        $instance = $old_instance;

        /* Strip tags to remove HTML (important for text inputs). */
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['infodes'] = strip_tags($new_instance['infodes']);
        

        $instance['street1'] = strip_tags($new_instance['street1']);
        
        $instance['phone'] = strip_tags($new_instance['phone']);
        $instance['email'] = strip_tags($new_instance['email']);
        $instance['website'] = strip_tags($new_instance['website']);
        $instance['showsocial']  = ! empty( $new_instance['showsocial'] ) ? 1 : 0;

        return $instance;
    }

    /**
     * Displays the widget settings controls on the widget panel.
     * Make use of the get_field_id() and get_field_name() function
     * when creating your form elements. This handles the confusing stuff.
     */
    function form($instance) {

        /* Set up some default widget settings. */
        $showsocial     = isset( $instance['showsocial'] ) ? ( bool ) $instance['showsocial'] : true;
        $defaults = array(
            'title' => '', 
            'street1' => '', 
            'phone' => '', 'email' => '', 'website' => '');
        $instance = wp_parse_args((array)$instance, $defaults); ?>

        <!-- Widget Title: Text Input -->
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'teepro-elements'); ?></label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
                   name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo $instance['title']; ?>"/>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('infodes'); ?>"><?php _e('Description:', 'teepro-elements'); ?></label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id('infodes'); ?>"
                   name="<?php echo $this->get_field_name('infodes'); ?>" value="<?php echo $instance['infodes']; ?>"/>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('street1'); ?>"><?php _e('Address:', 'teepro-elements'); ?></label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id('street1'); ?>"
                   name="<?php echo $this->get_field_name('street1'); ?>" value="<?php echo $instance['street1']; ?>"/>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('phone'); ?>"><?php _e('Phone:', 'teepro-elements'); ?></label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id('phone'); ?>"
                   name="<?php echo $this->get_field_name('phone'); ?>" value="<?php echo $instance['phone']; ?>"/>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('email'); ?>"><?php _e('Email:', 'teepro-elements'); ?></label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id('email'); ?>"
                   name="<?php echo $this->get_field_name('email'); ?>" value="<?php echo $instance['email']; ?>"/>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('website'); ?>"><?php _e('Website:', 'teepro-elements'); ?></label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id('website'); ?>"
                   name="<?php echo $this->get_field_name('website'); ?>" value="<?php echo $instance['website']; ?>"/>
        </p>
        <p>
            <input class="checkbox" type="checkbox" id="<?php echo esc_attr( $this->get_field_id( 'showsocial' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'showsocial' ) ); ?>"<?php checked( $showsocial ); ?> />
            <label for="<?php echo esc_attr( $this->get_field_id( 'showsocial' ) ); ?>"><?php esc_html_e( 'Show Social', 'teepro-elements' ); ?></label>
        </p>
    <?php
    }
}
endif;
?>