<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/**
 * Define core class.
 */
if (class_exists("WPBakeryShortCode")) {
class NB_Element_Vc_Step extends WPBakeryShortCode {
    /**
     * Initialize.
     *
     * @return  void
     */
    
    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'map' ), 12 );
        add_shortcode( 'netbase_vc_step', array( $this, 'shortcode_vc_step' ) );
        
    }

    
    /**
     * Map new parameters and elements.
     *
     * @since  1.0
     * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
     */
    public function map()
    {
       
        vc_map(array(
            'name' => esc_html__('Steps', "teepro-elements"),
            'base' => 'netbase_vc_step',
            'category' => esc_html__('Teepro', "teepro-elements"),
            'description' => esc_html__('Display Step.', "teepro-elements"),
            'icon' => 'icon-wpb-wp',
            'params' => array(
                array(
                    'heading'    => esc_html__( 'Step Number', "teepro-elements" ),
                    'type'       => 'textfield',
                    'param_name' => 'step_number',
                ),
                array(
                    'param_name' => 'font_size_step_number',
                    'heading'    => esc_html__( 'Size Step Number', "teepro-elements" ),
                    'type'       => 'textfield',
                    'description'=>'Enter step number size ((Example:16)',
                    'value'      => ''
                ),
                array(
                    'param_name' => 'font_weight_step_number',
                    'heading'    => esc_html__( 'Font Weight Step Number', "teepro-elements" ),
                    'type'       => 'dropdown',
                    'description'=>'Choose font weight step number',
                    'value'      => array(
                        __( 'Bold', "teepro-elements" ) => 'number_bold',
                        __( 'Nomal', "teepro-elements" )=> 'number_nomal',
                    ),
                    'edit_field_class' => 'vc_col-xs-12 vc_column mgt10',
                ),
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__('Image Step', "teepro-elements"),
                    'param_name' => 'image_step',
                    'value' => '',
                ),

                array(
                    'param_name' => 'title_text',
                    'heading'    => esc_html__( 'Title Text', "teepro-elements" ),
                    'type'       => 'textfield',

                ),
                array(
                    'param_name' => 'title_tag',
                    'heading'    => esc_html__( 'Title Tag', "teepro-elements" ),
                    'type'       => 'dropdown',
                    'value'      => array(
                        __( 'H1', 'teepro-elements' )      => 'h1',
                        __( 'H2', 'teepro-elements' )      => 'h2',
                        __( 'H3', 'teepro-elements' )      => 'h3',
                        __( 'H4', 'teepro-elements' )     => 'h4',
                        __( 'H5', 'teepro-elements' )     => 'h5',
                        __( 'div', 'teepro-elements' )     => 'div',

                    ),

                 ),
                array(
                    'param_name' => 'content_text',
                    'heading'    => esc_html__( 'Content', "teepro-elements" ),
                    'type'       => 'textarea',

                ),
                array(
                        'param_name' => 'style_layer',

                        'heading'    => esc_html__( 'Image Shape', "teepro-elements" ),
                        'type'       => 'dropdown',
                        'value'      => array(
                            __( 'Image Square', "teepro-elements" ) => 'style_1',
                            __( 'Image Round', "teepro-elements" ) => 'style_2',
                        ),
                        'edit_field_class' => 'vc_col-sm-6 vc_column mgt10',
                    ),
                array(
                        'param_name' => 'position_content',
                        'heading'    => esc_html__( 'Position Content', "teepro-elements" ),
                        'type'       => 'dropdown',
                        'value'      => array(
                            __( 'Content Left', "teepro-elements" ) => 'content_left',
                            __( 'Content Right', "teepro-elements" ) => 'content_right',
                            __( 'Content Top', "teepro-elements" ) => 'content_top',
                            __( 'Content Bottom', "teepro-elements" ) => 'content_bottom',
                        ),
                        'edit_field_class' => 'vc_col-sm-6 mgt15',
                ),
                array(
                    'heading'    => __( 'Extra class name', "teepro-elements" ),
                    'param_name' => 'extra_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Custom id name', "teepro-elements" ),
                    'param_name' => 'custom_id',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', "teepro-elements" ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', "teepro-elements" ),
                )
            )
        ));
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    
   

    public function shortcode_vc_step($atts, $content = null)
    {
        $html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'step_number' => '',
                    'image_step' => '',
                    'height_image'=>'',
                    'width_image'=>'',
                    'font_size_step_number'=>'',
                    'font_weight_step_number'=>'bold',
                    'title_text' => '',
                    'title_tag'=>'h1',
                    'content_text'=>'',
                    'style_layer' => 'style_1',
                    'position_content'=> 'content_left',
                    'extra_class' =>'',
                    'custom_id' => '',
                    'css'  => '',
                    'content' => '',
                   // 'font_family'=>'default'
                ),
                $atts
            )
        );
       
        $html .= '<div class="nb-fw vc_step '.($style_layer ? $style_layer:'').' '.($position_content?$position_content:'').'" >';

            if ( ! empty( $image_step ) ) {
                $img_id       = preg_replace( '/[^\d]/', '', $image_step);
                $image        = wpb_getImageBySize( array( 'attach_id' => $img_id ) );
                $image_link   = $image[ 'p_img_large' ][ 0 ];
            }

        if($style_layer=='style_2'){

            $html .= '<div class="vc-step-items step_details">';
            if ( ! empty( $image_step )  ) {
                $html .= '<div class="step_image">';

                $html .= '<img src="' . esc_url( $image_link ) . '" alt="' .  ( ( ! empty( $image_link ) ) ?  esc_attr( $image_link ) : esc_attr__( 'Avatar', "teepro-elements" ) ) . '" ' . ( ( 'style_2' == $style_layer ) ? 'class="br-50"' : '' ) . '  />';

                $html .= '</div>';
            }
            $html .= '<div class="step_box" data-vc-step-content="normal">';
            if ( ! empty( $step_number ) ){
                $html .= '<div class="step_number">';

                $html .= '<span class="number '.($font_weight_step_number ? $font_weight_step_number:'').'" '.($font_size_step_number?('style="font-size:'.$font_size_step_number.'px"'):'').'>'.$step_number.'</span>';
                if ( ! empty( $title_text ) ) {

                    $html .= '<'.($title_tag ? $title_tag : 'div').' class="step_title" >' . esc_html( $title_text ) . '</'.($title_tag ? $title_tag : 'div').'>';
                }
                $html .= '</div>';
            }
            $html .= '<div class="step_title_content">';

            if ( ! empty( $content_text ) ) {
                $html .= '<div class="step_content">';

                $html .= '<p class="content_step">' . esc_html( $content_text ) . '</p>';
                $html .= '</div>';
            }

            $html .= '</div></div>';
        }
        else{

            $html .= '<div class="vc-step-items step_details">';

            if ( ! empty( $image_step )  ) {
                $html .= '<div class="step_image">';

                $html .= '<img src="' . esc_url( $image_link ) . '" alt="' .  ( ( ! empty( $image_link ) ) ?  esc_attr( $image_link ) : esc_attr__( 'Avatar', "teepro-elements" ) ) . '" ' . ( ( 'style_2' == $style_layer ) ? 'class="br-50"' : '' ) . '  />';

                $html .= '</div>';
            }
            $html .= '<div class="step_box" data-vc-step-content="normal">';
            if ( ! empty( $step_number ) ){
                $html .= '<div class="step_number">';

                $html .= '<span class="number '.($font_weight_step_number ? $font_weight_step_number:'').'" '.($font_size_step_number?('style="font-size:'.$font_size_step_number.'px"'):'').'>'.$step_number.'</span>';

                $html .= '</div>';
            }
            $html .= '<div class="step_title_content">';
            if ( ! empty( $title_text ) ) {

                $html .= '<'.($title_tag ? $title_tag : 'div').' class="step_title">' . esc_html( $title_text ) . '</'.($title_tag ? $title_tag : 'div').'>';
            }
            if ( ! empty( $content_text ) ) {
                $html .= '<div class="step_content">';

                $html .= '<p class="content_step">' . esc_html( $content_text ) . '</p>';
                $html .= '</div>';
            }

            $html .= '</div></div>';
        }


        $html .= '</div>';

        wp_reset_postdata();

        return apply_filters('netbase_shortcode_vc_step', force_balance_tags($html));
    }

    


}
new NB_Element_Vc_Step(); 
}