<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/*
Element Description: VC Testimonials
*/
if (class_exists("WPBakeryShortCode")) {
// Element Class 
    class NB_Element_Testimonial extends WPBakeryShortCode
    {

        // Element Init
        function __construct()
        {
            add_action('init', array($this, 'vc_mapping'), 12);
            add_shortcode('teepro_testimonials', array($this, 'teepro_testimonials'));
        }

        // Element Mapping
        public function vc_mapping()
        {

            // Stop all if VC is not enabled
            if (!defined('WPB_VC_VERSION')) {
                return;
            }

            vc_map(array(
                "name"          => __("Testimonials", "teepro-elements"),
                "base"          => "teepro_testimonials",
                'icon'          => 'icon-wpb-wp',
                "class"         => "",
                "category"      => __("Teepro", "teepro-elements"),
                "params"        => array(

                    array(
                        "type" => "dropdown",
                        "heading" => __("Style", "teepro-elements"),
                        "param_name" => "testimonial_style",
                        'value' => array(
                           // __('Multi Thumbnail', "teepro-elements") => 'multi_thumb',
                            __('Sync Multi Thumbnai And Content', "teepro-elements") => 'multi_thumb_style_1',
                          //  __('Multi Thumbnai Style 2', "teepro-elements") => 'multi_thumb_style_2',
                            __('Single Thumbnai Top', "teepro-elements") => 'single_thumb',
                            __('Single Thumbnai Left', "teepro-elements") => 'single_thumb_style_1',
                            __('Single Square Thumbnai', "teepro-elements") => 'single_thumb_style_2',
                            __('Multi Thumbnail No Auto Play', "teepro-elements") => 'multi_thumb_no_auto_play',
                            __('Multi Thumbnail Zoom Image', "teepro-elements") => 'multi_thumb_zoom_image',
                        ),
                    ),
                    array(
                        "type" => "dropdown",
                        "heading" => __("Tag Title", "teepro-elements"),
                        "param_name" => "tag_title",
                        'value' => array(
                            __('H1', "teepro-elements") => 'h1',
                            __('H2', "teepro-elements") => 'h2',
                            __('H3', "teepro-elements") => 'h3',
                            __('H4', "teepro-elements") => 'h4',
                            __('H5', "teepro-elements") => 'h5',
                            __('div', "teepro-elements") => 'div',

                        ),
                    ),
                    array(
                        "type" => "textfield",
                        "heading" => __("Image size", "teepro-elements"),
                        "param_name" => "image_size",
                        'value' => '',
                        'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200).'
                    ),

                    array(
                        'type' => 'param_group',
                        'value' => '',
                        'heading' => __('Testimonials Content', "teepro-elements"),
                        'param_name' => 'add_vc_testimonials_lists',
                        // Note params is mapped inside param-group:
                        'params' => array(
                            array(
                                "type" => "textfield",
                                "heading" => __("Author name", "teepro-elements"),
                                "param_name" => "add_vc_our_testimonials_aname",
                                "value" => '',
                            ),
                            array(
                                "type" => "textfield",
                                "heading" => __("Author position", "teepro-elements"),
                                "param_name" => "add_vc_our_testimonials_aposition",
                                "value" => '',
                            ),
                            array(
                                'type' => 'attach_image',
                                'heading' => __('Avatar', "teepro-elements"),
                                'param_name' => 'add_vc_our_testimonials_avatar',
                                'value' => '',
                                'description' => __('Select image from media library.', "teepro-elements"),
                                'admin_label' => true,
                            ),
                            array(
                                "type" => "textfield",
                                "heading" => __("Title", "teepro-elements"),
                                "param_name" => "add_vc_our_testimonials_title",
                                "value" => '',
                            ),
                            array(
                                "type" => "textarea",
                                "heading" => __("Content", "teepro-elements"),
                                "param_name" => "add_vc_our_testimonials_content",
                                "value" => '',
                            ),
                            // array(
                            //     "type" => "textfield",
                            //     "heading" => __("Posted date", "teepro-elements"),
                            //     "param_name" => "add_vc_our_testimonials_posted_date",
                            //     'description' => __('mm/dd/YYYY', "teepro-elements"),
                            //     "value" => date('m/d/Y'),
                            // ),
                            array(
                                'type' => 'attach_image',
                                'heading' => __('Background Image', "teepro-elements"),
                                'param_name' => 'testimonial_bg',
                                'value' => '',
                                'description' => __('Select image from media library.', "teepro-elements"),
                                'admin_label' => true,
                            ),
                        )
                    ),

                    array(
                        'type' => 'checkbox',
                        'heading' => __('Show Navigation', "teepro-elements"),
                        'param_name' => 'show_navigation',
                    ),

                    array(
                        'type' => 'checkbox',
                        'heading' => __('Show Pagination', "teepro-elements"),
                        'param_name' => 'show_pagination',
                    ),
                )
            ));

        }

        // Element HTML
        public function teepro_testimonials($atts, $content = null)
        {
            extract(shortcode_atts(array(
                'testimonial_style' => 'multi_thumb_style_1',
                'tag_title' => '',
                'image_size' => '',
                'add_vc_testimonials_lists' => '',
                'show_navigation' => '',
                'show_pagination' => '',

            ), $atts));

            ob_start();
            $testimonials_lists = vc_param_group_parse_atts($atts['add_vc_testimonials_lists']);

            $testimonial_data[] = array();
            
            foreach ($testimonials_lists as $index => $item) {

                $avatar_img_id = isset($item['add_vc_our_testimonials_avatar']) ? $item['add_vc_our_testimonials_avatar'] : '';

                if (is_numeric($image_size)) {
                    $img_data = wp_get_attachment_image_src($avatar_img_id, array($image_size, $image_size));
                } else {
                    $img_data = wp_get_attachment_image_src($avatar_img_id, $image_size);
                }

                $testimonial_data[$index]['img_src'] = $img_data[0];

                $testimonial_data[$index]['title'] = isset($item['add_vc_our_testimonials_title']) ? $item['add_vc_our_testimonials_title'] : '';

                $testimonial_data[$index]['content'] = isset($item['add_vc_our_testimonials_content']) ? $item['add_vc_our_testimonials_content'] : '';

                $testimonial_data[$index]['name'] = isset($item['add_vc_our_testimonials_aname']) ? $item['add_vc_our_testimonials_aname'] : '';

                $testimonial_data[$index]['position'] = isset($item['add_vc_our_testimonials_aposition']) ? $item['add_vc_our_testimonials_aposition'] : '';

                $posted_date = isset($item['add_vc_our_testimonials_posted_date']) ? $item['add_vc_our_testimonials_posted_date'] : '';

               // $testimonial_data[$index]['posted_date'] = $posted_date != '' ? date('F Y', strtotime($posted_date)) : '';


                $background_img_id = isset($item['testimonial_bg']) ? $item['testimonial_bg'] : '';
                $background_img_data = wp_get_attachment_image_src($background_img_id, 'full');
                $testimonial_data[$index]['testimonial_bg_src'] = $background_img_data[0];

            }

            if (count($testimonial_data) > 0) {

                $style_class = 'testimonial_' . $testimonial_style


                ?>
                <div class="vc-teepro-testimonials">
                <div class="vc_testimonial_wrap <?php echo esc_attr($style_class); ?> "
                     data-style="<?php echo esc_attr($testimonial_style); ?>">

                <?php if ($testimonial_style == 'multi_thumb'): ?>

                    <div class="swiper-container vc-avatar-testimonial ">
                        <div class="swiper-wrapper">
                            <?php foreach ($testimonial_data as $testimonial): ?>
                                <div class="swiper-slide">
                                    <div class="vc-avatar-img">
                                        <img src="<?php echo esc_url($testimonial['img_src']); ?>" alt="testimonial-image"/>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>

                    <div class="swiper-container vc-content-testimonial">
                        <div class="swiper-wrapper">
                            <?php foreach ($testimonial_data as $testimonial) { ?>
                                <div class="swiper-slide">
                                    <div class="vc-testimonial-content">
                                        <p class="description"><?php echo esc_html($testimonial['content']); ?></p>

                                        <p class="client-name"><?php echo esc_html($testimonial['name']); ?></p>

                                        <p class="client-position"><?php echo esc_html($testimonial['position']); ?></p>
                                    </div>

                                </div>
                            <?php } ?>
                        </div>

                        <?php if ($show_pagination): ?>
                            <div class="testimonial-pagination"></div>
                        <?php endif; ?>

                        <?php if ($show_navigation): ?>
                            <div class="swiper-button-next swiper-button-next_multi_style_2"></div>
                            <div class="swiper-button-prev swiper-button-prev_multi_style_2"></div>
                        <?php endif; ?>
                    </div>

                <?php elseif ($testimonial_style == 'multi_thumb_zoom_image'): ?>
                    
                    
                    <div class="swiper-container vc-content-testimonial">
                        <div class="swiper-wrapper">
                            <?php foreach ($testimonial_data as $testimonial) { ?>
                                <div class="swiper-slide">
                                    <div class="vc-testimonial-img">
                                        <h2 class="vc-testimonial-title"><?php echo esc_html($testimonial['title']); ?></h2>
                                        <div class="img-full">
                                            <img src="<?php echo esc_url($testimonial['img_src']); ?>" alt="testimonial-image"/>
                                        </div>
                                        <?php if ($testimonial['content']): ?>
                                            <div class="vc-testimonial-content">
                                                <div class="vc-title">
                                                    <?php echo($tag_title ? ('<' . $tag_title . ' class="client-name">') : '<div class="client-name">'); ?> <?php echo esc_html($testimonial['name']); ?><?php echo($tag_title ? ('</' . $tag_title . '>') : '</div>'); ?>
                                                    <div class="client-position"><?php echo esc_html($testimonial['position']); ?></div>
                                                </div>
                                                <p class="description"><?php echo esc_html($testimonial['content']); ?></p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>

                    </div>


                    <div class="swiper-container vc-avatar-testimonial " >
                        <div class="swiper-wrapper">
                            <?php foreach ($testimonial_data as $testimonial): ?>
                                <div class="swiper-slide">
                                    <div class="vc-avatar-img">
                                        <img src="<?php echo esc_url($testimonial['img_src']); ?>" alt="testimonial-image"/>
                                    </div>
                                    
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <?php if ($show_pagination): ?>
                            <div class="testimonial-pagination"></div>
                        <?php endif; ?>

                        <?php if ($show_navigation): ?>
                            <div class="swiper-button-next swiper-button-next_zoom_image"></div>
                            <div class="swiper-button-prev swiper-button-prev_zoom_image"></div>
                        <?php endif; ?>
                    </div>


                    <?php elseif ($testimonial_style == 'multi_thumb_no_auto_play'): ?>
                    <div class="swiper-container vc-content-testimonial">
                        <div class="swiper-wrapper">
                            <?php foreach ($testimonial_data as $testimonial) : ?>
                                <div class="swiper-slide">
                                    <div class="vc-testimonial-item"
                                         style="background-image: url('<?php echo($testimonial['testimonial_bg_src']); ?>')">
                                        <div class="vc-testimonial-content">
                                            <p class="title"><?php echo $testimonial['title']; ?></p>

                                            <p class="description"><?php echo $testimonial['content']; ?></p>

                                        </div>

                                        <div class="vc-avatar-testimonial">

                                            <div class="vc-avatar-img">
                                                <?php if (is_numeric($image_size)): ?>
                                                    <div class="image-avatar"
                                                         style="background-image: url('<?php echo($testimonial['img_src']); ?>');height:<?php echo $image_size ?>px;width: <?php echo $image_size ?>px"></div>
                                                <?php endif; ?>
                                                <?php if (!is_numeric($image_size)): ?>
                                                    <img class="image-avatar"
                                                         src="<?php echo esc_url($testimonial['img_src']); ?>" alt="testimonial-image"/>
                                                <?php endif; ?>
                                            </div>
                                            <div class="name-position">
                                                <?php echo($tag_title ? ('<' . $tag_title . ' class="client-name">') : '<div class="client-name">'); ?> <?php echo esc_html($testimonial['name']); ?><?php echo($tag_title ? ('</' . $tag_title . '>') : '</div>'); ?>
                                                <p class="client-position"><?php echo esc_html($testimonial['position']); ?></p>
                                            </div>

                                        </div>
                                    </div>

                                </div>
                            <?php endforeach; ?>
                        </div>

                        <?php if ($show_pagination): ?>
                            <div class="testimonial-pagination"></div>
                        <?php endif; ?>

                        <?php if ($show_navigation): ?>
                            <div class="swiper-button-next swiper-button-next_no_auto_play"></div>
                            <div class="swiper-button-prev swiper-button-prev_no_auto_play"></div>
                        <?php endif; ?>
                    </div>
                
                <?php
                elseif ($testimonial_style == 'multi_thumb_style_1'): ?>

                    <div class="swiper-container vc-content-testimonial">
                        <div class="swiper-wrapper">
                            <?php foreach ($testimonial_data as $testimonial) { ?>
                                <div class="swiper-slide">

                                    <h2 class="vc-testimonial-title"><?php echo esc_html($testimonial['title']); ?></h2>
                                    <?php if ($testimonial['content']): ?>
                                        <div class="vc-testimonial-content">
                                            <p class="description"><?php echo esc_html($testimonial['content']); ?></p>
                                        </div>
                                    <?php endif; ?>

                                </div>
                            <?php } ?>
                        </div>

                    </div>
                    <div class="swiper-container vc-avatar-testimonial ">
                        <div class="swiper-wrapper">
                            <?php foreach ($testimonial_data as $testimonial): ?>
                                <div class="swiper-slide">
                                    <div class="vc-avatar-img">
                                        <img src="<?php echo esc_url($testimonial['img_src']); ?>" alt="testimonial-image"/>
                                    </div>
                                    <div class="vc-title">
                                        <?php echo($tag_title ? ('<' . $tag_title . ' class="client-name">') : '<div class="client-name">'); ?> <?php echo esc_html($testimonial['name']); ?><?php echo($tag_title ? ('</' . $tag_title . '>') : '</div>'); ?>
                                        <div
                                            class="client-position"><?php echo esc_html($testimonial['position']); ?></div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <?php if ($show_pagination): ?>
                            <div class="testimonial-pagination"></div>
                        <?php endif; ?>

                        <?php if ($show_navigation): ?>
                            <div class="swiper-button-next swiper-button-next_multi_style_1"></div>
                            <div class="swiper-button-prev swiper-button-prev_multi_style_1"></div>
                        <?php endif; ?>
                    </div>


                <?php
                elseif ($testimonial_style == 'multi_thumb_style_2'): ?>


                    <div class="swiper-container vc-multi-thumb-style-2-testimonial" dir="rtl">
                        <div class="swiper-wrapper">
                            <?php foreach ($testimonial_data as $testimonial): ?>
                                <div class="swiper-slide">
                                    <div class="vc-avatar-img">
                                        <img src="<?php echo esc_url($testimonial['img_src']); ?>" alt="testimonial-image"/>
                                    </div>
                                    <div class="vc-title">
                                        <div
                                            class="client-name"><?php echo($tag_title ? ('<' . $tag_title . '>') : '<div>'); ?> <?php echo esc_html($testimonial['name']); ?><?php echo($tag_title ? ('</' . $tag_title . '>') : '</div>'); ?></div>
                                        <div
                                            class="client-position"><?php echo esc_html($testimonial['position']); ?></div>
                                    </div>
                                    <?php if ($testimonial['content']): ?>
                                        <div class="vc-content">
                                            <p class="description"><?php echo esc_html($testimonial['content']); ?></p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <?php if ($show_pagination): ?>
                            <div class="testimonial-pagination"></div>
                        <?php endif; ?>

                        <?php if ($show_navigation): ?>
                            <div class="swiper-button-next swiper-button-next_multi_style_2"></div>
                            <div class="swiper-button-prev swiper-button-prev_multi_style_2"></div>
                        <?php endif; ?>
                    </div>

                <?php
                elseif ($testimonial_style == 'single_thumb'): ?>

                    <div class="swiper-container vc-content-testimonial">
                        <div class="swiper-wrapper">
                            <?php foreach ($testimonial_data as $testimonial) : ?>
                                <div class="swiper-slide">
                                    <div class="vc-avatar-testimonial">

                                        <div class="vc-avatar-img">
                                            <?php if (is_numeric($image_size)): ?>
                                                <div class="image-avatar"
                                                     style="background-image: url('<?php echo($testimonial['img_src']); ?>');height:<?php echo $image_size ?>px;width: <?php echo $image_size ?>px"></div>
                                            <?php endif; ?>
                                            <?php if (!is_numeric($image_size)): ?>
                                                <img class="image-avatar"
                                                     src="<?php echo esc_url($testimonial['img_src']); ?>" alt="testimonial-image"/>
                                            <?php endif; ?>
                                        </div>

                                    </div>

                                    <div class="vc-testimonial-content">
                                        <p class="title"><?php echo $testimonial['title']; ?></p>

                                        <p class="description"><?php echo $testimonial['content']; ?></p>

                                        <div class="name-position">
                                            <?php echo($tag_title ? ('<' . $tag_title . ' class="client-name">') : '<div class="client-name">'); ?> <?php echo esc_html($testimonial['name']); ?><?php echo($tag_title ? ('</' . $tag_title . '>') : '</div>'); ?>
                                            <p class="client-position">
                                                / <?php echo esc_html($testimonial['position']); ?></p>
                                        </div>
                                    </div>

                                </div>
                            <?php endforeach; ?>
                        </div>

                        <?php if ($show_pagination): ?>
                            <div class="testimonial-pagination"></div>
                        <?php endif; ?>

                        <?php if ($show_navigation): ?>
                            <div class="swiper-button-next swiper-button-next_single_thumb"></div>
                            <div class="swiper-button-prev swiper-button-prev_single_thumb"></div>
                        <?php endif; ?>
                    </div>



                <?php
                elseif ($testimonial_style == 'single_thumb_style_1'): ?>

                    <div class="swiper-container vc-content-testimonial">
                        <div class="swiper-wrapper">
                            <?php foreach ($testimonial_data as $testimonial) : ?>
                                <div class="swiper-slide">
                                    <div class="vc-item-testimonial">

                                        <div class="vc-avatar-img">
                                            <?php if (is_numeric($image_size)): ?>
                                                <div class="image-avatar"
                                                     style="background-image: url('<?php echo($testimonial['img_src']); ?>');height:<?php echo $image_size ?>px;width: <?php echo $image_size ?>px"></div>
                                            <?php endif; ?>
                                            <?php if (!is_numeric($image_size)): ?>
                                                <img class="image-avatar"
                                                     src="<?php echo esc_url($testimonial['img_src']); ?>" alt="testimonial-image"/>
                                            <?php endif; ?>
                                        </div>
                                        <div class="vc-content-nameposition">
                                            <p class="title"><?php echo $testimonial['title']; ?></p>

                                            <div class="vc-content">
                                                <p class="description"><?php echo $testimonial['content']; ?></p>
                                            </div>
                                            <div class="vc-nameposition">
                                                <div
                                                    class="client-name"><?php echo($tag_title ? ('<' . $tag_title . ' class="name-tag">') : '<div class="name-tag">'); ?> <?php echo esc_html($testimonial['name']); ?><?php echo($tag_title ? ('</' . $tag_title . '>') : '</div>'); ?>
                                                    <p class="client-position">
                                                        - <?php echo esc_html($testimonial['position']); ?></p></div>


                                            </div>

                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>

                        <?php if ($show_pagination): ?>
                            <div class="testimonial-pagination"></div>
                        <?php endif; ?>

                        <?php if ($show_navigation): ?>
                            <div class="swiper-button-next swiper-button-next_style_1"></div>
                            <div class="swiper-button-prev swiper-button-prev_style_1"></div>
                        <?php endif; ?>
                    </div>

                <?php
                elseif ($testimonial_style == 'single_thumb_style_2'): ?>

                    <div class="swiper-container vc-content-testimonial">
                        <div class="swiper-wrapper">
                            <?php foreach ($testimonial_data as $testimonial) : ?>
                                <div class="swiper-slide">
                                    <div class="vc-item-testimonial">

                                        <div class="vc-avatar-img">
                                            <?php if (is_numeric($image_size)): ?>
                                                <div class="image-avatar"
                                                     style="background-image: url('<?php echo($testimonial['img_src']); ?>');height:<?php echo $image_size ?>px;width: <?php echo $image_size ?>px"></div>
                                            <?php endif; ?>
                                            <?php if (!is_numeric($image_size)): ?>
                                                <img class="image-avatar"
                                                     src="<?php echo esc_url($testimonial['img_src']); ?>" alt="testimonial-image"/>
                                            <?php endif; ?>
                                        </div>
                                        <div class="vc-content-nameposition">
                                            <?php echo($tag_title ? ('<' . $tag_title . ' class="client-name">') : '<div class="client-name">'); ?> <?php echo esc_html($testimonial['name']); ?><?php echo($tag_title ? ('</' . $tag_title . '>') : '</div>'); ?>
                                            <p class="client-position"><?php echo esc_html($testimonial['position']); ?></p>

                                            <p class="title"><?php echo $testimonial['title']; ?></p>

                                            <p class="description"><?php echo $testimonial['content']; ?></p>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>

                        <?php if ($show_pagination): ?>
                            <div class="testimonial-pagination"></div>
                        <?php endif; ?>

                        <?php if ($show_navigation): ?>
                            <div class="swiper-button-next swiper-button-next_style_2"></div>
                            <div class="swiper-button-prev swiper-button-prev_style_2"></div>
                        <?php endif; ?>
                    </div>

                <?php endif; ?>

                </div>
                </div>
            <?php
            }

            return ob_get_clean();
        }

    } // End Element Class


// Element Class Init
    new NB_Element_Testimonial();
}
