<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;
    // $args = array(
    //     'post_type'   => 'service',
    //     'post_status' => 'publish',
    //     'posts_per_page' => -1,
    // );
    // $pages = get_posts( $args );

    // foreach($pages as $page){

    //     $title_page[$page->post_title]= 'page_'.$page->ID;

    // }

    // echo '<pre>';
    // print_r($title_page);
    // echo '</pre>';
    // die();
    // return $title_page;

/*
Element Description: VC Product Tabs
*/
if (class_exists("WPBakeryShortCode")) {
// Element Class 
class NB_Element_Pages_Tabs extends WPBakeryShortCode {
     
    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'vc_mapping' ), 12 );
        add_shortcode('page_tab', array($this, 'page_tab'));
    }

    public function get_all_page(){
        $args = array(
            'post_type'   => 'service',
            'post_status' => 'publish',
            'posts_per_page' => -1,
        );
        $pages = get_posts( $args );
        $title_page = array();
        foreach($pages as $page){
            $title_page[$page->post_title]= 'page_'.$page->ID;
        }
        return $title_page;
    }
    
    // Element Mapping
    public function vc_mapping() {
         
        // Stop all if VC is not enabled
        if ( !defined( 'WPB_VC_VERSION' ) ) {
            return;
        }
         
        vc_map(array(
            'name' => __('Service Tab'),
            'base' => 'page_tab',
            'category' => __('Teepro', 'teepro-elements'),
            'description' => __("Pages tab in one list.", "teepro-elements"),
            'icon' => 'icon-wpb-wp',
            'params' => array(
                array(
                    'type' => 'dropdown',
                    'heading' => __('Title Service', 'teepro-elements'),
                    'value' => $this->get_all_page(),
                    'param_name' => 'vc_title_pages',
                    'edit_field_class' => 'vc_col-sm-12',
                     'save_always' => true,
                ),
                array(
                    'param_name' => 'vc_title_tag',
                    'heading'    => esc_html__( 'Title Tag', "teepro-elements" ),
                    'type'       => 'dropdown',
                    'value'      => array(
                        __( 'H1', 'teepro-elements' )      => 'h1',
                        __( 'H2', 'teepro-elements' )      => 'h2',
                        __( 'H3', 'teepro-elements' )      => 'h3',
                        __( 'H4', 'teepro-elements' )     => 'h4',
                        __( 'H5', 'teepro-elements' )     => 'h5',
                        __( 'div', 'teepro-elements' )     => 'div',

                    ),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => __('Description', 'teepro-elements'),
                    'param_name' => 'vc_page_description',
                    'save_always' => true,
                    'edit_field_class' => 'vc_col-sm-12',
                ),
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__('Image Page', "teepro-elements"),
                    'param_name' => 'vc_page_tab_image',
                    'value' => '',
                ),
                array(
                    'type' => 'checkbox',
                    'heading' => __('Read More', 'teepro-elements'),
                    'description'=>'',
                    'param_name' => 'vc_page_read_more',
                    'value' => array(__('Yes', 'teepro-elements') => 'true'),
                    'std' => 'true',
                    'save_always' => true,
                ),
                array(
                    'type' => 'textfield',
                    'heading' => __('Extra class name', 'teepro-elements'),
                    'param_name' => 'vc_page_class',
                    'description' => __('Style particular content element differently - add a class name and refer to it in custom CSS.', 'teepro-elements'),
                    'save_always' => true,
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => __('CSS box', 'teepro-elements'),
                    'param_name' => 'css',
                    'group' => __('Design Options', 'teepro-elements'),
                    'save_always' => true,
                ),
            ),
            //'js_view' => 'VcColumnView'
        ));
        
    }     
     
    // Element HTML
    function page_tab($atts, $content = null) {

        extract(shortcode_atts(
                        array(
            'vc_title_pages'=>'',
            'vc_title_tag'=>'',
            'vc_page_description' => '',
            'vc_page_tab_image'=>'',
            'vc_page_read_more'=>'',
            'vc_page_class' => '',
            'css' => '',
                        ), $atts
        ));
       
        //$id_page=array();
        $id_page= explode('_',$vc_title_pages);
        $image='';
        if ( ! empty( $vc_page_tab_image ) ) {
            $img_id       = preg_replace( '/[^\d]/', '', $vc_page_tab_image);
            $image        .= wp_get_attachment_image( $img_id, 'full');
        }

    //      echo '<pre>';
    // print_r($atts);
    // echo '<pre>';
    // die;
        $css_class = 'nb_vc_page_tab ' . ($vc_page_class ? $vc_page_class : '');
        $output = '<div class="' . esc_attr($css_class) . '" >'
                .'<div class="page_tab_item">'
                .($image ? '<div class="page_tab_image">'.$image.'</div>' :'')
                .'<div class="page_tab_content">'
                . ($vc_title_pages ? '<'.($vc_title_tag?$vc_title_tag:'div').' class="page_tab_title">'.get_the_title($id_page[1]).'</'.($vc_title_tag?$vc_title_tag:'div').'>' : '')
                . ($vc_page_description ? '<span class="page_tab_description">'.$vc_page_description.'</span>' : '')
                . ($vc_page_read_more ? '<a class="page_tab_readmore" href="'.get_page_link(isset($id_page[1])?$id_page[1]:'').'">Read More</a>' : '')
                .'</div>'
                .'</div>'
                . '</div>';

        return $output;
    }
}
 
// Element Class Init
new NB_Element_Pages_Tabs(); 
}
