<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/*
Element Description: VC Product Tabs
*/
if (class_exists("WPBakeryShortCode")) {
// Element Class 
class NB_Element_Product_Tabs extends WPBakeryShortCode {
     
    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'vc_mapping' ), 12 );
        add_shortcode( 'teepro_product_tabs', array( $this, 'teepro_product_tabs' ) );
        // add_action( 'rest_api_init', array($this, 'register_product_tabs_route') );
        add_action('wp_ajax_product_tabs', array($this, 'product_tabs_ajax_content'));
        add_action('wp_ajax_nopriv_product_tabs', array($this, 'product_tabs_ajax_content'));
    }
    
    // Element Mapping
    public function vc_mapping() {
         
        // Stop all if VC is not enabled
        if ( !defined( 'WPB_VC_VERSION' ) ) {
            return;
        }

        $defaul_body_font ='Lobster Two';

	    if(function_exists('teepro_get_options')) {

            $get_body_font = explode(',', teepro_get_options('body_font_family'));

            if($get_body_font[0] === 'google') {
                $font_body_name = $get_body_font[1];

            }

            if(isset($font_body_name) ) {
                $defaul_body_font = $font_body_name;
            }
        }

        $args = array(
            'type' => 'post',
            'child_of' => 0,
            'parent' => '',
            'orderby' => 'parent',
            'order' => 'ASC',
            'hide_empty' => false,
            'hierarchical' => 1,
            'exclude' => '',
            'include' => '',
            'number' => '',
            'taxonomy' => 'product_cat',
            'pad_counts' => false,
        );
        $categories = get_categories( $args );
        $product_categories_dropdown[] = array(
                'label' => 'All categories',
                'value' => '',
        );
        $this->getCategoryChildsFull( 0, 0, $categories, 0, $product_categories_dropdown );
         
        vc_map( array(
            "name"          => __( "Product Tabs", "teepro-elements" ),
            "base"          => "teepro_product_tabs",
            'icon'          => 'icon-wpb-wp',
            "class"         => "",
            "category"      => __( "Teepro", "teepro-elements"),
            "params"        => array(

                array(
                    'type'          => 'dropdown',
                    'heading'       => esc_html__( 'Product type', 'teepro-elements' ),
                    'param_name'    => 'product_type',
                    'admin_label'   => true,
                    'value'         => array(
                            esc_html__('Recent', 'teepro-elements')       => 'recent',
                            esc_html__('Featured', 'teepro-elements') => 'featured',
                            esc_html__('Best Selling', 'teepro-elements') => 'best_selling',
                            esc_html__('Top Rated', 'teepro-elements')    => 'top_rated',
                            esc_html__('Mixed Order', 'teepro-elements')  => 'mixed_order'
                            ),
                    'description'   => esc_html__( 'Select type of product', 'teepro-elements' ),
                    'group'         =>'Content',
                ),

                array(
                    'type'          => 'param_group',
                    'value'         => '',
                    'heading'       => __('Product Categories', 'teepro-elements'),
                    'param_name'    => 'vc_tab_product_lists',
                    'group'         =>'Content',
                    'params'        => array(
                        array(
                            "type"          => "textfield",
                            "holder"        => "div",
                            "class"         => "",
                            "heading"       => __( "Label", "teepro-elements" ),
                            "param_name"    => "vc_tab_product_label",
                            "value"         => '',
                        ),
                        array(
                            'type'          => 'dropdown',
                            'heading'       => __('Product Cat', 'teepro-elements'),
                            'param_name'    => 'vc_tab_product_cat',
                            'value'         => $product_categories_dropdown,
                            'save_always'   => true,
                            'admin_label'   => true,
                            'dependency'    => array(
                                'element'   => 'layout',
                                'value_not_equal_to' => 'wp-list',
                            ),
                        ),
                        array(
                            'param_name' => 'cat_img',
                            'heading'    => esc_html__( 'Category Images', 'teepro-elements' ),
                            'type'       => 'attach_images',
                        ),
                        array(
                            'param_name'    => 'cat_img_url',
                            'heading'       => esc_html__( 'Image URLs', 'teepro-elements' ),
                            'type'          => 'exploded_textarea',
                            'description'   => esc_html__( 'Each URL is a new line', 'teepro-elements' )
                        ),
                        array(
                            'param_name'    => 'cat_img_button',
                            'heading'       => esc_html__( 'Image Buttons', 'teepro-elements' ),
                            'type'          => 'exploded_textarea',
                            'description'   => esc_html__( 'Each button is a new line', 'teepro-elements' )
                        ),
                        array(
                            'type' => 'dropdown',
                            'heading' => esc_html__( 'Category Images Align', 'teepro-elements' ),
                            'value' => array(
                                esc_html__('Left', 'teepro-elements') => 'left',
                                esc_html__('Right', 'teepro-elements') => 'right',
                                esc_html__('Top', 'teepro-elements') => 'top',
                                esc_html__('Bottom', 'teepro-elements') => 'bottom',
                            ),
                            'std' => 'left',
                            'param_name' => 'cat_img_align',                                
                            'save_always' => true,
                        ),
                    )
                ),
                array(
                   "type"               => "dropdown",
                   "heading"            => __( "Tab style", "teepro-elements" ),
                   "param_name"         => "tab_style",
                   'admin_label'        => true,
                   'group'              =>'Content',
                   'value'              => array(                            
                       __( 'Separated', 'teepro-elements' )       => 'separated',
                       __( 'Border bottom', 'teepro-elements' )   => 'border_bottom',
                   ),
                ),

                array(
                   "type"               => "dropdown",
                   "heading"            => __( "Tab align", "teepro-elements" ),
                   "param_name"         => "tab_title_align",
                   'group'              =>'Content',
                   'value'              => array(                            
                       __( 'Center', 'teepro-elements' )      => 'center',
                       __( 'Left', 'teepro-elements' )        => 'left',
                       __( 'Right', 'teepro-elements' )       => 'right'
                   ),
                ),
                array(
                    "type"          => "textfield",
                    "holder"        => "div",
                    "class"         => "",
                    "heading"       => __( "Limit", "teepro-elements" ),
                    "param_name"    => "vc_tab_product_limit",
                    'group'         =>'Content',
                    "value"         => '',
                ),
                array(
                   "type"           => "dropdown",
                   "heading"        => __( "Column", "teepro-elements" ),
                   "param_name"     => "vc_tab_product_col",
                   'std'            => 4,
                   'group'          =>'Content',
                   'value'          => array(                            
                       __( '1', 'teepro-elements' )       => 1,
                       __( '2', 'teepro-elements' )       => 2,
                       __( '3', 'teepro-elements' )       => 3,
                       __( '4', 'teepro-elements' )       => 4,
                       __( '5', 'teepro-elements' )       => 5,
                   ),
                ),

                array(
                    "type"          => "textfield",
                    "class"         => "",
                    'group'         =>'Content',
                    "heading"       => __( "Margin top", "teepro-elements" ),
                    "param_name"    => "content_margin_top",
                    "value"         => '', 
                    "description"   => __( "Add Margin top of content ( Example: 15px )", "teepro-elements" )
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Heading', 'teepro-elements' ),
                    'param_name'  => 'heading_tab',
                    'value'       => '',
                    'group'       =>'Heading',
                ),
                array(
                    'type'          => 'google_fonts',
                    'param_name'    => 'heading_font',
                    'group'         =>'Heading',
                    'value'         => '',
                    'settings' => array(
                        'fields' => array(
                            'font_family'=> $defaul_body_font,
                            'font_style'=>'400 regular:400:normal',
                            'font_family_description' => __( 'Select Font Family.', 'teepro-elements' ),
                            'font_style_description' => __( 'Select Font Style.', 'teepro-elements' ),
                        ),
                    ),
                    'weight' => 0
                ),
                array(
                    'type'        => 'colorpicker',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Heading Color', 'teepro-elements' ),
                    'param_name'  => 'heading_tab_color',
                    'value'       => '',
                    'group'       =>'Heading',
                ),
                array(
                    "type" => "textfield",
                    "class" => "",
                    'group'=>'Heading',
                    "heading" => __( "Heading Font size", "teepro-elements" ),
                    "param_name" => "heading_font_size",
                    "value" => '', 
                    "description" => __( "Add heading font size ( Example: 15px or 15% )", "teepro-elements" )
                ),

                array(
                    'type' => 'checkbox',
                    'heading' => __( 'Show Heading Line', 'teepro-elements' ),
                    'param_name' => 'show_heading_line',
                    'group'=>'Heading',
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Sub Heading', 'teepro-elements' ),
                    'param_name'  => 'sub_heading_tab',
                    'value'       => '',
                    'group'       =>'Heading',
                ),
                array(
                    'type'        => 'colorpicker',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Sub Heading Color', 'teepro-elements' ),
                    'param_name'  => 'sub_heading_tab_color',
                    'value'       => '',
                    'group'       =>'Heading',
                ),
                array(
                    "type" => "textfield",
                    "class" => "",
                    'group'=>'Heading',
                    "heading" => __( "Sub Heading Font size", "teepro-elements" ),
                    "param_name" => "sub_heading_font_size",
                    "value" => '', 
                    "description" => __( "Add sub heading font size ( Example: 15px or 15% )", "teepro-elements" )
                ),                 
            )
        ));
    }     
     
    // Element HTML
    public function teepro_product_tabs($atts, $content = null)
    {
        extract( shortcode_atts( array(
            'heading_tab'               => '',
            'heading_tab_color'         => '',
            'show_heading_line'         => '',
            'sub_heading_tab'           => '',
            'sub_heading_tab_color'     => '',
            'heading_font'              => '',
            'heading_font_size'         => '',
            'sub_heading_font_size'     => '',
            'tab_style'                 => 'separated',
            'tab_title_align'           => 'center',
            'product_type'              => '',
            'vc_tab_product_lists'      => '',
            'vc_tab_product_limit'      => 8,
            'vc_tab_product_col'        => 4,
            'content_margin_top'        => '',
            ''
        ), $atts ) );

        ob_start();

        $vc_tab_product_lists       = vc_param_group_parse_atts($vc_tab_product_lists);

        // Generate custom ID
        $product_tab_id = uniqid('product_tab_');

        if($vc_tab_product_lists):

            $columns = teepro_get_options('nbcore_loop_columns');

            if( $vc_tab_product_col == 4 ) {
                $columns = 'four-columns';
            } elseif( $vc_tab_product_col == 3 ) {
                $columns = 'three-columns';
            } elseif( $vc_tab_product_col == 2 ) {
                $columns = 'two-columns';
            } elseif( $vc_tab_product_col == 5 ) {
                $columns = 'five-columns';
            }

            $tab_title_align_class = 'align-' . $tab_title_align;
            $tab_style_class = 'style-' . $tab_style;

            $heading_tab_inline_css = $sub_heading_tab_inline_css = $content_margin_top_inline_css = '';

            $heading_font_data        = $this->getFontsData( $heading_font );
            $heading_tab_inline_css  .= $this->googleFontsStyles( $heading_font_data );
            $this->enqueueGoogleFonts( $heading_font_data );

            // echo '<pre>';
            // print_r($heading_font);
            // echo '</pre>';
            // die;


            if($heading_tab_color != '') {
                $heading_tab_inline_css .= 'color: ' . $heading_tab_color . ';';
            }
            
            if($heading_font_size != '') {
                $heading_tab_inline_css .= 'font-size: ' . $heading_font_size . ';';
            }

            $heading_tab_css = $heading_tab_inline_css != '' ? 'style="' . $heading_tab_inline_css . '"' : '';


            if($sub_heading_tab_color != '') {
                $sub_heading_tab_inline_css .= 'color: ' . $sub_heading_tab_color . ';';
            }

            if($sub_heading_font_size != '') {
                $sub_heading_tab_inline_css .= 'font-size: ' . $sub_heading_font_size . ';';
            }

            $sub_heading_tab_css = $sub_heading_tab_inline_css != '' ? 'style="' . $sub_heading_tab_inline_css . '"' : '';


            $no_header_class = ($heading_tab == '' && $sub_heading_tab == '') ? 'no-heading' : '';

            $show_heading_line_class = $show_heading_line ? 'show_heading_line' : '';

            if($content_margin_top != '') {
                $content_margin_top_inline_css = 'style="margin-top:' . $content_margin_top . '"';
            }

            $container_width = teepro_get_options('nbcore_container_width');

            $wide_class = isset($container_width) && $container_width > '1170' ? ' wide-container' : '';

        ?>
        <div class="shop-main teepro-product-tabs <?php echo esc_attr($columns)  . esc_attr($wide_class);?>">
            <div class="vc-tab-product-wrapper">
                
                <div class="vc-tab-product-header">

                    <?php if($heading_tab != '' || $sub_heading_tab != ''):?>
                        <div class="product-tab-header <?php echo esc_attr($show_heading_line_class);?>">
                            <?php if($sub_heading_tab != ''):?>
                                <p <?php echo $sub_heading_tab_css;?>><?php echo esc_html($sub_heading_tab);?></p>
                            <?php endif;?>

                            <?php if($heading_tab != ''):?>
                                <h2 <?php echo $heading_tab_css;?>><?php echo esc_html($heading_tab);?></h2>
                            <?php endif;?>
                        </div>
                    <?php endif;?>

                    <ul class="tab-label <?php echo esc_attr($tab_title_align_class);?> <?php echo esc_attr($tab_style_class);?> <?php echo esc_attr($no_header_class);?>">

                        <?php 
                            $div_content                = '';
                            $first_tab_label            = '';
                            $first_cat_img_align_class  = '';
                        ?>
                        <?php foreach ($vc_tab_product_lists as $tab_key => $tab_value):

                            $term                   = get_term_by( 'slug', $tab_value['vc_tab_product_cat'], 'product_cat' );
                            $cat_name               = is_object($term) ? $term->name : esc_html__('All categories');
                            $tab_label              = isset($tab_value['vc_tab_product_label']) ? $tab_value['vc_tab_product_label'] : $cat_name;
                            $cat_images             = isset($tab_value['cat_img']) ? $tab_value['cat_img'] : '';
                            $cat_img_align_class    = ! empty($tab_value['cat_img']) && ! empty($tab_value['cat_img_align']) ? 'img-align-' . $tab_value['cat_img_align'] : '';
                            $cat_img_align          = isset($tab_value['cat_img_align']) ? $tab_value['cat_img_align'] : 'left';
                            $cat_img_urls           = isset($tab_value['cat_img_url']) ? $tab_value['cat_img_url'] : '';
                            $cat_img_buttons        = isset($tab_value['cat_img_button']) ? $tab_value['cat_img_button'] : '';

                            if($tab_key == 0) {
                                $first_tab_label = $tab_label;
                                $first_cat_img_align_class = $cat_img_align_class;
                            }
                            else {
                                $current_lang = function_exists('icl_object_id') ? ICL_LANGUAGE_CODE : '';
                                $div_content .= '<div id="' . md5($product_tab_id.$tab_key.$tab_label).'" class="tab-panel ' . esc_attr($cat_img_align_class) . '" data-term_id="'.esc_attr($tab_value['vc_tab_product_cat']).'" data-limit="'.esc_attr($vc_tab_product_limit).'" data-product-type="'.esc_attr($product_type).'" data-cat-img="' . esc_attr($cat_images) . '" data-cat-img-align="' . esc_attr($cat_img_align) . '" data-cat-img-urls="' . esc_attr($cat_img_urls) . '" data-cat-img-buttons="' . esc_attr($cat_img_buttons) . '" data-lang="' . esc_attr($current_lang) . '"></div>';
                            }
                        ?>
                            <li <?php if($tab_key == 0) echo 'class="active"';?>>
                                <a href="#<?php echo md5($product_tab_id.$tab_key.$tab_label);?>"><?php echo esc_html($tab_label);?></a>
                            </li>
                        <?php endforeach;?>
                    </ul>
                </div>
                
                <div class="vc-tab-product-content" <?php echo $content_margin_top_inline_css; ?>>

                    <div id="<?php echo md5($product_tab_id.'0'.$first_tab_label);?>" class="tab-panel panel-active <?php echo esc_attr( $first_cat_img_align_class );?>" >
                        <?php

                            if ( ! empty( $vc_tab_product_lists[0]['cat_img'] ) ) {

                                echo '<div class="cat_img">';

                                $cat_images         = explode(',', $vc_tab_product_lists[0]['cat_img']);
                                $cat_image_buttons  = isset($vc_tab_product_lists[0]['cat_img_button']) ? explode(',', $vc_tab_product_lists[0]['cat_img_button']) : array();

                                foreach($cat_images as $index => $cat_img)
                                {
                                    $img_data = wp_get_attachment_image_src( $cat_img, 'full' );

                                    $image_links        = isset($vc_tab_product_lists[0]['cat_img_url']) ? explode(',', $vc_tab_product_lists[0]['cat_img_url']) : '';

                                    $image_link         = isset($image_links[$index]) ? 'href="' . $image_links[$index] . '"' : '';

                                    $cat_image_button   = isset($cat_image_buttons[$index]) ? '<span class="cat_img_button">' . $cat_image_buttons[$index] . '</span>' : '';

                                    echo '<a ' . $image_link . '><img src="' . esc_url( $img_data[0] ) . '" alt="' . esc_attr__( 'image-cat', 'teepro-elements' ) . '" />' . $cat_image_button . '</a>';
                                }

                                echo '</div>';
                            }

                            $product_cat = isset($vc_tab_product_lists[0]['vc_tab_product_cat']) ? $vc_tab_product_lists[0]['vc_tab_product_cat'] : '';

                            set_query_var( 'temp_style', 'grid-type' );

                            $tab_args = array(
                                'post_type' => 'product',
                                'post_status' => 'publish',
                                'product_cat' => $product_cat,
                                'posts_per_page' => $vc_tab_product_limit
                            );

                            $this->nb_filter_product_by_product_type($tab_args, $product_type);

                            $tab_product = new WP_Query( $tab_args );

                            if ( $tab_product->have_posts() ) :
                                echo '<div class="products row grid-type">';

                                while ( $tab_product->have_posts() ) : $tab_product->the_post();
                                    wc_get_template_part( 'content', 'product' );
                                endwhile;

                                echo '</div>';
                            endif;
                            wp_reset_postdata();
                        ?>
                   </div>
                   
                   <?php print $div_content; ?>
                </div>
            </div>
        </div>
         <?php

        endif;
         
         return ob_get_clean();
    }

    // public function register_product_tabs_route() {
    //     register_rest_route(
    //         'wp/v2',
    //         '/product_tabs',
    //         array(
    //             'methods'  => 'POST',
    //             'callback' => array($this, 'rest_product_tabs_callback'),
    //         )
    //     );
    // }

    function product_tabs_ajax_content() {
        set_query_var( 'temp_style', 'grid-type' );
        $product_cat        = $_POST['cat'];
        $limit              = absint($_POST['limit']);
        $cat_imgs           = $_POST['cat_img'];
        $cat_img_urls       = $_POST['cat_img_urls'];
        $cat_img_buttons    = $_POST['cat_img_buttons'];
        $product_type       = $_POST['product_type'];
        $current_lang       = $_POST['current_lang'];

        if ( ! empty( $cat_imgs ) ) {

            echo '<div class="cat_img">';

            $cat_images         = explode(',', $cat_imgs);
            $cat_img_buttons    = explode(',', $cat_img_buttons);

            foreach($cat_images as $index => $cat_img)
            {
                $img_data = wp_get_attachment_image_src( $cat_img, 'full' );

                $image_links = isset($cat_img_urls) ? explode(',', $cat_img_urls) : '';

                $image_link = isset($image_links[$index]) ? 'href="' . $image_links[$index] . '"' : '';

                $cat_image_button   = isset($cat_image_buttons[$index]) ? '<span class="cat_img_button">' . $cat_image_buttons[$index] . '</span>' : '';

                echo '<a ' . $image_link . '><img src="' . esc_url( $img_data[0] ) . '" alt="' . esc_attr__( 'image-cat', 'teepro-elements' ) . '" />' . $cat_image_button . '</a>';
            }

            echo '</div>';
        }
        

        $tab_args = array(
            'post_type' => 'product',
            'post_status' => 'publish',
            'product_cat' => $product_cat,
            'posts_per_page' => $limit
        );

        if ( $current_lang != '' ) {
            do_action( 'wpml_switch_language', $current_lang ); // switch the content language
        }

        $this->nb_filter_product_by_product_type( $tab_args, $product_type );

        
        $tab_product = new WP_Query( $tab_args );


        if ( $tab_product->have_posts() ) :
            echo '<div class="products row grid-type">';
                while ( $tab_product->have_posts() ) : $tab_product->the_post();

                    wc_get_template_part( 'content', 'product' );

                endwhile;
            echo '</div>';
        endif;
        wp_reset_postdata();
        die();
        
    }

    protected function getCategoryChildsFull( $parent_id, $pos, $array, $level, &$dropdown ) {

        for ( $i = $pos; $i < count( $array ); $i ++ ) {

            if ( $array[ $i ]->category_parent == $parent_id ) {
                $name = str_repeat( '- ', $level ) . $array[ $i ]->name;
                $value = $array[ $i ]->slug;
                $dropdown[] = array(
                    'label' => $name,
                    'value' => $value,
                );
                $this->getCategoryChildsFull( $array[ $i ]->term_id, $i, $array, $level + 1, $dropdown );
            }
        }
    }

    protected function nb_filter_product_by_product_type( &$args = array(), $product_type = 'recent' ){
        switch( $product_type ){
            case 'sale':
                $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
            break;
            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
            break;
            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;
            case 'top_rated':
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;
            case 'mixed_order':
                $args['orderby']    = 'rand';
            break;
            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
            break;
        }
    }

    //********************************//
    // GOOGLE FONTS PRIVATE FUNCTIONS //
    //********************************//

    // Build the string of values in an Array
    protected function getFontsData( $fontsString ) {

        // Font data Extraction
        $googleFontsParam = new Vc_Google_Fonts();
        $fieldSettings = array();
        $fontsData = strlen( $fontsString ) > 0 ? $googleFontsParam->_vc_google_fonts_parse_attributes( $fieldSettings, $fontsString ) : '';
        return $fontsData;

    }

    // Build the inline style starting from the data
    protected function googleFontsStyles( $fontsData ) {
        $styles = array();
        // Inline styles
        if(isset($fontsData['values'])){
            $fontFamily = explode( ':', $fontsData['values']['font_family'] );
            $styles[] = 'font-family:' . $fontFamily[0];
            $fontStyles = explode( ':', $fontsData['values']['font_style'] );
            $styles[] = 'font-weight:' . $fontStyles[1];
            $styles[] = 'font-style:' . $fontStyles[2];
        }


        $inline_style = '';
        foreach( $styles as $attribute ){
            $inline_style .= $attribute.'; ';
        }

        return $inline_style;

    }

    // Enqueue right google font from Googleapis
    protected function enqueueGoogleFonts( $fontsData ) {

        // Get extra subsets for settings (latin/cyrillic/etc)
        $settings = get_option( 'wpb_js_google_fonts_subsets' );
        if ( is_array( $settings ) && ! empty( $settings ) ) {
            $subsets = '&subset=' . implode( ',', $settings );
        } else {
            $subsets = '';
        }

        // We also need to enqueue font from googleapis
        if ( isset( $fontsData['values']['font_family'] ) ) {
            wp_enqueue_style(
                'vc_google_fonts_' . vc_build_safe_css_class( $fontsData['values']['font_family'] ),
                '//fonts.googleapis.com/css?family=' . $fontsData['values']['font_family'] . $subsets
            );
        }

    }
     
} // End Element Class
 
 
// Element Class Init
new NB_Element_Product_Tabs(); 
}
