<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/*
Element Description: Our Customers
*/
if (class_exists("WPBakeryShortCode")) {
// Element Class 
    class NB_Element_Our_Customers extends WPBakeryShortCode
    {

        // Element Init
        function __construct()
        {
            add_action('init', array($this, 'vc_mapping'), 12);
            add_shortcode('teepro_our_customers', array($this, 'teepro_our_customers'));
        }

        // Element Mapping
        public function vc_mapping()
        {

            // Stop all if VC is not enabled
            if (!defined('WPB_VC_VERSION')) {
                return;
            }

            vc_map(array(
                "name"          => __("Our Customers", "teepro-elements"),
                "base"          => "teepro_our_customers",
                'icon'          => 'icon-wpb-wp',
                "class"         => "",
                "category"      => __("Teepro", "teepro-elements"),
                "params"        => array(


                    array(
                        'type' => 'attach_images',
                        'heading' => __('Customer Images', 'teepro-elements'),
                        'param_name' => 'customer_images',
                        'value' => '',
                        'description' => __('Select image from media library.', 'teepro-elements'),
                        'admin_label' => true,
                    ),

                    array(
                        "type" => "textfield",
                        "heading" => __("Customers per view (Extra Large Device)", 'teepro-elements'),
                        "param_name" => "customers_per_view_xl",
                        "value" => '',
                        'description' => __('Number of customers per view. Default is 6', 'teepro-elements'),
                        'edit_field_class' => 'vc_col-xs-3 vc_column',
                    ),

                    array(
                        "type" => "textfield",
                        "heading" => __("Customers per view (Large Device)", 'teepro-elements'),
                        "param_name" => "customers_per_view_lg",
                        "value" => '',
                        'description' => __('Default is 4', 'teepro-elements'),
                        'edit_field_class' => 'vc_col-xs-3 vc_column',
                    ),

                    array(
                        "type" => "textfield",
                        "heading" => __("Customers per view (Medium Device)", 'teepro-elements'),
                        "param_name" => "customers_per_view_md",
                        "value" => '',
                        'description' => __('Default is 3', 'teepro-elements'),
                        'edit_field_class' => 'vc_col-xs-3 vc_column',
                    ),

                    array(
                        "type" => "textfield",
                        "heading" => __("Customers per view (Small Device)", 'teepro-elements'),
                        "param_name" => "customers_per_view_sm",
                        "value" => '',
                        'description' => __('Default is 2', 'teepro-elements'),
                        'edit_field_class' => 'vc_col-xs-3 vc_column',
                    ),

                    array(
                        "type" => "textfield",
                        "heading" => __("Customers per column", 'teepro-elements'),
                        "param_name" => "customers_per_column",
                        "value" => '',
                        'description' => __('Number of customers per column, for multirow layout. Default is 1', 'teepro-elements'),
                        'edit_field_class' => 'vc_col-xs-6 vc_column',
                    ),

                    array(
                        'type' => 'checkbox',
                        'heading' => __('Show Navigation', 'teepro-elements'),
                        'param_name' => 'show_navigation',
                    ),

                    array(
                        'type' => 'checkbox',
                        'heading' => __('Show Pagination', 'teepro-elements'),
                        'param_name' => 'show_pagination',
                    ),

                    array(
                        "type" => "dropdown",
                        "heading" => __("Dot Style", "teepro-elements"),
                        "param_name" => "dot_style",
                        'value' => array(
                            __('Circle', 'teepro-elements') => 'circle',
                            __('Rectangle', 'teepro-elements') => 'rectangle',

                        ),                        
                        'dependency' => array(
                            'element' => 'show_pagination',
                            'value'   => 'true',
                        ),

                    ),

                    array(
                        'type' => 'checkbox',
                        'heading' => __('Auto play', 'teepro-elements'),
                        'param_name' => 'autoplay',
                    ),

                    array(
                        'type' => 'checkbox',
                        'heading' => __('Show image border', 'teepro-elements'),
                        'param_name' => 'show_image_border',
                    ),
                )
            ));

        }

        // Element HTML
        public function teepro_our_customers($atts, $content = null)
        {
            extract(shortcode_atts(array(
                'customer_images'       => '',
                'customers_per_view_xl' => 6,
                'customers_per_view_lg' => 4,
                'customers_per_view_md' => 3,
                'customers_per_view_sm' => 2,
                'customers_per_column'  => 1,
                'show_navigation'       => '',
                'show_pagination'       => '',
                'dot_style'             => 'circle',
                'autoplay'              => false,
                'show_image_border'     => false,

            ), $atts));

            ob_start();

            
            if($customer_images) {
                
                // Generate custom ID
                $our_customers_id   = uniqid('our_customers_');
                $customer_image_arr = explode(',', $customer_images);

                $show_image_border_class = '';
                if($show_image_border) {
                    $show_image_border_class = ' has-border';
                }

                ?>

                <div class="teepro-our-customers" id="<?php echo esc_attr($our_customers_id);?>">
                    <div class="our-customers-wrap"
                        data-autoplay="<?php echo esc_attr($autoplay);?>" data-customers-per-view-xl="<?php echo esc_attr($customers_per_view_xl);?>" data-customers-per-view-lg="<?php echo esc_attr($customers_per_view_lg);?>" data-customers-per-view-md="<?php echo esc_attr($customers_per_view_md);?>" data-customers-per-view-sm="<?php echo esc_attr($customers_per_view_sm);?>" data-customers-per-column="<?php echo esc_attr($customers_per_column);?>">

                        <div class="swiper-container our-customer-images">
                            <div class="swiper-wrapper">
                                <?php foreach($customer_image_arr as $customer_image_id): ?>
                                    <?php $customer_image_data = wp_get_attachment_image_src($customer_image_id, 'thumbnail'); ?>
                                    <div class="swiper-slide">
                                        <div class="customer-img<?php echo $show_image_border_class;?>">
                                            <img src="<?php echo esc_url($customer_image_data[0]); ?>" alt="Our Customer"/>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>

                            <?php if ($show_pagination): ?>
                                <div class="our-customers-pagination <?php echo esc_attr($dot_style) . '-style';?>"></div>
                            <?php endif; ?>

                            <?php if ($show_navigation): ?>
                                <div class="swiper-button-next"></div>
                                <div class="swiper-button-prev"></div>
                            <?php endif; ?>
                        </div>

                    </div>
                </div>
                <?php
                
            }

            return ob_get_clean();
        }

    } // End Element Class


// Element Class Init
    new NB_Element_Our_Customers();
}
