<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/*
Element Description: Image Slider
*/
if (class_exists("WPBakeryShortCode")) {
// Element Class 
    class NB_Element_Image_Slider extends WPBakeryShortCode
    {

        // Element Init
        function __construct()
        {
            add_action('init', array($this, 'vc_mapping'), 12);
            add_shortcode('teepro_image_slider', array($this, 'teepro_image_slider'));
        }

        // Element Mapping
        public function vc_mapping()
        {

            // Stop all if VC is not enabled
            if (!defined('WPB_VC_VERSION')) {
                return;
            }

            vc_map(array(
                "name"          => __("Image Slider", "teepro-elements"),
                "base"          => "teepro_image_slider",
                'icon'          => 'icon-wpb-wp',
                "class"         => "",
                "category"      => __("Teepro", "teepro-elements"),
                "params"        => array(


                    array(
                        'type' => 'attach_images',
                        'heading' => __('Slider Images', 'teepro-elements'),
                        'param_name' => 'slider_images',
                        'value' => '',
                        'description' => __('Select image from media library.', 'teepro-elements'),
                        'admin_label' => true,
                    ),

                    array(
                        "type" => "textfield",
                        "heading" => __("Sliders per view", "teepro-elements"),
                        "param_name" => "sliders_per_view_xl",
                        "value" => '',
                        'description' => __('Number of slider per view. Default is 3', 'teepro-elements'),
                        'edit_field_class' => 'vc_col-xs-4 vc_column',
                    ),

                    array(
                        "type" => "textfield",
                        "heading" => __("Sliders stretch", "teepro-elements"),
                        "param_name" => "sliders_stretch",
                        "value" => '',
                        'description' => __('Stretch space between slides (in px). Default is 0', 'teepro-elements'),
                        'edit_field_class' => 'vc_col-xs-4 vc_column',
                    ),

                    array(
                        'type' => 'checkbox',
                        'heading' => __('Show Navigation', 'teepro-elements'),
                        'param_name' => 'show_navigation',
                    ),

                    array(
                        'type' => 'checkbox',
                        'heading' => __('Show Pagination', 'teepro-elements'),
                        'param_name' => 'show_pagination',
                    ),

                    array(
                        'type' => 'checkbox',
                        'heading' => __('Auto play', 'teepro-elements'),
                        'param_name' => 'autoplay',
                    ),
                    array(
                        'type' => 'checkbox',
                        'heading' => __('Loop', 'teepro-elements'),
                        'param_name' => 'loop',
                    ),
                )
            ));

        }

        // Element HTML
        public function teepro_image_slider($atts, $content = null)
        {
            extract(shortcode_atts(array(
                'slider_images'         => '',
                'sliders_per_view_xl'   => 3,
                'sliders_stretch'       => 0,
                'show_navigation'       => false,
                'show_pagination'       => false,
                'autoplay'              => false,
                'loop'                  => false,

            ), $atts));

            ob_start();

            
            if($slider_images) {
                
                // Generate custom ID
                $image_slider_id   = uniqid('image_slider_');
                $slider_image_arr = explode(',', $slider_images);

                ?>

                <div class="teepro-image-slider" id="<?php echo esc_attr($image_slider_id);?>">
                    <div class="image-slider-wrap"
                        data-autoplay="<?php echo esc_attr($autoplay);?>" data-loop="<?php echo esc_attr($loop);?>" data-sliders-per-view-xl="<?php echo esc_attr($sliders_per_view_xl);?>" data-sliders-stretch="<?php echo esc_attr($sliders_stretch);?>">

                        <div class="swiper-container image-slider-block">
                            <div class="swiper-wrapper">
                                <?php foreach($slider_image_arr as $slider_image_id): ?>
                                    <?php $slider_image_data = wp_get_attachment_image_src($slider_image_id, 'full'); ?>
                                    <div class="swiper-slide">
                                        <div class="slider-img">
                                            <img src="<?php echo esc_url($slider_image_data[0]); ?>" alt=""/>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>

                            <?php if ($show_pagination): ?>
                                <div class="image-slider-pagination"></div>
                            <?php endif; ?>

                            <?php if ($show_navigation): ?>
                                <div class="swiper-button-next"></div>
                                <div class="swiper-button-prev"></div>
                            <?php endif; ?>

                        </div>

                    </div>
                </div>
                <?php
                
            }

            return ob_get_clean();
        }

    } // End Element Class


// Element Class Init
    new NB_Element_Image_Slider();
}
