<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/*
Element Description: VC Blog
*/
if (class_exists("WPBakeryShortCode")) {
// Element Class 
class NB_Element_Blog extends WPBakeryShortCode {
	function __construct() {
        add_action( 'init', array( $this, 'netbase_vc_map' ), 12 );
        add_shortcode( 'nb_posts', array( $this, 'nb_posts_render' ) );
    }
     
    // Element Mapping
	public function netbase_vc_map() {
		if ( !defined( 'WPB_VC_VERSION' ) ) {
	        return;
		}
		$post_categories_dropdown = array();
		$post_categories_dropdown[] = array(
			'label' => __('Select category', 'teepro-elements'),
			'value' => '',
		);
		$post_categories_values = $this->getCategories();
		
		$post_categories_dropdown = array_merge($post_categories_dropdown, $post_categories_values);


		// echo '<pre>';
		// print_r($post_categories_dropdown);
		// echo '</pre>';
		// die;

		$order_posts = array(
			'',
			__('Date', 'teepro-elements') => 'date',
			__('ID', 'teepro-elements') => 'ID',
			__('Author', 'teepro-elements') => 'author',
			__('Title', 'teepro-elements') => 'title',
			__('Name', 'teepro-elements') => 'name',
			__('Modified', 'teepro-elements') => 'modified',
			__('Parent', 'teepro-elements') => 'parent',
			__('Random', 'teepro-elements') => 'rand',
			__('Comment count', 'teepro-elements') => 'comment_count',
			__('Menu order', 'teepro-elements') => 'menu_order',
		);
		$order_way_values = array(
			'',
			__('Descending', 'teepro-elements') => 'DESC',
			__('Ascending', 'teepro-elements') => 'ASC',
		);		
		vc_map(array(
			"name" => __("Blog"),
			"base" => "nb_posts",
			'icon' => 'icon-wpb-wp',
			"category" => __('Teepro', 'teepro-elements'),
			"params" => array(
				array(
					'type' => 'dropdown',
					'heading' => __('Style', 'teepro-elements'),
					'param_name' => 'style',
					'value' => array(
						__('Default', 'teepro-elements') => '',
						__('Post Slider', 'teepro-elements') => 'wppostslider',
						__('Post Masonry', 'teepro-elements') => 'wppostmasonry',
					),
					'save_always' => true,
				),
				// array(
				// 	'type' => 'checkbox',
				// 	'heading' => __('Equal height', 'teepro-elements'),
				// 	'param_name' => 'equal_height',
				// 	'value' => array(__('Yes', 'teepro-elements') => 'true'),
				// 	'std' => 'true',
				// 	'save_always' => true,
				// 	'dependency' => array(
				// 		'element' => 'style',
				// 		'value_not_equal_to' => array('wppostmasonry'),
				// 	),
				// ),
				array(
					'type' => 'dropdown',
					'heading' => __('Layout', 'teepro-elements'),
					'param_name' => 'layout',
					'value' => array(
						__('List - No image', 'teepro-elements') => 'wp-list',
						__('Image Top', 'teepro-elements') => 'wp-img-top',
						__('Image Left', 'teepro-elements') => 'wp-img-left',
						__('Content Absolute', 'teepro-elements') => 'wp-content-absolute',
						// __('Image Right', 'teepro-elements') => 'wp-img-right',
						// __('Image Left/Right', 'teepro-elements') => 'wp-img-leftright',
						// __('Image Top/Bottom', 'teepro-elements') => 'wp-img-topbot',
						// __('Blog 1', 'teepro-elements') => 'wp-blog1',
						// __('Blog 2', 'teepro-elements') => 'wp-blog2',
						// __('Blog 3', 'teepro-elements') => 'wp-blog3',
						// __('Grid', 'teepro-elements') => 'wp-grid',
					),
					'std' => 'wp-img-top',
					'save_always' => true,
				),
				array(
					'type' => 'textfield',
					'heading' => __('Per page', 'teepro-elements'),
					'value' => 12,
					'save_always' => true,
					'param_name' => 'per_page',
					'description' => __('The "per_page" shortcode determines how many posts to show on the page', 'teepro-elements'),
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Columns - Large Desktops', 'teepro-elements'),
					'value' => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
						'6' => '6',
					),
					'std' => '4',
					'param_name' => 'columns-xl',
					'save_always' => true,
					'edit_field_class' => 'vc_col-sm-6',
					'dependency' => array(
						'element' => 'layout',
						'value_not_equal_to' => 'wp-list',
					),
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Columns - Desktops', 'teepro-elements'),
					'value' => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
						'6' => '6',
					),
					'std' => '4',
					'param_name' => 'columns-lg',
					'save_always' => true,
					'edit_field_class' => 'vc_col-sm-6',
					'dependency' => array(
						'element' => 'layout',
						'value_not_equal_to' => 'wp-list',
					),
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Columns - Tablets', 'teepro-elements'),
					'value' => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
						'6' => '6',
					),
					'std' => '3',
					'param_name' => 'columns-md',
					'save_always' => true,
					'edit_field_class' => 'vc_col-sm-6',
					'dependency' => array(
						'element' => 'layout',
						'value_not_equal_to' => 'wp-list',
					),
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Columns - Mobile Landscape', 'teepro-elements'),
					'value' => array(
						'1' => '1',
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
						'6' => '6',
					),
					'std' => '2',
					'param_name' => 'columns-sm',
					'save_always' => true,
					'edit_field_class' => 'vc_col-sm-6',
					'dependency' => array(
						'element' => 'layout',
						'value_not_equal_to' => 'wp-list',
					),
				),
				array(
					'type' => 'textfield',
					'heading' => __('Rows', 'teepro-elements'),
					'value' => 1,
					'param_name' => 'rows',
					'save_always' => true,
					'description' => __('The rows attribute controls how many rows wide the posts should be before wrapping.', 'teepro-elements'),
					'dependency' => array(
						'element' => 'style',
						'value' => array('wppostslider'),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => __('Show Filter by categories', 'teepro-elements'),
					'param_name' => 'show_filter',
					'value' => array(__('Yes', 'teepro-elements') => 'true'),
					'save_always' => true,
					'dependency' => array(
						'element' => 'style',
						'value' => array('wppostmasonry'),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => __('Filter by categories', 'teepro-elements'),
					'param_name' => 'filter',
					'value' => array(__('Yes', 'teepro-elements') => 'true'),
					'save_always' => true,
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					'type' => 'autocomplete',
					'heading' => __('Categories', 'teepro-elements'),
					'param_name' => 'category',
					'settings' => array(
						'multiple' => true,
						'min_length' => 1,
						'groups' => true,
						'unique_values' => true,
						'display_inline' => true,
						'delay' => 500,
						'auto_focus' => true,
						'values' => $post_categories_values,
					),
					'dependency' => array(
						'element' => 'filter',
						'value' => array('true'),
					),
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Order by', 'teepro-elements'),
					'param_name' => 'orderby',
					'value' => $order_posts,
					'save_always' => true,
					'description' => sprintf(__('Select how to sort retrieved posts. More at %s.', 'teepro-elements'), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>'),
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Sort order', 'teepro-elements'),
					'param_name' => 'order',
					'value' => $order_way_values,
					'save_always' => true,
					'description' => sprintf(__('Designates the ascending or descending order. More at %s.', 'teepro-elements'), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>'),
				),
				array(
					'type' => 'textfield',
					'heading' => __('Extra class name', 'teepro-elements'),
					'param_name' => 'class',
					'description' => __('Style particular content element differently - add a class name and refer to it in custom CSS.', 'teepro-elements'),
					'save_always' => true,
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Thumbnail size', 'teepro-elements'),
					'param_name' => 'thumb',
					'group' => __('Content Options', 'teepro-elements'),
					'value' => array(
						'1:1' => '1-1',
						'4:3' => '4-3',
						'3:4' => '3-4',
						'16:9' => '16-9',
						'9:16' => '9-16',
						'Custom' => 'custom',
					),
					'std' => '4-3',
					'save_always' => true,
					'dependency' => array(
						'element' => 'layout',
						'value_not_equal_to' => 'wp-list',
					),
				),
				array(
					'type' => 'textfield',
					'heading' => __('Thumb Width', 'teepro-elements'),
					'param_name' => 'thumb_w',
					'group' => __('Content Options', 'teepro-elements'),
					'value' => '100',
					'save_always' => true,
					'dependency' => array(
						'element' => 'thumb',
						'value' => array('custom'),
					),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					'type' => 'textfield',
					'heading' => __('Thumb Height', 'teepro-elements'),
					'param_name' => 'thumb_h',
					'group' => __('Content Options', 'teepro-elements'),
					'value' => '100',
					'save_always' => true,
					'dependency' => array(
						'element' => 'thumb',
						'value' => array('custom'),
					),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Title tag', 'teepro-elements'),
					'param_name' => 'title_tag',
					'group' => __('Content Options', 'teepro-elements'),
					'value' => array(
						'H1' => 'h1',
						'H2' => 'h2',
						'H3' => 'h3',
						'H4' => 'h4',
						'H5' => 'h5',
						'H6' => 'h6',
						'Div' => 'div',
					),
					'std' => 'h4',
					'save_always' => true,
				),
				array(
					'type' => 'checkbox',
					'heading' => __('Title link', 'teepro-elements'),
					'param_name' => 'title_lnk',
					'group' => __('Content Options', 'teepro-elements'),
					'value' => array(__('Yes', 'teepro-elements') => 'true'),
					'save_always' => true,
				),
				array(
					'type' => 'textfield',
					'heading' => __('Title character limit of post', 'teepro-elements'),
					'param_name' => 'title_limit',
					'group' => __('Content Options', 'teepro-elements'),
					'value' => '5',
					'save_always' => true,
				),
				array(
					'type' => 'checkbox',
					'heading' => __('Categories', 'teepro-elements'),
					'param_name' => 'categories',
					'group' => __('Content Options', 'teepro-elements'),
					'value' => array(__('Show', 'teepro-elements') => 'true'),
					'save_always' => true,
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					'type' => 'checkbox',
					'heading' => __('Tags', 'teepro-elements'),
					'param_name' => 'tags',
					'group' => __('Content Options', 'teepro-elements'),
					'value' => array(__('Show', 'teepro-elements') => 'true'),
					'save_always' => true,
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					'type' => 'checkbox',
					'heading' => __('Author', 'teepro-elements'),
					'param_name' => 'author',
					'group' => __('Content Options', 'teepro-elements'),
					'value' => array(__('Show', 'teepro-elements') => 'true'),
					'save_always' => true,
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					'type' => 'checkbox',
					'heading' => __('Comments count', 'teepro-elements'),
					'param_name' => 'comments',
					'group' => __('Content Options', 'teepro-elements'),
					'value' => array(__('Show', 'teepro-elements') => 'true'),
					'save_always' => true,
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					'type' => 'checkbox',
					'heading' => __('Date', 'teepro-elements'),
					'param_name' => 'datetime',
					'group' => __('Content Options', 'teepro-elements'),
					'value' => array(__('Show', 'teepro-elements') => 'true'),
					'save_always' => true,
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					'type' => 'checkbox',
					'heading' => __('Display DateTime as "Time Ago"', 'teepro-elements'),
					'param_name' => 'timeago',
					'group' => __('Content Options', 'teepro-elements'),
					'value' => array(__('Yes', 'teepro-elements') => 'true'),
					'save_always' => true,
					'dependency' => array(
						'element' => 'layout',
						'value_not_equal_to' => array('wp-blog2'),
					),
					'edit_field_class' => 'vc_col-sm-6',
				),
				array(
					'type' => 'textfield',
					'heading' => __('Content character limit of post', 'teepro-elements'),
					'param_name' => 'limit',
					'group' => __('Content Options', 'teepro-elements'),
					'value' => '15',
					'save_always' => true,
				),
				array(
					'type' => 'checkbox',
					'heading' => __('Readmore link', 'teepro-elements'),
					'param_name' => 'readmore',
					'group' => __('Content Options', 'teepro-elements'),
					'value' => array(__('Show', 'teepro-elements') => 'true'),
					'save_always' => true,
				),
				array(
					'type' => 'textfield',
					'heading' => __('Readmore text', 'teepro-elements'),
					'param_name' => 'readmoretxt',
					'group' => __('Content Options', 'teepro-elements'),
					'value' => 'Read more',
					'save_always' => true,
					'dependency' => array(
						'element' => 'readmore',
						'value' => array('true'),
					),
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Gap', 'teepro-elements'),
					'param_name' => 'gap',
					'group' => __('Slide Options', 'teepro-elements'),
					'description' => __('Select gap between slide elements.', 'teepro-elements'),
					'value' => array(
						'0px' => '0',
						'1px' => '1',
						'2px' => '2',
						'3px' => '3',
						'4px' => '4',
						'5px' => '5',
						'10px' => '10',
						'15px' => '15',
						'20px' => '20',
						'25px' => '25',
						'30px' => '30',
						'35px' => '35',
					),
					'std' => '30',
					'save_always' => true,
					'dependency' => array(
						'element' => 'style',
						'value' => array('wppostslider'),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => __('Navigation', 'teepro-elements'),
					'param_name' => 'nav',
					'group' => __('Slide Options', 'teepro-elements'),
					'description' => __('Show next/prev buttons.', 'teepro-elements'),
					'value' => array(__('Show', 'teepro-elements') => 'true'),
					'std' => 'true',
					'save_always' => true,
					'dependency' => array(
						'element' => 'style',
						'value' => array('wppostslider'),
					),
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Navigation Layout', 'teepro-elements'),
					'param_name' => 'nav_layout',
					'group' => __('Slide Options', 'teepro-elements'),
					'value' => array(
						'Style 1' => 'style1',
						'Style 2' => 'style2',
						
					),
					'std' => 'style1',
					'save_always' => true,
					'dependency' => array(
						'element' => 'nav',
						'value' => array('true'),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => __('Dots', 'teepro-elements'),
					'param_name' => 'dots',
					'group' => __('Slide Options', 'teepro-elements'),
					'description' => __('Show dots navigation.', 'teepro-elements'),
					'value' => array(__('Show', 'teepro-elements') => 'true'),
					'save_always' => true,
					'dependency' => array(
						'element' => 'style',
						'value' => array('wppostslider'),
					),
				),
				array(
					'type' => 'dropdown',
					'heading' => __('Navigation Layout', 'teepro-elements'),
					'param_name' => 'dots_layout',
					'group' => __('Slide Options', 'teepro-elements'),
					'value' => array(
						'Circle' => 'circle',
						'Square' => 'square',
					
					),
					'std' => 'circle',
					'save_always' => true,
					'dependency' => array(
						'element' => 'dots',
						'value' => array('true'),
					),
				),
				array(
					'type' => 'checkbox',
					'heading' => __('Autoplay', 'teepro-elements'),
					'param_name' => 'autoplay',
					'group' => __('Slide Options', 'teepro-elements'),
					'description' => __('Autoplay.', 'teepro-elements'),
					'save_always' => true,
					'value' => array(__('Yes', 'teepro-elements') => 'true'),
					'std' => 'true',
					'dependency' => array(
						'element' => 'style',
						'value' => array('wppostslider'),
					),
				),
				array(
					'type' => 'css_editor',
					'heading' => __('CSS box', 'teepro-elements'),
					'param_name' => 'css',
					'group' => __('Design Options', 'teepro-elements'),
					'save_always' => true,
				),
			)
		));

	   
	}
	// public function getCategoryChilds($parent_id, $pos, $array, $level, &$dropdown) {
	// 	for ($i = $pos; $i < count($array); $i ++) {
	// 		if ($array[$i]->category_parent == $parent_id) {
	// 			$data = array(
	// 				str_repeat('- ', $level) . $array[$i]->name => $array[$i]->slug,
	// 			);
	// 			$dropdown = array_merge($dropdown, $data);
	// 			$this->getCategoryChilds($array[$i]->term_id, $i, $array, $level + 1, $dropdown);
	// 		}
	// 	}
	// }

	// protected function getCategoryChildsFull($parent_id, $pos, $array, $level, &$dropdown) {
	// 	for ($i = $pos; $i < count($array); $i ++) {
	// 		if ($array[$i]->category_parent == $parent_id) {
	// 			$name = str_repeat('- ', $level) . $array[$i]->name;
	// 			$value = $array[$i]->slug;
	// 			$dropdown[] = array(
	// 				'label' => $name,
	// 				'value' => $value,
	// 			);
	// 			$this->getCategoryChildsFull($array[$i]->term_id, $i, $array, $level + 1, $dropdown);
	// 		}
	// 	}
	// }

	function getCategories() {
		$terms = get_terms('category', 'orderby=name&hide_empty=0');
		if ($terms) {
			foreach ($terms as $key => $term) {
				$dropdown[] = array(
					'label' => $term->name,
					'value' => $term->slug,
				);
			}
		}
		return $dropdown;
	}

	private static function post_loop($query_args, $atts, $style) {
		if ($atts['layout'] == 'wp-list'):
			$columns_xl = $columns_lg = $columns_md = $columns_sm = 1;
		else:
			$columns_xl = (isset($atts['columns-xl']) && $atts['columns-xl']) ? absint($atts['columns-xl']) : 4;
			$columns_lg = (isset($atts['columns-lg']) && $atts['columns-lg']) ? absint($atts['columns-lg']) : $columns_xl;
			$columns_md = (isset($atts['columns-md']) && $atts['columns-md']) ? absint($atts['columns-md']) : $columns_lg;
			$columns_sm = (isset($atts['columns-sm']) && $atts['columns-sm']) ? absint($atts['columns-sm']) : $columns_md;
		endif;
		$rows = (isset($atts['rows']) && absint($atts['rows'])) ? absint($atts['rows']) : 1;

		$nbposts = new WP_Query(apply_filters('widget_posts_args', $query_args));

		ob_start();

		if ($nbposts->have_posts()):
			if (isset($atts['nav']) && $atts['nav']):
				vc_icon_element_fonts_enqueue('entypo');
			endif;
			$postoptions = ' data-cols-xl=' . $columns_xl
					. ' data-cols-lg=' . $columns_lg
					. ' data-cols-md=' . $columns_md
					. ' data-cols-sm=' . $columns_sm
					. ' data-byRow=' . ($rows > 1 ? '0' : '1');
			if ($atts['style'] == 'wppostslider'):
				$postoptions .= ' data-slide=swipper-slider'
						. ' data-margin=' . ($atts['gap'] ? absint($atts['gap']) : 30)
						. ' data-nav=' . ($atts['nav'] ? $atts['nav'] : 'false')
						. ((isset($atts['nav_layout']) && $atts['nav_layout']) ? ' data-navlayout=' . $atts['nav_layout'] : '')
						. ' data-dots=' . ($atts['dots'] ? $atts['dots'] : 'false')
						. ((isset($atts['dots_layout']) && $atts['dots_layout']) ? ' data-dotslayout=' . $atts['dots_layout'] : '')
						. ' data-autoplay=' . ((isset($atts['autoplay']) && $atts['autoplay']) ? $atts['autoplay'] : 'false');
			elseif ($atts['style'] == 'wppostmasonry'):
				$postoptions .= ' data-layout=isotope'
						. ' data-layout_mode=mansory';
				if ($atts['show_filter']):
					?>
					<div class="filters-group filters-button-group">
						<?php echo '<a class="filter-btn is-checked" data-filter="*"><span>' . __('All', 'teepro-elements') . '</span></a>'; ?>
						<?php
						if (isset($atts['category'])):
							$catsfilter = explode(', ', $atts['category']);
							foreach ($catsfilter as $cat) :
								$term = get_term_by('slug', $cat, 'category');
								$name = $term->name;
								echo '<a class="filter-btn" data-filter=".' . $cat . '"><span>' . $name . '</span></a>';
							endforeach;
						else:
							$catsfilter = get_categories();
							foreach ($catsfilter as $cat) :
								echo '<a class="filter-btn" data-filter=".' . $cat->slug . '"><span>' . $cat->name . '</span></a>';
							endforeach;
						endif;
						?>
					</div>
					<?php
				endif;
			endif;
			?>
			<?php if ($atts['style'] == 'wppostslider'): ?>
				<div class="nb_swipper_slider">
				<?php endif; ?>
				<div class="wp-posts <?php echo ($atts['style'] == 'wppostslider' ? 'swiper-container ' : ('columns-' . $columns_lg)); echo($atts['layout'] ? ' '.$atts['layout'] : 'default')?>"<?php echo esc_attr($postoptions); echo($atts['layout'] ?(' data-layout="'.$atts['layout'].'"') : 'default') ?>>
				<?php if($atts['style'] == 'wppostslider'): ?>
				<div class="swiper-wrapper">
				<?php endif; ?>
					<?php $i = 1; ?>
					<?php
					while ($nbposts->have_posts()) :
						$nbposts->the_post();
						echo (($i == 1 && $atts['style'] == 'wppostslider') ? '<div class="swiper-slide">' : '');
						$featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
						$categories = get_the_category();
						$filtercls = '';
						if ($categories):
							foreach ($categories as $cat):
								$filtercls .= ' ' . $cat->slug;
							endforeach;
						endif;
						?>
						<div class="nb_wp_post nb_<?php echo ($atts['layout'] . ($atts['style'] == 'wppostmasonry' ? (' nb-isotope-item isotope-item' . $filtercls) : '')); ?>">
							<div class="nb_wp_post-i">
								<?php
								if ($atts['layout'] != 'wp-list' && $featured_img_url):
									$thumbsize = '';
									if ($atts['thumb'] == 'custom'):
										$thumbsize = 'width:' . ($atts['thumb_w'] ? $atts['thumb_w'] : '100') . 'px;'
												. 'height:' . ($atts['thumb_h'] ? $atts['thumb_h'] : '100') . 'px;';
									endif;
									?>
									<div class="nb-post-thumb thumb_<?php echo ($atts['thumb']); ?>">
										<div class="nb-post-thumb-i">
											<a href="<?php the_permalink(); ?>" style="background-image:url(<?php echo $featured_img_url; ?>);<?php echo ($thumbsize); ?>"></a>
										</div>
									</div>			

								<?php endif; ?>
								<?php if ($atts['layout'] == 'wp-img-top' && $atts['datetime']): ?>

								<div class="nb-post-date">
										<div class="nb-post-date-i">
											<span class="vc_post_date-day"><?php echo date_i18n('j', strtotime(get_the_date(''))); ?></span>
											<span class="vc_post_date-month"><?php echo date_i18n('M', strtotime(get_the_date(''))); ?></span>
										</div>
									</div>

								<?php endif; ?>

								<?php if ($atts['layout'] == 'wp-blog2' && $atts['datetime']): ?>
									<div class="nb-post-date">
										<div class="nb-post-date-i">
											<span class="vc_post_date-day"><?php echo date_i18n('d', strtotime(get_the_date(''))); ?></span>
											<span class="vc_post_date-month"><?php echo date_i18n('F', strtotime(get_the_date(''))); ?></span>
										</div>
									</div>
								<?php endif; ?>
								<?php if ($atts['layout'] != 'wp-blog1'): ?>
									<div class="nb-post-block">
									<?php endif; ?>
									<div class="nb-post-header">
										<?php
										if ($atts['categories']):
											if (($atts['layout'] != 'wp-img-left')):
											$cats = get_the_category_list(esc_html__(', ', 'teepro-elements'));
											echo $cats ? ('<div class="nb-post-cats">' . $cats . '</div>') : '';
											endif;
											if (($atts['layout'] == 'wp-img-left')):
												$cats = get_the_category_list(esc_html__(', ', 'teepro-elements'));
												echo $cats ? ('<div class="nb-post-cats">Category : ' . $cats . '</div>') : '';
												endif;
										endif;
										?>
										<?php if ($atts['author'] || ($atts['layout'] != 'wp-blog2' && $atts['datetime']) || $atts['comments']): ?>
											<div class="nb-post-meta">

												<?php if (($atts['layout'] != 'wp-img-left')):?>
													<?php if ($atts['author']): ?>
													<span class="nb-post-author"><?php the_author(); ?></span>
													<?php endif; ?>
												<?php endif; ?>

												<?php if (($atts['layout'] == 'wp-img-left')):?>
													 <?php if ($atts['author']): ?>
													<span class="nb-post-author">By : <?php the_author(); ?>
													<?php endif; ?>

													<?php if ( $atts['author']): ?>
													 	<?php if ( $atts['datetime']): ?>
													   		- <?php echo date_i18n('d', strtotime(get_the_date(''))); ?> <?php echo date_i18n('F', strtotime(get_the_date(''))); ?>,<?php echo date_i18n('y', strtotime(get_the_date(''))); ?>
														<?php endif; ?>
													<?php endif; ?>
													
													<?php if (!$atts['author']): ?>
														<?php if ( $atts['datetime']): ?>
														<span class="nb-post-datetime"><?php echo date_i18n('d', strtotime(get_the_date(''))); ?>,<?php echo date_i18n('F', strtotime(get_the_date(''))); ?>
														</span>
														<?php endif; ?>
													<?php endif; ?>

													<?php if ($atts['author']): ?>
													</span>
													<?php endif; ?>
												<?php endif; ?>


												<?php if (($atts['layout'] != 'wp-blog2' &&  $atts['datetime']) &&  ($atts['layout'] != 'wp-img-top' && $atts['datetime']) &&($atts['layout'] != 'wp-img-left' &&  $atts['datetime'])): ?>
													<span class="nb-post-datetime"><?php echo $atts['timeago'] ? human_time_diff(strtotime(get_the_date()), current_time('timestamp')) : get_the_date(); ?></span>
												<?php endif; ?>
												
												<?php
												if ($atts['comments']):
													$num_comments = get_comments_number(); // get_comments_number returns only a numeric value
													if (comments_open()) {
														if ($num_comments > 1) {
															$comments = $num_comments . __(' Comments');
														} else {
															$comments = $num_comments . __(' Comment');
														}
														$write_comments = '<a class="nb-post-comments" href="' . get_comments_link() . '">' . $comments . '</a>';
													} else {
														$write_comments = '<span class="nb-post-comments">' . __('Comments are off for this post.') . '</span>';
													}
													echo $write_comments;
												endif;
												?>
												<?php if ($atts['layout'] == 'wp-img-top' && $atts['tags']): 
													$tags = get_the_tag_list('', esc_html__(', ', 'teepro-elements'));
													echo $tags ? ('<div class="nb-post-tags">' . $tags . '</div>') : '';
											 	endif; ?>


											</div>
										<?php endif; ?>
										<<?php echo ($atts['title_tag'] ? $atts['title_tag'] : 'h4'); ?> class="nb-title-post">
										<?php if ($atts['title_lnk']): ?>
											<a href="<?php the_permalink(); ?>">
												<?php
												if (get_the_title()):
													echo (absint($atts['title_limit']) > 0 ? wp_trim_words(get_the_title(), $atts['title_limit'], '...') : get_the_title());
												else :
													echo get_the_ID();
												endif;
												?>
											</a>
										<?php else: ?>
											<?php
											if (get_the_title()):
												echo (absint($atts['title_limit']) > 0 ? wp_trim_words(get_the_title(), $atts['title_limit'], '...') : get_the_title());
											else :
												echo get_the_ID();
											endif;
											?>
										<?php endif; ?>
										</<?php echo ($atts['title_tag'] ? $atts['title_tag'] : 'h4'); ?>>
									</div>
									<?php if ($atts['readmore'] || $atts['limit']): ?>
										<div class="nb-post-content">
										<?php endif; ?>
										<?php if ($atts['limit'] == '' || absint($atts['limit']) > 0): ?>
											<?php
											if (has_excerpt()) :
												echo '<p>' . (absint($atts['limit']) > 0 ? wp_trim_words(get_the_excerpt(), $atts['limit'], '...') : get_the_excerpt()) . '</p>';
											else :
												echo '<p>' . (absint($atts['limit']) > 0 ? wp_trim_words(get_the_content(), $atts['limit'], '...') : get_the_content()) . '</p>';
											endif;
											?>
										<?php endif; ?>
											<?php if ($atts['readmore']): ?>
												<div class="nb-post-readmore">
													<a class="readmore" href="<?php the_permalink(); ?>"><?php echo ($atts['readmoretxt'] ? $atts['readmoretxt'] : esc_html__('Read more', 'teepro-elements')); ?></a>
												</div>
											<?php endif; ?>
										<?php if ($atts['readmore'] || $atts['limit']): ?>
										</div>
										<?php endif; ?>
									
									
										<?php
										if ($atts['layout'] != 'wp-img-top'):
											if ($atts['tags']):
											$tags = get_the_tag_list('', esc_html__(', ', 'teepro-elements'));
											echo $tags ? ('<div class="nb-post-tags">' . $tags . '</div>') : '';
											endif;
										endif;
									?>
									
									<?php if ($atts['layout'] != 'wp-blog1'): ?>
									</div>
								<?php endif; ?>								
							</div>
						</div>
						<?php
						if ($atts['style'] == 'wppostslider'):
							if ($i == $rows):
								echo '</div>';
								$i = 1;
							else:
								$i++;
							endif;
						endif;

					endwhile; // end of the loop. 
					?>

				
				<?php if($atts['style'] == 'wppostslider'): ?>
					</div>
				<?php endif; ?>
				<?php if($atts['style'] == 'wppostslider'): ?>
				<?php if(!isset($atts['nav_layout']) ||  $atts['nav_layout'] != 'style1'): ?>
						<?php if($atts['dots']): ?>
							<div class="swiper-pagination <?php echo ($atts['layout'] ? ('pagination_'.$atts['layout']) : 'default')?> <?php echo($atts['dots_layout']?$atts['dots_layout']:'') ?>"></div>
						<?php endif; ?>
				
						<?php if($atts['nav']): ?>
							<div class="swiper-button-next <?php echo ($atts['layout'] ? ('next_'.$atts['layout']) : 'default')?> <?php echo($atts['nav_layout']?$atts['nav_layout']:'') ?> "></div>
							<div class="swiper-button-prev <?php echo ($atts['layout'] ? ('prev_'.$atts['layout']) : 'default')?> <?php echo($atts['nav_layout']?$atts['nav_layout']:'') ?>"></div>
						<?php endif; ?>
					<?php endif; ?>
				<?php endif; ?>
		
				</div>

				<?php if($atts['style'] == 'wppostslider' && isset($atts['nav_layout']) && $atts['nav_layout'] == 'style1'): ?>

					<?php if($atts['dots']): ?>
						<div class="swiper-pagination <?php echo ($atts['layout'] ? ('pagination_'.$atts['layout']) : 'default')?> <?php echo($atts['dots_layout']?$atts['dots_layout']:'') ?>"></div>
					<?php endif; ?>
					<?php if($atts['nav']): ?>
						<div class="swiper-button-next <?php echo ($atts['layout'] ? ('next_'.$atts['layout']) : 'default')?> <?php echo($atts['nav_layout']?$atts['nav_layout']:'') ?> "></div>
    					<div class="swiper-button-prev <?php echo ($atts['layout'] ? ('prev_'.$atts['layout']) : 'default')?> <?php echo($atts['nav_layout']?$atts['nav_layout']:'') ?>"></div>
					<?php endif; ?>
				<?php endif; ?>
				
				<?php if ($atts['style'] == 'wppostslider'): ?>
				</div>
				<?php
			endif;
		endif;
		wp_reset_query();

		return ob_get_clean();
	}

	public function nb_posts_render($atts) {
		extract(shortcode_atts(
						array(
			'style' => '',
			//'equal_height' => '',
			'layout' => '',
			'per_page' => '',
			'columns-xl' => '',
			'columns-lg' => '',
			'columns-md' => '',
			'columns-xs' => '',
			'rows' => '',
			'filter' => '',
			'show_filter' => '',
			'category' => '',
			// 'cats' => '',
			'orderby' => '',
			'order' => '',
			'gap' => '',
			'nav' => '',
			'nav_layout' => '',
			'dots' => '',
			'dots_layout' => '',
			'autoplay' => '',
			'class' => '',
			'css' => '',
			'thumb' => '',
			'thumb_w' => '',
			'thumb_h' => '',
			'title_tag' => '',
			'title_lnk' => '',
			'title_limit' => '',
			'categories' => '',
			'tags' => '',
			'author' => '',
			'datetime' => '',
			'timeago' => '',
			'comments' => '',
			'limit' => '15',
			'readmore' => '',
			'readmoretxt' => '',
						), $atts, 'nb_wpposts'
		));

		// echo '<pre>';
		// print_r($filter);
		// echo '</pre>';
		// die;

		$tax_query = array(
			array(
				'field' => 'slug',
				'terms' => (($atts['filter'] && isset($atts['category'])) ? $atts['category'] : ''),
			),
		);
		$query_args = array(
			'post_type' => 'post',
			'post_status' => 'publish',
			'posts_per_page' => $atts['per_page'],
			'category_name' => (($atts['filter'] && isset($atts['category'])) ? $atts['category'] : ''),
			'orderby' => $atts['orderby'],
			'order' => $atts['order'],
		);

		$latest_posts = self::post_loop($query_args, $atts, $atts['style']);
		$output = '';
		if ($latest_posts):
			$css_class = 'wpb_content_element nb_wpposts_' . ($atts['style'] ? $atts['style'] : 'default') . ' nb_layout_' . ($atts['layout'] ? $atts['layout'] : 'default');
			$css_class = implode(' ', array($css_class, $class));
			$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $css_class . vc_shortcode_custom_css_class($css, ' '), 'nb_wpposts', $atts);
			$css_class = trim(preg_replace('/\s+/', ' ', $css_class));
			$output = '<div class="' . esc_attr($css_class) . '" >'
					. $latest_posts
					. '</div>';
		endif;

		return $output;
	}
}


new NB_Element_Blog(); 
}

