<?php
/*
Plugin Name: Teepro Elements
Plugin URI: http://netbaseteam.com/
Description: Prodive all visual composer elements and widgets.
Version: 1.1.4
Author: NBTeam
Author URI: http://themeforest.net/user/netbaseteam
Text Domain: teepro-elements
*/

define('TP_ELEMENTS_PATH', plugin_dir_path(__FILE__));
define('TP_ELEMENTS_NAME', plugin_basename(__FILE__));
define('TP_ELEMENTS_URL', plugin_dir_url( __FILE__ ));

class Netbase_Elements
{
    public static function init()
    {
        self::include_function_plugins();
        self::load_widget();
        add_action('vc_before_init', array(__CLASS__, 'load_vc_elements'));
        add_action('init',array(__CLASS__,'load_post_type'));
        add_action( 'plugins_loaded', array( __CLASS__, 'localization_setup' ) );
        add_action('wp_enqueue_scripts', array(__CLASS__, 'nb_elements_enqueue_scripts'));
        add_filter('vc_google_fonts_get_fonts_filter', array(__CLASS__, 'nb_helper_vc_fonts'));
    }

    /**
     * Initialize plugin for localization
     *
     * @uses load_plugin_textdomain()
     */
    public static function localization_setup() {
        load_plugin_textdomain( 'teepro-elements', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
    }

    public static function nb_elements_enqueue_scripts() {

        
        wp_enqueue_style( 'nb_elements', TP_ELEMENTS_URL . 'assets/css/main.css', array(), '20180324' );
        wp_enqueue_script( 'nb_elements', TP_ELEMENTS_URL . 'assets/js/main.js', array( 'jquery' ), '20180324', true );

        if(is_rtl()){
            wp_enqueue_style( 'nb_elements_rtl', TP_ELEMENTS_URL . 'assets/rtl.css', array(), '20180324' );
        }
        
        wp_enqueue_style( 'swiper', TP_ELEMENTS_URL . 'assets/vendors/swiper/swiper.min.css', array(), '4.5.0');
        wp_enqueue_script( 'swiper',  TP_ELEMENTS_URL . 'assets/vendors/swiper/swiper.min.js', array('jquery'), '4.5.0', true);
        
        wp_enqueue_script( 'nb_equal_height', TP_ELEMENTS_URL . 'assets/vendors/jquery-match-height/jquery.matchHeight-min.js', array(), '0.7.2', true );
        wp_enqueue_script( 'nb_imageload', TP_ELEMENTS_URL . 'assets/vendors/imagesloaded/imagesloaded.pkgd.min.js', array(), '4.1.4', true );
        wp_enqueue_script( 'nb_isotope', TP_ELEMENTS_URL . 'assets/vendors/isotope/isotope.pkgd.min.js', array(), '3.0.6', true );

        wp_enqueue_style( 'magnific-popup', TP_ELEMENTS_URL . 'assets/vendors/magnific-popup/magnific-popup.css', array(), '1.1.0' );
        wp_enqueue_script( 'magnific-popup', TP_ELEMENTS_URL . 'assets/vendors/magnific-popup/jquery-magnific-popup.min.js', array('jquery'), '1.1.0', true );
        
        

    }

    public static function nb_helper_vc_fonts( $fonts_list ) {
        $poppins->font_family = 'Poppins';
        $poppins->font_types = '300 light regular:300:normal,400 regular:400:normal,500 bold regular:500:normal,600 bold regular:600:normal,700 bold regular:700:normal';
        $poppins->font_styles = 'regular';
        $poppins->font_family_description = esc_html_e( 'Select font family', 'teepro-elements' );
        $poppins->font_style_description = esc_html_e( 'Select font styling', 'teepro-elements' );
        $fonts_list[] = $poppins;

        return $fonts_list;
    }



    public static function include_function_plugins() {

        if ( ! function_exists( 'is_plugin_active' ) ) {
            require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        }
    }

    public static function load_vc_elements() {
        
        require_once( TP_ELEMENTS_PATH . 'vc_elements/testimonials.php' );  
        require_once( TP_ELEMENTS_PATH . 'vc_elements/vc-instagram.php' );  
        require_once( TP_ELEMENTS_PATH . 'vc_elements/our-customers.php' );
        require_once( TP_ELEMENTS_PATH . 'vc_elements/banner-images.php' );
        require_once( TP_ELEMENTS_PATH . 'vc_elements/blog.php' );
        require_once( TP_ELEMENTS_PATH . 'vc_elements/vc-step.php' );
        require_once( TP_ELEMENTS_PATH . 'vc_elements/product-tabs.php' );
        require_once( TP_ELEMENTS_PATH . 'vc_elements/services-tab.php' );
        require_once( TP_ELEMENTS_PATH . 'vc_elements/image-slider.php' );
        require_once( TP_ELEMENTS_PATH . 'vc_elements/video.php' );
    }

    public static function load_widget() {
        require_once( TP_ELEMENTS_PATH . 'widgets/social-links.php' );
        require_once( TP_ELEMENTS_PATH . 'widgets/instagram-widget.php' );
        require_once( TP_ELEMENTS_PATH . 'widgets/contact-info.php' );
        require_once( TP_ELEMENTS_PATH . 'widgets/recent-blog.php' );
        require_once( TP_ELEMENTS_PATH . 'widgets/related-products-widget.php' );
    }
    public static function load_post_type() {
            $label = array(
                'name' => 'Services', 
                'singular_name' => 'Service' 
            );
            $args = array(
                'labels' => $label,
                'description' => 'Post type creat new service', 
                'supports' => array(
                    'title',
                    'editor',
                    'excerpt',
                    'author',
                    'thumbnail',
                    'comments',
                    'trackbacks',
                    'revisions',
                    'custom-fields'
                ), 
                'taxonomies' => array(), 
                'hierarchical' => true, 
                'public' => true, 
                'show_ui' => true,
                'show_in_menu' => true,
                'show_in_nav_menus' => true,
                'show_in_admin_bar' => true,
                'menu_position' => 5,
                'menu_icon' => 'dashicons-hammer',
                'can_export' => true,
                'has_archive' => false,
                'exclude_from_search' => false,
                'publicly_queryable' => true,
                'capability_type' => 'page'
            );
            register_post_type( 'service', $args );
    }
   
}
Netbase_Elements::init();
