jQuery(document).ready(function ($) {

	"use strict";
	$(document).on('vc-full-width-row', function() {

		$(".teepro-our-customers").each(function() {

            var $this           = $(this),
                currentID       = $this.attr('id'),
                customerWrap    = $this.find( '.our-customers-wrap' ),
			    dataAutoPlay    = customerWrap.attr( 'data-autoplay' ),
			    dataCPerViewXl    = customerWrap.attr( 'data-customers-per-view-xl' ),
			    dataCPerViewLg    = customerWrap.attr( 'data-customers-per-view-lg' ),
			    dataCPerViewMd    = customerWrap.attr( 'data-customers-per-view-md' ),
			    dataCPerViewSm    = customerWrap.attr( 'data-customers-per-view-sm' ),
                dataCPerColumn  = customerWrap.attr( 'data-customers-per-column' ),
                currentSelector = '#' + currentID + ' .our-customer-images';

                var ourCustomerObj = {
                    slidesPerView: dataCPerViewXl  ,
                    slidesPerColumn: dataCPerColumn,
                    spaceBetween: 30,
                    pagination: {
                        el: '#' + currentID + ' .our-customers-pagination',
                        clickable: true,
                    },
                    navigation: {
                        nextEl: '#' + currentID + ' .swiper-button-next',
                        prevEl: '#' + currentID + ' .swiper-button-prev',
                    },
                    breakpoints: {
                        575: {
                            slidesPerView: 1,
                            spaceBetween: 10
                        },
                        767: {
                            slidesPerView: dataCPerViewSm,
                            spaceBetween: 20
                        },
                        991: {
                            slidesPerView: dataCPerViewMd,
                            spaceBetween: 20
                        },
                        1199: {
                            slidesPerView: dataCPerViewLg,
                        }
                    }
                }

                if(dataAutoPlay) {
                    ourCustomerObj.autoplay = {
                        delay: 5000,
                    }
                }
                
                var ourCustomerSwiper = new Swiper(currentSelector, ourCustomerObj);
		});
	});


});
