jQuery(document).ready(function ($) {

	"use strict";
	$(document).on('vc-full-width-row', function() {

		$(".teepro-image-slider").each(function() {

            var $this               = $(this),
                currentID           = $this.attr('id'),
                sliderWrap          = $this.find( '.image-slider-wrap' ),
			    dataAutoPlay        = sliderWrap.attr( 'data-autoplay' ),
			    dataLoop            = sliderWrap.attr( 'data-loop' ),
			    dataSliderPerViewXl = sliderWrap.attr( 'data-sliders-per-view-xl' ),
			    dataSliderStretch   = sliderWrap.attr( 'data-sliders-stretch' ),
                currentSelector     = '#' + currentID + ' .image-slider-block';

                var ourSliderObj = {
                    effect: 'coverflow',
                    grabCursor: true,
                    centeredSlides: true,
                    slidesPerView: dataSliderPerViewXl,
                    slideToClickedSlide: true,
                    coverflowEffect: {
                        rotate: 0,
                        stretch: dataSliderStretch,
                        depth: 350,
                        modifier: 1,
                        slideShadows : false,
                    },
                    freeMode:false,
                    freeModeSticky:true,
                    loop: dataLoop,
                    pagination: {
                        el: '#' + currentID + ' .image-slider-pagination',
                        clickable: true,
                    },
                    navigation: {
                        nextEl: '#' + currentID + ' .swiper-button-next',
                        prevEl: '#' + currentID + ' .swiper-button-prev',
                    },
                }

                if(dataAutoPlay) {
                    ourSliderObj.autoplay = {
                        delay: 5000,
                    }
                }
                
                var ourSliderSwiper = new Swiper(currentSelector, ourSliderObj);
		});
	});
});
