(function ($, window, document, undefined) {
    'use strict';
    $(function () {
        $(document).ready(function () {
            var $rtl = false;
            if ($('html').attr('dir') == 'rtl') {
                $rtl = true;
            }
            
			$('[data-slide="swipper-slider"]').each(function () {

				var $this           = $(this);
				var datalayout = $this.attr( 'data-layout' );

				//console.log(datalayout);

				if(datalayout=='wp-img-top'){
					var swiper = new Swiper('.swiper-container.wp-img-top',{
						slidesPerView: $(this).attr('data-cols-xl'),
						spaceBetween: parseInt($(this).attr('data-margin')),
						autoplay: $.parseJSON($(this).attr('data-autoplay')),
						pagination: {
						  el: '.pagination_wp-img-top',
						  clickable: true,
						},
						navigation:{
							nextEl: '.next_wp-img-top',
							prevEl: '.prev_wp-img-top',
						},
						breakpoints:{
                            1199:{
								slidesPerView: $(this).attr('data-cols-lg'),
      							spaceBetween: parseInt($(this).attr('data-margin')),
							},
							991:{
								slidesPerView: $(this).attr('data-cols-md'),
      							spaceBetween: 30,
							},
							767:{
								slidesPerView: $(this).attr('data-cols-sm'),
      							spaceBetween: 0,
							}
						}
					});
                }
                if(datalayout=='wp-img-left'){
					var swiper = new Swiper('.swiper-container.wp-img-left',{
						slidesPerView: $(this).attr('data-cols-xl'),
						spaceBetween: parseInt($(this).attr('data-margin')),
						autoplay: $.parseJSON($(this).attr('data-autoplay')),
						pagination: {
						  el: '.pagination_wp-img-left',
						  clickable: true,
						},
						navigation:{
							nextEl: '.next_wp-img-left',
							prevEl: '.prev_wp-img-left',
						},
						breakpoints:{
                            1199:{
								slidesPerView: $(this).attr('data-cols-lg'),
      							spaceBetween: 15,
							},

							991:{
								slidesPerView: $(this).attr('data-cols-md'),
      							spaceBetween: 15,
							},
							767:{
								slidesPerView: $(this).attr('data-cols-sm'),
      							spaceBetween: 0,
							}
						}
					});
                }
                if(datalayout=='wp-content-absolute'){
					var swiper = new Swiper('.swiper-container.wp-content-absolute',{
						slidesPerView: $(this).attr('data-cols-xl'),
						spaceBetween: parseInt($(this).attr('data-margin')),
						autoplay: $.parseJSON($(this).attr('data-autoplay')),
						pagination: {
						  el: '.pagination_wp-content-absolute',
						  clickable: true,
						},
						navigation:{
							nextEl: '.next_wp-content-absolute',
							prevEl: '.prev_wp-content-absolute',
						},
						breakpoints:{
                            1199:{
								slidesPerView: $(this).attr('data-cols-lg'),
      							spaceBetween: 15,
							},

							991:{
								slidesPerView: $(this).attr('data-cols-md'),
      							spaceBetween: 15,
							},
							767:{
								slidesPerView: $(this).attr('data-cols-sm'),
      							spaceBetween: 0,
							}
						}
					});
				}
				
			});
			

            if ($('[data-layout="isotope"]').length) {
                var $originLeft = true;
                if ($rtl) {
                    $originLeft = false;
                }
                $('[data-layout="isotope"]').each( function() {
                    var $isotope = $(this).imagesLoaded(function () {
                        $isotope.isotope({
                            itemSelector: '.isotope-item',
                            percentPosition: true,
                            layoutMode: 'masonry',
                            originLeft: $originLeft,
                        });
                    });
                    $(this).prev('.filters-button-group').on('click', '.filter-btn', function () {
                        var filterValue = $(this).attr('data-filter');
                        $isotope.isotope({filter: filterValue});
                        if(($(this).not('.is-checked'))){
                            $(this).parents('.filters-button-group').eq(0).find('.is-checked').removeClass('is-checked');
                            $(this).addClass('is-checked');
                        }
                    });
                });
            }
            
        });
    });

})(jQuery, window, document);