var gulp = require('gulp');
var sass = require('gulp-sass');
var autoprefixer = require('gulp-autoprefixer');
var rtlcss = require('gulp-rtlcss');
var rename = require('gulp-rename');
var plumber = require('gulp-plumber');
var cssnano = require('gulp-cssnano');
var gcmq = require('gulp-group-css-media-queries');
var jshint = require('gulp-jshint');
var uglify = require('gulp-uglify');
var concat = require('gulp-concat');
var sourcemaps = require('gulp-sourcemaps');
var browserSync = require('browser-sync').create();
var reload = browserSync.reload;
var imagemin = require('gulp-imagemin');
var zip = require('gulp-zip');
var del = require('del');

var onError = function (err) {
    console.log('An error occurred:',err.message);
    this.emit('end');
};

gulp.task('elementscss',function(){
    return gulp.src('./src/sass/frontend/**/*.scss')
        .pipe(plumber({ errorHandler: onError }))
        .pipe(sass())
        .pipe(concat('main.css'))
        .pipe(autoprefixer())
        .pipe(gcmq())
        .pipe(gulp.dest('./css'))

});

gulp.task('elementsjs',function(){
    return gulp.src('./src/js/frontend/**/*.js')
        .pipe(plumber({ errorHandler: onError }))
        .pipe(concat('main.js'))
        .pipe(gulp.dest('./js'))

});

gulp.task('watch', function() {
    gulp.watch('./src/sass/**/*.scss',gulp.parallel('elementscss'));
    gulp.watch('./src/js/**/*.js',gulp.parallel('elementsjs'));
});

gulp.task('cleanAssets', function() {
    return del([
        './css/**/*',
        './js/**/*'
    ]);
});

gulp.task('compileAssets', gulp.parallel('elementscss', 'elementsjs'));

gulp.task('build', gulp.series('cleanAssets', 'compileAssets'));
