<?php
function nbcore_share_social($show_title = false)
{
    $src            = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full');
    $style          = get_theme_mod('share_buttons_style');
    $position       = get_theme_mod('share_buttons_position');
    $facebook_title = $twitter_title = $pinterest_title = $g_plus_title = $linkedin_title = '';

    if($show_title) {
        $facebook_title     = '<span class="social_title"> ' . esc_html__('Facebook', 'nb-fw') . '</span>';
        $twitter_title      = '<span class="social_title"> ' . esc_html__('Twitter', 'nb-fw') . '</span>';
        $pinterest_title    = '<span class="social_title"> ' . esc_html__('Pinterest', 'nb-fw') . '</span>';
        $g_plus_title       = '<span class="social_title"> ' . esc_html__('Google+', 'nb-fw') . '</span>';
        $linkedin_title     = '<span class="social_title"> ' . esc_html__('LinkedIn', 'nb-fw') . '</span>';
    }
?>
    <div class="nb-social-icons <?php echo $style . ' ' . $position; ?>">

        <a href="//www.facebook.com/sharer.php?u=<?php esc_url(the_permalink()); ?>" data-label="Facebook" onclick="window.open(this.href,this.title,'width=500,height=500,top=300px,left=300px');  return false;" rel="nofollow" target="_blank" class="facebook" title="<?php esc_attr_e('Share on Facebook', 'nb-fw'); ?>">
            <i class="nb-fw-icon-facebook"></i> <?php echo $facebook_title;?>
        </a>

        <a href="//twitter.com/share?url=<?php esc_url(the_permalink()); ?>" onclick="window.open(this.href,this.title,'width=500,height=500,top=300px,left=300px');  return false;" rel="nofollow" target="_blank" class="twitter" title="<?php esc_attr_e('Share on Twitter', 'nb-fw'); ?>">
        <i class="nb-fw-icon-twitter"></i> <?php echo $twitter_title;?>
        </a>

        <a href="//pinterest.com/pin/create/button/?url=<?php esc_url(the_permalink()); ?>&amp;media=<?php echo esc_attr($src[0]); ?>&amp;description=<?php the_title(); ?>" onclick="window.open(this.href,this.title,'width=500,height=500,top=300px,left=300px');  return false;" rel="nofollow" target="_blank" class="pinterest" title="<?php esc_attr_e('Pin on Pinterest', 'nb-fw'); ?>">
            <i class="nb-fw-icon-pinterest"></i> <?php echo $pinterest_title;?>
        </a>

        <a href="//plus.google.com/share?url=<?php esc_url(the_permalink()); ?>" target="_blank" class="google-plus" onclick="window.open(this.href,this.title,'width=500,height=500,top=300px,left=300px');  return false;" rel="nofollow" title="<?php esc_attr_e('Share on Google+', 'nb-fw'); ?>">
            <i class="nb-fw-icon-gplus"></i> <?php echo $g_plus_title;?>
        </a>

        <a href="//www.linkedin.com/shareArticle?mini=true&url=<?php esc_url(the_permalink()); ?>&title=<?php the_title(); ?>" onclick="window.open(this.href,this.title,'width=500,height=500,top=300px,left=300px');  return false;" rel="nofollow" target="_blank" class="linkedin" title="<?php esc_attr_e('Share on LinkedIn', 'nb-fw'); ?>">
            <i class="nb-fw-icon-linkedin"></i> <?php echo $linkedin_title;?>
        </a>

    </div>
<?php
}