<?php
/**
 * Plugin Name: WP booking pro – Booking FrontEnd Manager for Store Manager and WooCommerce Vendor
 * Plugin URL: http://demo9.cmsmart.net/demo-woobooking/sellercenter/
 * Description: WP booking pro.
 * Version: 1.0.0
 * Author: NetBase Team
 * Author URI: http://netbaseteam.com
 * Text Domain: wpbookingpro
 */
if (!defined("WPBOOKINGPRO_ROOT_PATH_PLUGIN"))
{
    define("WPBOOKINGPRO_ROOT_PATH_PLUGIN", __DIR__);
}
if (!defined("WPBOOKINGPRO_MINIMUM_ELEMENTOR_VERSION"))
{
    define("WPBOOKINGPRO_MINIMUM_ELEMENTOR_VERSION", "2.0.0");
}
if (!defined("WPBOOKINGPRO_MINIMUM_PHP_VERSION"))
{
    define("WPBOOKINGPRO_MINIMUM_PHP_VERSION", "7.0");
}
if (!defined("DS"))
    define("DS", DIRECTORY_SEPARATOR);
if (!defined("_WPBOOKINGPRO_EXEC")){
    define('_WPBOOKINGPRO_EXEC', 1);
}
if (!defined("WPBOOKINGPRO_PATH_ROOT")) {
    define('WPBOOKINGPRO_PATH_ROOT', __DIR__);
}
if (!defined("WPBOOKINGPRO_ROOT_PATH_SITE")) {
    define('WPBOOKINGPRO_ROOT_PATH_SITE', ABSPATH);
}

if (!defined("WPBOOKING_PRO_DEBUG")) {
    define('WPBOOKING_PRO_DEBUG', 0);
}
if (!defined("WPBOOKINGPRO_PLUGIN_NAME")) {
    define('WPBOOKINGPRO_PLUGIN_NAME', pathinfo(__DIR__, PATHINFO_FILENAME));
}
if (!defined("WPBOOKINGPRO_PATH_ADMIN_COMPONENT1")) {
    define('WPBOOKINGPRO_PATH_ADMIN_COMPONENT1', WPBOOKINGPRO_ROOT_PATH_PLUGIN . DIRECTORY_SEPARATOR . 'admin/nb_apps/nb_woobooking');
}
if (!defined("WPBOOKINGPRO_PREFIX_TABLE")) {
    define('WPBOOKINGPRO_PREFIX_TABLE', "woobooking_");
}

use WooBooking\CMS\OpenSource\WordPress\WooBookingOnWordpress;
if(!class_exists('wpbookingpro')) {
    class wpbookingpro
    {
        public static $version = "1.0";
        public static $items_submenus = array();
        public static $namespace = "woobooking_api/1.0";
        public $view = "";
        public static $prefix_link = "wb_";

        public  function wooBooking_Wordpress_session_start(){


        }
        public function __construct()
        {

            //$is_woopanel=is_woopanel();
            require_once WPBOOKINGPRO_PATH_ROOT . '/lib/vendor/autoload.php';
            if(!session_id()) {
                session_start();
            }
            $list_environment = [
                get_site_url() . "/",
            ];
            WooBookingOnWordpress::set_environments($list_environment);

            $request_uri = $_SERVER['REQUEST_URI'];
            $this->view = self::get_current_page();


            if (strpos($request_uri, "api_task_frontend") !== false || strpos($request_uri, "wp-booking-pro") !== false) {
                require_once WPBOOKINGPRO_PATH_ROOT . '/includes/defines.php';
                require_once WPBOOKINGPRO_PATH_ROOT . '/includes/framework.php';
                $app = Factory::getApplication('site');
                $app->execute();
                $open_source = Factory::getOpenSource();
                $open_source->updateOpenSource();
            } elseif ($this->view || WooBookingOnWordpress::is_backend_wordpress()) {

                require_once WPBOOKINGPRO_PATH_ROOT . '/admin/includes/defines.php';
                require_once WPBOOKINGPRO_PATH_ROOT . '/admin/includes/framework.php';
                $app = Factory::getApplication('admin');
                $app->execute();
                $open_source = Factory::getOpenSource();
                $open_source->updateOpenSource();
            }

            if (!WooBookingOnWordpress::is_backend_wordpress()) {
                require_once WPBOOKINGPRO_PATH_ROOT . '/includes/defines.php';
                require_once WPBOOKINGPRO_PATH_ROOT . '/includes/framework.php';

                $app = Factory::getApplication('site');
                $open_source = Factory::getOpenSource();
                $open_source->updateOpenSource();

                $open_source->setup_render_gutenberg_dynamic();
            }




            //register_activation_hook(__FILE__, array("wpbookingpro", 'go_to_install'));
        }

        public static function get_list_view_publish()
        {
            $db = Factory::getDBO();
            $query = $db->getQuery(true);
            $query->select('view.name')
                ->from('view AS view')
                ->where('view.published=1');
            $listview = $db->setQuery($query)->loadColumn();
            return $listview;
        }

        public static function go_to_install()
        {
            $app = Factory::getApplication();
            $root_url=Factory::getRootUrl();
            $url=$root_url.'wp-admin/admin.php?page=wb_config&layout=install';
            wp_redirect($url);
            return true;
        }
        public static function pluginprefix_activation()
        {
            $app = Factory::getApplication();
            $open_source = Factory::getOpenSource();
            $open_source->pluginprefix_activation();
        }

        function is_rest_api()
        {
            $request_uri = $_SERVER['REQUEST_URI'];
            if (strpos($request_uri, 'wp-json/' . self::$namespace) !== false) {
                return true;
            }
            return false;
        }

        function get_current_page()
        {
            $request_uri = $_SERVER['REQUEST_URI'];
            $view = "";
            $listMenuWooPanel = self::getListMenuWooPanel();
            if (self::is_rest_api()) {
                foreach ($listMenuWooPanel as $menu) {
                    if (strpos($request_uri, self::$namespace . "/$menu") !== false) {
                        $view = $menu;
                        break;
                    }
                }
            } else {
                foreach ($listMenuWooPanel as $menu) {
                    if (strpos($request_uri, 'sellercenter/' . $menu) !== false) {
                        $view = $menu;
                        break;
                    }
                }
            }


            return $view;
        }

        //TODO sẽ phải định  nghĩ lại menu
        public static function getListMenuWooPanel()
        {
            $list_view_admin = self::get_list_view_for_woo_panel();
            $list_menu = [];
            foreach ($list_view_admin as $view) {
                $list_menu[] = $view['id'];
            }
            return $list_menu;
        }

        public static $list_menu_by_xml = [];

        public static function get_list_view_xml()
        {
            if (empty(self::$list_menu_by_xml)) {
                $file_xml_path_app = WPBOOKINGPRO_PATH_ADMIN_COMPONENT1 . "/views.xml";
                $xml = simplexml_load_file($file_xml_path_app);
                $list_menu_by_xml = [];
                $index = 21;
                foreach ($xml->view as $view) {
                    $list_menu_by_xml[] = (object)[
                        'id' => (string)$view->attributes()['id'],
                        'menu_slug' => (string)$view->attributes()['menu_slug'],
                        'label' => (string)$view->attributes()['label'],
                        'page_title' => (string)$view->attributes()['page_title'],
                        'capability' => (string)$view->attributes()['capability'],
                        'icon' => (string)$view->attributes()['icon'],
                    ];
                    $index++;
                }
                self::$list_menu_by_xml = $list_menu_by_xml;
            }
            return self::$list_menu_by_xml;
        }

        public static function get_list_view_for_woo_panel()
        {
            if (empty(self::$items_submenus)) {
                $list_menu_by_xml = self::get_list_view_xml();
                $items_submenus = [];
                $index = 21;
                foreach ($list_menu_by_xml as $view) {
                    $items_submenus[] = [
                        'id' => self::$prefix_link . $view->id,
                        'menu_slug' => self::$prefix_link . $view->menu_slug,
                        'label' => $view->label,
                        'page_title' => $view->page_title,
                        'capability' => $view->capability,
                        'icon' => $view->icon,
                    ];
                    $index++;
                }
                self::$items_submenus = $items_submenus;
            }
            return self::$items_submenus;
        }
    }
}
new wpbookingpro();
/**
 * @param $content
 */
if(!function_exists("wpbookingpro_render_content")) {
    function wpbookingpro_render_content($content)
    {
        $open_source = Factory::getOpenSource();
        $open_source->render_content($content);
    }
}


