<?php

use Grafika\Grafika;
use WooBooking\CMS\Utilities\Utility;
require_once WPBOOKINGPRO_PATH_ROOT . "/nb_apps/nb_woobooking/helpers/ConfigHelper.php";
WpBookingPro_HtmlFrontend::_('jquery.slick');
WpBookingPro_HtmlFrontend::_('jquery.validate');
WpBookingPro_HtmlFrontend::_('jquery.confirm');

$editor = Grafika::createEditor();
$doc = Factory::getDocument();
$doc->addStyleSheet('nb_apps/nb_woobooking/assets/nb-font-icon/nb-font-icon.css');
$doc->addLessStyleSheet('nb_apps/nb_woobooking/assets/less/view_service_detail_new.less');
$appConfig = Factory::getAppConfig();
$booking_style = $appConfig->get('booking_style', 'in_line');
$is_multi_product_in_cart = WpBookingPro_FrontEndHelper::is_multi_product_in_cart();
$open_time = $this->item->open_time;
$open_time=date('h:i A',strtotime($open_time));
$close_time= $this->item->close_time;
$close_time=date('h:i A',strtotime($close_time));
$working_day= $this->item->working_day;
$working_day=isset($working_day)?json_decode($working_day):array();

$rating_avg=($this->item->rating_ambience + $this->item->rating_cleanliness + $this->item->rating_staff + $this->item->rating_value) / 4;
$list_star_ambience = WpBookingPro_FrontEndHelper::get_rating_star($this->item->rating_ambience);
$list_star_cleanliness = WpBookingPro_FrontEndHelper::get_rating_star($this->item->rating_cleanliness);
$list_star_staff = WpBookingPro_FrontEndHelper::get_rating_star($this->item->rating_staff);
$list_star_value = WpBookingPro_FrontEndHelper::get_rating_star($this->item->rating_value);
$list_star_sum = WpBookingPro_FrontEndHelper::get_rating_star($rating_avg);
?>
    <div class="view-service-detail-new">
        <div class="bread-crumb">
            <a class="link-category" href="<?php esc_html_e($this->frontendGoToLink("category.list")); ?>"><?php esc_attr_e('Category','wpbookingpro')?></a>
            <i class="icon-nb-down-arrow"></i>
            <a class="link-category" href="<?php esc_html_e($this->frontendGoToLink("service.list", "category_id=" . $this->item->category_id)) ?>"><?php esc_html_e($this->item->category->name);?></a>
            <i class="icon-nb-down-arrow"></i>
            <span><?php esc_html_e($this->item->name);?></span>
        </div>
        <div class="block-alert"></div>
        <div class="row">
            <div class="col-md-12">
                <div class="block-title-service">
                    <h2><?php esc_html_e($this->item->name);?></h2>
                    <p><?php echo(isset($this->item->location->address)?$this->item->location->address:'');?></p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-8">
                <div class="wrapper-gallery-slider">
                    <a class="arrow-prev"><i class="icon-nb-down-arrow"></i></a>
                    <a class="arrow-next"><i class="icon-nb-down-arrow"></i></a>
                    <div class="block-gallery-slider-large">
                        <?php foreach ($this->item->list_image as $image) { ?>
                            <div class="img-gallery-large">
                                <div>
                                    <img src="<?php echo Factory::getRootUrlPlugin() ?>/<?php esc_html_e($image->path) ?>" alt="image-gallery">
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="block-gallery-slider-small">
                        <?php foreach ($this->item->list_image as $image) { ?>
                            <div class="gallery-img-box">
                                <div>
                                    <img class="demo cursor" src="<?php echo Factory::getRootUrlPlugin() ?>/<?php esc_html_e($image->path) ?>" alt="The Woods">
                                </div>
                            </div>
                        <?php }?>
                    </div>
                </div>
                <div class="service-information">
                    <p><?php echo(html_entity_decode($this->item->description));?></p>
                </div>
                <div class="block-list-event-service">
                    <?php
                    $field = $this->form->getField('list_event');
                    echo($field->input);
                    ?>
                </div>
                <form action="<?php echo Factory::getRootUrl() ?>wp-booking-pro" method="post" class="booking-form" name="client-form">
                    <div class="block-booking-information">
                        <h5><?php esc_attr_e('Select expert','wpbookingpro')?></h5>
                        <?php
                        $field = $this->form->getField('employee_id');
                        echo($field->input);
                        ?>
                        <h5><?php esc_attr_e('Select time','wpbookingpro')?></h5>
                        <?php
                        $field = $this->form->getField('calendar');
                        echo($field->input);
                        ?>
                    </div>
                    <?php if ($booking_style == "in_line") { ?>
                        <div class="wrapper-block-check-out">
                            <div class="row">
                                <div class="col-sm-6 col-md-6">
                                    <div class="infor-payment-left">
                                        <p><?php esc_attr_e('Expert','wpbookingpro') ?>: <span class="trainer-info"></span></p>
                                        <p><?php esc_attr_e('Local time','wpbookingpro') ?>: <span class="local-time"></span></p>
                                    </div>
                                </div>
                                <div class="col-sm-6 col-md-6">
                                    <div class="info-payment-right">
                                        <p><?php esc_attr_e('Date','wpbookingpro') ?>: <span class="date-info"></span></p>
                                        <p><?php esc_attr_e('Location','wpbookingpro') ?>: <span class="location-info"><?php echo(isset($this->item->location->address)?$this->item->location->address:'')?></span></p>
                                    </div>
                                </div>
                            </div>
                            <div class="block-check-out">
                                <div class="row">
                                    <div class="col-sm-6 col-md-6">
                                        <div class="input-firstname">
                                            <?php
                                            $field = $this->form->getField('first_name');
                                            echo($field->input);
                                            ?>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-6">
                                        <div class="input-lastname">
                                            <?php
                                            $field = $this->form->getField('last_name');
                                            echo($field->input);
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-6 col-md-6">
                                        <div class="input-email">
                                            <?php
                                            $field = $this->form->getField('email');
                                            echo($field->input);
                                            ?>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-6">
                                        <div class="input-phone">
                                            <?php
                                            $field = $this->form->getField('phone');
                                            $field->setId('phone' . rand(700, 30000));
                                            echo($field->input);
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="block-select-payment">
                                <?php
                                $field = $this->form->getField('payment_id');
                                $disable_payment_online = (boolean)isset($item->disable_payment_online) ? $item->disable_payment_online : false;
                                $field->setDisablePaymentOnline($disable_payment_online);
                                ?>
                                <h6><?php esc_attr_e('Select payment','wpbookingpro')?></h6>
                                <?php echo($field->input); ?>
                            </div>
                            <div class="block-select-quantity">
                                <h6><?php esc_attr_e('Quantity','wpbookingpro')?></h6>
                                <?php
                                $field = $this->form->getField('number_person');
                                echo($field->input);
                                ?>
                            </div>
                            <div class="block-payment-item">
                                <h4><?php esc_attr_e('Payment info','wpbookingpro') ?></h4>
                                <div class="detail-payment-item">
                                    <span><?php esc_attr_e('Total number of persons','wpbookingpro') ?>:</span>
                                    <span class="number-person">1</span>
                                </div>
                                <div class="detail-payment-item">
                                    <span><?php esc_attr_e('Base price','wpbookingpro') ?>:</span>
                                    <span class="base-price"><?php echo WpBookingPro_FrontEndHelper::format_currency($this->item->price)?></span>
                                </div>
                                <div class="detail-payment-item total-cost">
                                    <span><?php esc_attr_e('Total','wpbookingpro') ?>:</span>
                                    <span class="total-cost-sum"><?php echo WpBookingPro_FrontEndHelper::format_currency($this->item->price)?></span>
                                </div>
                            </div>
                            <div class="wrapper-btn-checkout">
                                <button type="button" class="btn btn-primary btn-cancel mr-3">
                                    <span><?php esc_attr_e('Cancel','wpbookingpro') ?></span>
                                </button>
                                <button type="button" class="btn btn-danger btn-book-now">
                                    <span><?php esc_attr_e('Book now','wpbookingpro') ?></span>
                                </button>
                                <?php if ($is_multi_product_in_cart) { ?>
                                    <button type="button" class="btn btn-primary btn-add-to-cart">
                                        <span><?php esc_attr_e('Add to cart','wpbookingpro') ?></span>
                                    </button>
                                <?php } ?>
                            </div>
                        </div>
                    <?php } ?>
                    <input type="hidden" name="task" value="booking.book_service" />
                    <input type="hidden" name="service_id" value="<?php esc_html_e($this->item->id) ?>" />
                    <input type="hidden" name="event_id" value="" />
                </form>
                <div class="block-review-by-customer">
                    <h4>
                        <?php echo ucfirst(WoobookingText::_('REVIEWS'))?>
                        <span>(<?php esc_attr_e('written by customers after their visit','wpbookingpro')?>)</span>
                    </h4>
                    <div class="block-review-item">
                        <div class="img-block">
                            <div>
                                <img src="<?php echo Factory::getRootUrlPlugin()?>upload/employees/images/cover/12 Nov 1998458x494_img1-450x468.jpg" alt="">
                            </div>
                        </div>
                        <div class="block-content">
                            <h5>Katar Meo</h5>
                            <ul class="list-rating-star">
                                <li class="item-star"><i class="fas fa-star"></i></li>
                                <li class="item-star"><i class="fas fa-star"></i></li>
                                <li class="item-star"><i class="fas fa-star"></i></li>
                                <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                <li class="item-star"><i class="far fa-star"></i></li>
                            </ul>
                            <p>Duis id suscipit massa. Mauris malesu ada turpis tellus, eu condimentum lac us semper</p>
                        </div>
                        <div class="block-time-review">
                            <h6>Visited May 06, 2020</h6>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="block-rating-service">
                    <div class="row">
                        <div class="col-xs-5 col-sm-5 col-md-5">
                            <div class="block-rating-left">
                                <h6><?php esc_attr_e('Venue rating','wpbookingpro')?></h6>
                                <p><?php esc_html_e(round($rating_avg,1));?></p>
                                <div class="block-rating">
                                    <ul class="list-rating-star">
                                        <?php for ($i=0; $i < $list_star_sum[0]; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star"></i></li>
                                        <?php }?>
                                        <?php for ($i=0; $i <$list_star_sum[1]; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                        <?php }?>
                                        <?php for ($i=0; $i <$list_star_sum[2]; $i++) {?>
                                            <li class="item-star"><i class="far fa-star"></i></li>
                                        <?php }?>
                                    </ul>
                                    <div class="rating-review">
                                        <span>2 <?php esc_attr_e('reviews','wpbookingpro');?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-7 col-sm-7 col-md-7">
                            <div class="block-rating-right">
                                <div class="item-rating">
                                    <p><?php esc_attr_e('Ambience','wpbookingpro')?></p>
                                    <ul class="list-rating-star">
                                        <?php for ($i=0; $i <$list_star_ambience[0]; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star"></i></li>
                                        <?php }?>
                                        <?php for ($i=0; $i <$list_star_ambience[1]; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                        <?php }?>
                                        <?php for ($i=0; $i <$list_star_ambience[2]; $i++) {?>
                                            <li class="item-star"><i class="far fa-star"></i></li>
                                        <?php }?>
                                    </ul>
                                </div>
                                <div class="item-rating">
                                    <p><?php esc_attr_e('Cleanliness','wpbookingpro')?></p>
                                    <ul class="list-rating-star">
                                        <?php for ($i=0; $i <$list_star_cleanliness[0]; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star"></i></li>
                                        <?php }?>
                                        <?php for ($i=0; $i <$list_star_cleanliness[1]; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                        <?php }?>
                                        <?php for ($i=0; $i <$list_star_cleanliness[2]; $i++) {?>
                                            <li class="item-star"><i class="far fa-star"></i></li>
                                        <?php }?>
                                    </ul>
                                </div>
                                <div class="item-rating">
                                    <p><?php esc_attr_e('Staff','wpbookingpro')?></p>
                                    <ul class="list-rating-star">
                                        <?php for ($i=0; $i <$list_star_staff[0]; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star"></i></li>
                                        <?php }?>
                                        <?php for ($i=0; $i <$list_star_staff[1]; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                        <?php }?>
                                        <?php for ($i=0; $i <$list_star_staff[2]; $i++) {?>
                                            <li class="item-star"><i class="far fa-star"></i></li>
                                        <?php }?>
                                    </ul>
                                </div>
                                <div class="item-rating">
                                    <p><?php esc_attr_e('Value','wpbookingpro')?></p>
                                    <ul class="list-rating-star">
                                        <?php for ($i=0; $i <$list_star_value[0]; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star"></i></li>
                                        <?php }?>
                                        <?php for ($i=0; $i <$list_star_value[1]; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                        <?php }?>
                                        <?php for ($i=0; $i <$list_star_value[2]; $i++) {?>
                                            <li class="item-star"><i class="far fa-star"></i></li>
                                        <?php }?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="block-location-info">
                    <div class="map-block">
                        <?php echo(isset($this->item->location->iframe) ?html_entity_decode($this->item->location->iframe): '');?>
                    </div>
                    <h5><?php echo(isset($this->item->location->name)?$this->item->location->name:'');?></h5>
                    <p><?php echo(isset($this->item->location->address)?$this->item->location->address:'');?></p>
                    <div class="block-social-icon">
                        <a class="item-social" href="<?php esc_html_e($this->item->params->get('facebook')) ?>">
                            <i class="icon-nb-facebook"></i>
                        </a>
                        <a class="item-social" href="<?php echo(isset($this->item->mobile)?'tel:'.$this->item->mobile:'#');?>">
                            <i class="icon-nb-phone-call"></i>
                        </a>
                        <a class="item-social" href="<?php esc_html_e($this->item->params->get('instagram')) ?>">
                            <i class="icon-nb-instagram"></i>
                        </a>
                    </div>
                </div>
                <div class="block-info-working-time">
                    <?php if(count((array)$working_day)) {?>
                        <?php foreach ($working_day as $day) {?>
                            <div class="work-time-item">
                                <span><?php esc_attr_e($day)?></span>
                                <span><?php esc_html_e($open_time);?> - <?php esc_html_e($close_time);?></span>
                            </div>
                        <?php }?>
                    <?php }?>
                </div>
            </div>
        </div>
    </div>

<?php
$doc->addScriptApplySelector('.view-service-detail-new','view_service_detail_new',array(
    'list_event'=>$this->list_event,
    'service_item'=>$this->item
),'nb_apps/nb_woobooking/assets/js/view_service_detail_new.js');