<?php

use Grafika\Grafika;
use WooBooking\CMS\Utilities\Utility;

$editor = Grafika::createEditor();
WpBookingPro_HtmlFrontend::_('jquery.slick');
WpBookingPro_HtmlFrontend::_('jquery.serialize_object');
WpBookingPro_HtmlFrontend::_('jquery.ui');
WpBookingPro_HtmlFrontend::_('jquery.validate');
WpBookingPro_HtmlFrontend::_('jquery.confirm');
$doc = Factory::getDocument();
$doc->addLessStyleSheet('nb_apps/nb_woobooking/assets/less/view_service_detail.less');
?>
    <div class="view-service-detail">
        <div class="block-confirm"></div>
        <form action="#" class="basic-data" name="client-form" method="post">
            <div class="row">
                <div class="col-md-12">
                    <?php
                    $field=$this->form->getField('calendar1');
                    ?>
                    <?php echo($field->input) ?>
                </div>
            </div>
            <div class="sp-slides">
                <?php foreach ($this->item->list_image as $image) { ?>
                    <div class="sp-slide">
                        <img class="sp-image" src="<?php echo Factory::getRootUrlPlugin() ?>/<?php esc_html_e($image->path) ?>" alt="service-cover"/>
                    </div>
                <?php } ?>
            </div>
            <div class="wrapper-content">
                <div class="header">
                    <div class="row image-price">
                        <div class="col-md-6">
                            <div class="pull-left">
                                <img class="cover-image-service" src="<?php echo Factory::getRootUrlPlugin() ?>/<?php esc_html_e($this->item->image) ?>" alt="service-cover" />
                            </div>
                            <div class="pull-left block-info-detail">
                                <p class="name"><?php esc_html_e($this->item->category->name) ?></p>
                                <h3><?php esc_html_e($this->item->name) ?></h3>
                                <div class="capa-dura">
                                    <p class="capacity"> <?php esc_attr_e('Capacity','wpbookingpro') ?>
                                        :<?php esc_html_e($this->item->minimum_capacity) ?>
                                        - <?php esc_html_e($this->item->maximum_capacity) ?></p>
                                    <p class="duration"> <?php esc_attr_e('Duration','wpbookingpro') ?>
                                        :<?php esc_html_e($this->item->duration) ?>h</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="pull-right price">
                                <span class="label label-primary "><?php echo WpBookingPro_FrontEndHelper::format_currency($this->item->price) ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="training-info">
                                <h4><?php esc_attr_e('Training info','wpbookingpro') ?></h4>
                                <div class="block-content-training-info">
                                    <div class="item-content">
                                        <span ><?php esc_attr_e('Category','wpbookingpro') ?>:</span>
                                        <span ><?php esc_html_e($this->item->category->name) ?></span>
                                    </div>
                                    <div class="item-content">
                                        <span><?php esc_attr_e('Duration','wpbookingpro') ?>:</span>
                                        <span><?php esc_html_e($this->item->duration) ?>h</span>
                                    </div>
                                    <div class="item-content">
                                        <span><?php esc_attr_e('Capacity','wpbookingpro') ?>:</span>
                                        <span><?php esc_html_e($this->item->minimum_capacity) ?>
                                - <?php esc_html_e($this->item->maximum_capacity) ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="wrapper-trainer">
                                <h4><?php esc_attr_e('Trainers','wpbookingpro') ?></h4>
                                <div class="trainer-block">
                                    <?php foreach ($this->item->list_employee as $employee) { ?>
                                        <div class="trainer-item">
                                            <div class="img-block">
                                                <img src="<?php echo Factory::getRootUrlPlugin() ?>/<?php esc_html_e($employee->image) ?>" alt="employee-cover" />
                                            </div>
                                            <p class="employee-name"><?php esc_html_e($employee->full_name) ?></p>
                                        </div>
                                    <?php }?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="wrapper-booking-event">
                            <div class="book-form">
                                <div class="wrapper-book-form-item-1">
                                    <div class="select-bringing_anyone">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <h4><?php esc_attr_e('Book Appointment','wpbookingpro') ?></h4>
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <?php if ($this->item->bringing_anyone == 1) { ?>
                                                            <div class="wrapper-bringing-anyone">
                                                                <?php
                                                                $field=$this->form->getField('bringing_anyone');
                                                                ?>
                                                                <?php echo($field->input) ?>
                                                                <div class="number-person">
                                                                    <?php echo($this->form->renderField('number_person')) ?>
                                                                </div>
                                                            </div>

                                                        <?php } ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div style="text-align: center">
                                            <button type="button" class="btn btn-danger btn-show-calendar"><span><?php esc_attr_e('Continue','wpbookingpro')?></span></button>
                                        </div>
                                    </div>
                                    <div class="select-date-picker">
                                        <div class="row">

                                            <div class="col-md-12">
                                                <?php
                                                $field=$this->form->getField('calendar');
                                                $field->setServiceId($this->item->id);
                                                ?>
                                                <?php echo($field->input) ?>
                                            </div>
                                        </div>
                                        <div class="group-control">
                                            <button type="button" class="btn btn-danger btn-hide-calendar"><span><?php esc_attr_e('Cancel','wpbookingpro')?></span></button>
                                            <button type="button" class="btn btn-info btn-book-now" style="display: none"><span><?php esc_attr_e('Book now','wpbookingpro')?></span></button>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-input">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="row title-payment" >
                                                <h3><?php esc_attr_e('Payment','wpbookingpro'); ?></h3>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6 ">
                                                    <?php echo($this->form->renderField('first_name')) ?>
                                                </div>
                                                <div class="col-md-6 ">
                                                    <?php echo($this->form->renderField('last_name')) ?>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6 ">
                                                    <?php echo($this->form->renderField('email')) ?>
                                                </div>
                                                <div class="col-md-6 ">
                                                    <?php echo($this->form->renderField('phone')) ?>
                                                </div>

                                            </div>
                                            <div class="row">
                                                <div class="col-md-6 ">
                                                    <?php echo($this->form->renderField('location_id')) ?>
                                                    <?php echo($this->form->renderField('payment_id')) ?>
                                                </div>
                                                <div class="col-md-6 ">
                                                    <?php echo($this->form->renderField('note')) ?>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6 col-sm-12">
                                                    <div class="wrapper-list-select">
                                                        <h4><?php esc_attr_e('SELECT_TRAINER')?>:</h4>
                                                        <?php
                                                        $list_employee = $this->item->list_employee;
                                                        $field = $this->form->getField('employee_id');
                                                        $field->setValue($list_employee);
                                                        ?>
                                                        <?php echo($field->input) ?>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="group-control">
                                                <button type="button" class="btn btn-primary btn-cancel-booking"><span><?php esc_attr_e('Cancel','wpbookingpro')?></span></button>
                                                <button type="submit" class="btn btn-danger btn-save-booking"></i><span><?php esc_attr_e('Book now','wpbookingpro')?></span></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="select-date">
                                <div class="row">
                                    <div class="col-md-12">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <input type="hidden" name="task" value="booking.book_now" />
            <input type="hidden" name="service_id" value="<?php esc_html_e($this->item->id) ?>" />
        </form>
    </div>

<?php
$doc->addScriptApplySelector('.view-service-detail','view_service_detail',array(),'nb_apps/nb_woobooking/assets/js/view_service_detail.js');