<?php
$item = $this->item;
?>
<div class="row list-cart">
    <div class="col-md-2 ">
        <div class="check">
            <div class="image">
                <img src="<?php esc_html_e(Factory::getRootUrlPlugin()) ?>/<?php esc_html_e($item->service_image) ?>" alt="service-cover" />
            </div>
        </div>
    </div>
    <div class="col-md-6 ">
        <div class="information">
            <h4><?php esc_html_e($this->order_package->customer->customer_full_name) ?></h4>
            <p class="service-name"><?php esc_html_e($item->service_name) ?></p>
            <div class="employee-location">
                <p class="employee-name"><i class="icon-nb-phone-call"></i><?php esc_html_e($this->order_package->customer->mobile) ?></p>
                <p><i class="icon-nb-email"></i><?php esc_html_e($this->order_package->customer->email) ?></p>
            </div>
            <p class="date"><i class="icon-nb-clock"></i><?php esc_html_e($item->rate->start_date) ?>&nbsp-&nbsp<?php esc_html_e($item->rate->end_date) ?></p>
        </div>
    </div>
    <div class="col-md-4">
        <div class="price-quantity-total">
            <div class="price">
                <p class="price-title"><?php esc_attr_e('Price','wpbookingpro'); ?></p>
                <p class="price-price"><?php echo(WpBookingPro_FrontEndHelper::format_currency($item->rate->price)) ?></p>
            </div>
            <div class="quantity">
                <p class="quantity-title"><?php esc_attr_e('Quantity','wpbookingpro'); ?></p>
                <p class="quantity-quantity"><?php esc_html_e($item->quantity) ?></p>
            </div>
            <div class="total">
                <p><?php esc_attr_e('Total','wpbookingpro'); ?></p>
                <h3><?php echo(WpBookingPro_FrontEndHelper::format_currency($item->total)) ?></h3>
            </div>
        </div>
    </div>
</div>
