<?php

use WooBooking\CMS\Utilities\Utility;

$doc = Factory::getDocument();
$doc->addLessStyleSheet('nb_apps/nb_woobooking/assets/less/view_list_order.less');
$doc->addStyleSheet('nb_apps/nb_woobooking/assets/nb-font-icon/nb-font-icon.css');
?>
    <div class="view-list-order">
        <div class="row">
            <div class="col-md-4">
                <?php $this->loadSharedTemplate('account_menu.account_menu') ?>
            </div>
            <div class="col-md-8">
                <?php foreach ($this->list as $item) { ?>
                    <?php if(!empty($item->list_order_detail)) {?>
                        <?php foreach ($item->list_order_detail as $order_detail) { ?>
                        <div class="row my-orders">
                            <div class="col-md-2  ">
                                <div class=" check">
                                    <div class="image">
                                        <img src="<?php esc_html_e(Factory::getRootUrlPlugin()) ?>/<?php esc_html_e($order_detail->rate->service_image) ?>" alt="service-cover" />
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 ">
                                <div class="information">
                                    <h4><?php esc_html_e($item->customer_full_name) ?></h4>
                                    <p class="service-name"><?php esc_html_e($order_detail->rate->service_name) ?></p>
                                    <div class="employee-location">
                                        <p class="employee-name"><i class="icon-nb-user"></i><?php esc_html_e($order_detail->rate->employee_full_name) ?></p>
                                        <p><i class="icon-nb-pin"></i><?php esc_html_e($order_detail->rate->location_address) ?></p>
                                    </div>
                                    <p class="date"><i class="icon-nb-clock"></i><?php esc_html_e($order_detail->rate->list_date_detail) ?> <?php esc_html_e($order_detail->rate->list_time_detail) ?></p>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="price-quantity-total">
                                    <div class="total">
                                        <p><?php esc_attr_e('Payment','wpbookingpro'); ?></p>
                                        <h3><?php echo(WpBookingPro_FrontEndHelper::format_currency($item->total)) ?></h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                    <?php } ?>
                <?php } ?>
                <?php foreach ($this->list_package_order as $item) { ?>
                    <?php if(!empty($item->list_order_package)) {?>
                        <?php foreach ($item->list_order_package as $order_package) { ?>
                            <div class="row my-orders">
                                <div class="col-md-2  ">
                                    <div class=" check">
                                        <div class="image">
                                            <img src="<?php esc_html_e(Factory::getRootUrlPlugin()) ?>/<?php esc_html_e($order_package->service_image) ?>" alt="service-cover" />
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 ">
                                    <div class="information">
                                        <h4><?php esc_html_e($item->customer->customer_full_name) ?></h4>
                                        <p class="service-name"><?php esc_html_e($order_package->service_name) ?></p>
                                        <div class="employee-location">
                                            <p class="employee-name"><i class="icon-nb-user"></i><?php esc_html_e($order_package->employee_full_name) ?></p>
                                            <p><i class="icon-nb-pin"></i><?php esc_html_e($order_package->location_address) ?></p>
                                        </div>
                                        <p class="date"><i class="icon-nb-clock"></i><?php esc_html_e($order_package->rate->list_date_detail) ?> <?php esc_html_e($order_package->rate->list_time_detail) ?></p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="price-quantity-total">
                                        <div class="total">
                                            <p><?php esc_attr_e('Payment','wpbookingpro'); ?></p>
                                            <h3><?php echo(WpBookingPro_FrontEndHelper::format_currency($item->total)) ?></h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    <?php } ?>
                <?php } ?>
            </div>
        </div>
    </div>

<?php
$doc->addScriptApplySelector('.view-list-order','view_list_order',array(),'nb_apps/nb_woobooking/assets/js/view_list_order.js');
