<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_EventView")) {
    /**
     * Class WpBookingPro_EventView
     */
    class WpBookingPro_EventView extends WooBookingView
    {
        /**
         * @var
         */
        public $list;
        /**
         * @var
         */
        public $filterForm;
        /**
         * @var
         */
        public $form_field;
        /**
         * @var
         */
        public $pagination;
        /**
         * @var array
         */
        public $list_service = array();

        /**
         * @param null $tpl
         * @return false|string
         * @throws Exception
         */
        public function display($tpl = null)
        {

            $input = Factory::getInput();
            switch ($tpl) {
                case "config_list":
                    $modelBlock = WoobookingModel::getInstance('block');
                    $open_source_client_id = $input->get('open_source_client_id', '');
                    $this->item = $modelBlock->getItem($open_source_client_id);
                    $this->form = $modelBlock->getFormConfigBlock('event', $tpl);
                    break;
                case "form":
                    $id = $input->getInt('id', 0);
                    $this->item = $modelEvent->getItem($id);
                    $this->form = $modelEvent->getForm();
                    break;
                case "find_event":
                    $service_id = $input->getInt('service_id', 0);
                    $servicesModel = WoobookingModel::getInstance('services');
                    $this->form = new stdClass();
                    $this->form->list_service = $servicesModel->getList();
                    $locationsModel = WoobookingModel::getInstance('locations');
                    $this->form->list_location = $locationsModel->getList();
                    $employeesModel = WoobookingModel::getInstance('employees');
                    $this->form->list_employee = $employeesModel->getList();
                    $modeEvents = WoobookingModel::getInstance('events');
                    $this->form_booking = $modeEvents->getFormBooking();
                    break;
                case "find_event_new":
                    $service_id = $input->getInt('service_id', 0);
                    $categoriesModel = WoobookingModel::getInstance('categories');
                    $this->form = new stdClass();
                    $this->form->list_category = $categoriesModel->getList();
                    $locationsModel = WoobookingModel::getInstance('locations');
                    $this->form->list_location = $locationsModel->getList();
                    $employeesModel = WoobookingModel::getInstance('employees');
                    $this->form->list_employee = $employeesModel->getList();
                    $modeEvents = WoobookingModel::getInstance('events');
                    $this->form_booking = $modeEvents->getFormBooking();
                    break;
                case "config_training":
                    break;
                case "list":
                default:
                    $input = Factory::getInput();
                    $modeEvents = WoobookingModel::getInstance('events');
                    $this->list = $modeEvents->getList();
                    $this->pagination = $modeEvents->getPagination();
                    $this->form_field = $modeEvents->getFormField();
                    $this->form = $modeEvents->getFormBooking();
                    break;
            }
            return parent::display($tpl);
        }
    }
}