<?php

use WooBooking\CMS\Utilities\Utility;

WpBookingPro_HtmlFrontend::_('jquery.increment');
WpBookingPro_HtmlFrontend::_('jquery.fancybox');
WpBookingPro_HtmlFrontend::_('jquery.confirm');
WpBookingPro_HtmlFrontend::_('jquery.validate');
$doc = Factory::getDocument();
$doc->addScript('resources/js/twbs-pagination/jquery.twbsPagination.js');
$doc->addLessStyleSheet('nb_apps/nb_woobooking/assets/less/view_list_event.less');
$doc->addStyleSheet('nb_apps/nb_woobooking/assets/nb-font-icon/nb-font-icon.css');
$appConfig = Factory::getAppConfig();
$booking_style = $appConfig->get('booking_style', 'in_line');
$is_multi_product_in_cart = WpBookingPro_FrontEndHelper::is_multi_product_in_cart();
?>
    <div class="view-list-event">
        <div class="block-alert"></div>
        <form action="#" method="get" style="display: none">
            <div class="toolbar-filter">
                <div class="row">
                    <div class="col-md-12">
                        <div class="toolbar-filter-wrapper">
                            <div class="pull-left filter-item">
                                <?php
                                $field = $this->form_field->getField('outdoor');
                                ?>
                                <?php echo($field->input) ?>
                            </div>
                            <div class="pull-left filter-item calendar-filter-choose">
                                <?php
                                $field = $this->form_field->getField('time');
                                ?>
                                <?php echo($field->input) ?>
                            </div>
                            <div class="pull-right filter-now">
                                <button class="btn btn-primary"><?php esc_attr_e('Filter','wpbookingpro') ?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
        <div class="wrapper-view-list-event">
            <?php
            $i = 0;
            ?>
            <?php foreach ($this->list as $item) { ?>
                <form action="<?php echo Factory::getRootUrl() ?>wp-booking-pro?task=booking.paynow" name="client-form"
                      method="post">
                    <div class="event-item panel panel-default" data-event_price="<?php esc_html_e($item->price) ?>" data-event_id="<?php esc_html_e($item->id) ?>">
                        <div class="row main-event-item">
                            <div class="col-md-2">
                                <?php if ($item->max_date > $item->min_date) { ?>
                                    <div class="date-event-double">
                                        <div>
                                            <div class="month"><?php echo date('M', $item->min_date) ?></div>
                                            <div class="m-month"><?php echo date('j', $item->min_date) ?></div>
                                        </div>
                                        <div>
                                            <div class="day"><?php echo date('M', $item->max_date) ?></div>
                                            <div class="d-day"><?php echo date('j', $item->max_date) ?></div>
                                        </div>
                                    </div>
                                <?php } else { ?>
                                    <div class="date-event-single">
                                        <div>
                                            <div class="month"><?php echo date('M', $item->min_date) ?></div>
                                            <div class="m-month"><?php echo date('j', $item->min_date) ?></div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                            <div class="col-md-8">
                                <div class="wrapper-event-content">
                                    <div class="header-event-content">
                                        <h4><?php esc_html_e($item->name); ?></h4>
                                    </div>
                                    <div class="footer">
                                        <p>
                                            <span>
                                                <i class="icon-nb-user"></i>
                                                <span>
                                                    <?php esc_attr_e('Capacity','wpbookingpro') ?>: <?php echo($item->min_allowed_person . '/' . $item->max_allowed_person); ?>
                                                </span>
                                            </span>
                                            <span>
                                                <i class="icon-nb-pin"></i>
                                                <span>
                                                    <?php foreach ($item->list_location as $list_location) {
                                                        esc_html_e($list_location->address);
                                                    }
                                                    ?>
                                                </span>
                                            </span>
                                        </p>
                                        <p>
                                            <span>
                                                <i class="icon-nb-clock"></i>
                                                <?php esc_html_e(substr($item->date_view, 2)); ?>
                                            </span>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2 label-price">
                                <div class="pull-right">
                                    <span class="sticky label label-primary"><?php echo WpBookingPro_FrontEndHelper::format_currency($item->price) ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="row row-button-action">
                            <div class="col-md-12">
                                <div class="wrapper-button-action">
                                    <div class="btn-booknow">
                                        <span><?php esc_attr_e('Book now','wpbookingpro')?></span>
                                        <i class="icon-nb-down-arrow"></i>
                                    </div>
                                    <div class="btn-cancel">
                                        <span><?php esc_attr_e('Cancel','wpbookingpro')?></span>
                                        <i class="icon-nb-down-arrow"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row sub-event-item" style="display: none">
                            <div class="col-md-12">
                                <div class="event-item-description">
                                    <div class="row">
                                        <div class="col-md-2">
                                            <div class="block-description-event">
                                                <h4><?php esc_attr_e('About this event','wpbookingpro') ?></h4>
                                            </div>
                                        </div>
                                        <div class="col-md-10">
                                            <p><?php esc_html_e($item->description); ?></p>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6 col-md-6 col-sm-offset-2 col-md-offset-2">
                                            <div class="img-box-event">
                                                <div class="row">
                                                    <?php foreach ($item->list_image as $list_image) { ?>
                                                        <div class="col-sm-4">
                                                            <a rel="group-<?php esc_html_e($item->id); ?>"
                                                               class="img-box-event-item"
                                                               href="<?php echo Factory::getRootUrlPlugin() ?>/<?php esc_html_e($list_image->path); ?>">
                                                                <div>
                                                                    <img src="<?php echo Factory::getRootUrlPlugin() ?>/<?php esc_html_e($list_image->path); ?>" alt="event-image" />
                                                                </div>
                                                            </a>
                                                        </div>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row sub-event-item sub-event-item-1" style="display: none">
                            <div class="col-md-12">
                                <div class="block-order-event-item">
                                    <div class="row">
                                        <div class="col-md-2">
                                            <div class="left-content-book">
                                                <h4><?php esc_attr_e('Book this event','wpbookingpro') ?></h4>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="right-content-book">
                                                <p>Select trainer</p>
                                                <div class="wrapper-list-select">
                                                    <?php
                                                    $list_employee = $item->list_employee;
                                                    $field = $this->form->getField('employee_id');
                                                    $field->setValue($list_employee);
                                                    ?>
                                                    <?php echo($field->input) ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="button-action">
                                                <p>Select time</p>
                                                <div class="block-list-rate">
                                                    <?php
                                                    $list_employee = $item->list_employee;
                                                    $field = $this->form->getField('rate_id');
                                                    $field->setValue($item->list_rate);
                                                    ?>
                                                    <?php echo($field->input) ?>
                                                </div>
                                                <div class="wrapper-button-counter">
                                                    <p>Quantity</p>
                                                    <div class="increment-button">
                                                        <?php
                                                        $field = $this->form->getField('number_person');
                                                        ?>
                                                        <?php echo($field->input) ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="wrapper-button-continue">
                                                <button type="button"
                                                        class="btn btn-primary btn-continue-book-now"><?php esc_attr_e('Continue','wpbookingpro') ?>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php if ($booking_style == "in_line") { ?>
                                <div class="wrapper-block-check-out">
                                    <div class="row">
                                        <div class="col-md-2">
                                            <h4><?php esc_attr_e('Payment','wpbookingpro') ?></h4>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="infor-payment-left">
                                                <p><?php echo($item->name); ?></p>
                                                <p><?php esc_attr_e('Trainer','wpbookingpro') ?>: <span class="trainer-info"></span></p>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="info-payment-right">
                                                <p><?php esc_attr_e('Time','wpbookingpro') ?>: <span class="time-info"></span></p>
                                                <p><?php esc_attr_e('Quantity','wpbookingpro') ?>: <span class="number-person"></span></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-2"></div>
                                        <div class="col-md-6">
                                            <div class="block-check-out">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="input-firstname">
                                                            <?php
                                                            $field = $this->form->getField('first_name');
                                                            echo($field->input);
                                                            ?>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="input-lastname">
                                                            <?php
                                                            $field = $this->form->getField('last_name');
                                                            echo($field->input);
                                                            ?>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="input-email">
                                                            <?php
                                                            $field = $this->form->getField('email');
                                                            echo($field->input);
                                                            ?>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="input-phone">
                                                            <?php
                                                            $field = $this->form->getField('phone');
                                                            $field->setId('phone' . rand(700, 30000));
                                                            echo($field->input);
                                                            ?>
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php
                                                $field = $this->form->getField('payment_id');
                                                $disable_payment_online = (boolean)isset($item->disable_payment_online) ? $item->disable_payment_online : false;
                                                $field->setDisablePaymentOnline($disable_payment_online);
                                                ?>
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <p><?php esc_attr_e('Select payment','wpbookingpro')?></p>
                                                        <?php echo($field->input); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="block-payment-item">
                                                        <h4><?php esc_attr_e('Payment info','wpbookingpro') ?></h4>
                                                        <div class="detail-payment-item">
                                                            <span><?php esc_attr_e('Total number of persons','wpbookingpro') ?>:</span>
                                                            <span class="number-person">1</span>
                                                        </div>
                                                        <div class="detail-payment-item">
                                                            <span><?php esc_attr_e('Base price','wpbookingpro') ?>:</span>
                                                            <span class="base-price"
                                                                  data-price="<?php esc_html_e($item->price) ?>">
                                                                <?php
                                                                echo WpBookingPro_FrontEndHelper::format_currency($item->price)
                                                                ?>
                                                            </span>
                                                        </div>
                                                        <div class="detail-payment-item" style="display: none">
                                                            <span><?php esc_attr_e('Discount','wpbookingpro') ?>:</span>
                                                            <span>$0.00</span>
                                                        </div>
                                                        <div class="add-coupon" style="display: none">
                                                            <span><?php esc_attr_e('Add coupon','wpbookingpro') ?>:</span>
                                                            <div class="add-coupon-input">
                                                                <input type="text" class="coupon_code" />
                                                                <button type="button" class="btn btn-primary"><i
                                                                            class="fas fa-check"></i></button>
                                                            </div>
                                                        </div>
                                                        <div class="detail-payment-item total-cost">
                                                            <span><?php esc_attr_e('Total cost','wpbookingpro') ?>:</span>
                                                            <span class="total-cost-sum">$15.00</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="wrapper-btn-checkout">
                                                <button type="button" class="btn btn-primary btn-cancel mr-3">
                                                    <span><?php esc_attr_e('Cancel','wpbookingpro') ?></span>
                                                </button>
                                                <button type="button" class="btn btn-danger btn-book-now">
                                                    <span><?php esc_attr_e('Book now','wpbookingpro') ?></span>
                                                </button>
                                                <?php if ($is_multi_product_in_cart) { ?>
                                                    <button type="button" class="btn btn-primary btn-add-to-cart">
                                                        <span><?php esc_attr_e('Add to cart','wpbookingpro') ?></span>
                                                    </button>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                    <input type="hidden" name="task" value="cart.add_to_cart" />
                    <input type="hidden" name="datetime" />
                    <input type="hidden" name="outdoor" />
                </form>
                <?php
                $i++;
                ?>
            <?php } ?>
        </div>
    </div>

<?php
$doc->addScriptApplySelector('.view-list-event', 'view_list_event', array(
    "list_event" => $this->list
), 'nb_apps/nb_woobooking/assets/js/view_list_event.js');
