<?php

use WooBooking\CMS\Utilities\Utility;

WpBookingPro_HtmlFrontend::_('jquery.icheck');
WpBookingPro_HtmlFrontend::_('jquery.moment');
WpBookingPro_HtmlFrontend::_('jquery.ui');
WpBookingPro_HtmlFrontend::_('jquery.select2');
WpBookingPro_HtmlFrontend::_('jquery.twbs_pagination');
WpBookingPro_HtmlFrontend::_('jquery.animated_modal');
WpBookingPro_HtmlFrontend::_('jquery.validate');
WpBookingPro_HtmlFrontend::_('jquery.confirm');
WpBookingPro_HtmlFrontend::_('jquery.serialize_object');
$doc = Factory::getDocument();
$doc->addLessStyleSheet('nb_apps/nb_woobooking/assets/less/view_find_event.less');
$doc->addStyleSheet('nb_apps/nb_woobooking/assets/nb-font-icon/nb-font-icon.css');
$appConfig = Factory::getAppConfig();
$booking_style = $appConfig->get('booking_style', 'in_line');
$is_multi_product_in_cart = WpBookingPro_FrontEndHelper::is_multi_product_in_cart();
$list_sorting = [
	"name" => "sorting by name",
	"price" => "sorting by price"
];
$input = Factory::getInput();
$service_id = $input->getInt('service_id', 0);
$location_id = $input->getInt('location_id', 0);
$employee_id = $input->getInt('employee_id', 0);
$render_service_item = function () {
	ob_start();
	?>
    <div class="service-item panel panel-default">
        <div class="row wrapper-service-item-info">
            <div class="col-sm-2">
                <div class="img-box-service">
                    <div>
                        <img class="image-service-image service-image-cover" src="https://vietnamforestry.org.vn/wp-content/uploads/2019/11/Bi-thoai-hoa-cot-song-co-nen-t%E1%BA%A1p-yoga.jpeg" alt="image-service-trainer" />
                    </div>
                </div>
            </div>
            <div class="col-sm-8">
                <div class="">
                    <div class="wrapper-center">
                        <h4 class="name_event"></h4>
                        <div class="line-content">
                            <span class="property">
                                <i class="icon-nb-user"></i>
                                <span class="min_allowed_person"></span>-<span class="max_allowed_person"></span>
                            </span>
                            <span class="property">
                                <i class="icon-nb-clock"></i><span class="rate_duration"></span>
                            </span>
                            <span class="property">
                                <i class="icon-nb-pin"></i><span class="event_address"></span>
                            </span>
                        </div>
                        <div class="wrapper-employee"></div>
                    </div>
                </div>
            </div>
            <div class="col-sm-2 wrapper-label-price">
                <span class="event_price_format label label-primary pull-right"></span>
            </div>
        </div>
        <div class="row row-button-action">
            <div class="col-md-12">
                <div class="wrapper-button-action">
                    <div class="btn-booknow">
                        <span><?php esc_attr_e('Book now','wpbookingpro')?></span>
                        <i class="icon-nb-down-arrow"></i>
                    </div>
                    <div class="btn-cancel">
                        <span><?php esc_attr_e('Cancel','wpbookingpro')?></span>
                        <i class="icon-nb-down-arrow"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="row wrapper-list-rate" style="display: none">
            <div class="col-md-2">
                <h4><?php esc_attr_e('Book this event','wpbookingpro') ?></h4>
            </div>
            <div class="col-md-10">
                <div class="list-rate">
                </div>
                <div class="wrapper-list-select">
                </div>
            </div>
            <div class="col-md-12">
                <div class="wrapper-button-booking">
                    <a href="javascript:void(0)" class="btn btn-primary btn-book-now-by-current-rate-item"><?php esc_attr_e('Book now','wpbookingpro')?></a>
                </div>
            </div>
        </div>
    </div>
	<?php
	$content = ob_get_clean();
	return $content;
}
?>
    <div class="view-search-event">
        <div class="block-confirm"></div>
        <form class="form-filter" action="<?php $this->frontendGoToLink('booking.paynow') ?>" method="post">
            <div class="row">
                <div class="col-md-4">
                    <div class="input-filter">
                        <div style="display: none" class="calendar"></div>
                        <div class="time-range"></div>
                        <h4><?php esc_attr_e('Filter training','wpbookingpro') ?> :</h4>
                        <div class="list-service">
                            <ul class="ul-list-service">
								<?php foreach ($this->form->list_service as $service) { ?>
                                    <li><label><input <?php echo ($service_id == $service->id) ? 'checked' : '' ?> type="checkbox" name="service_id[]" value="<?php esc_html_e($service->id); ?>" class="check-box-service" /> <?php esc_html_e($service->name); ?>
                                        </label>
                                    </li>
								<?php } ?>
                            </ul>
                        </div>
                        <div class="list-location">
                            <h4><?php esc_attr_e('Select address','wpbookingpro') ?></h4>
                            <i class="fas fa-sort-down arrow-down"></i>
                            <select name="location_id[]" multiple class="list-location">
                                <option value=""><?php esc_attr_e('Select all','wpbookingpro') ?></option>
								<?php foreach ($this->form->list_location as $location) { ?>
                                    <option <?php echo ($location_id == $location->id) ? 'selected' : '' ?>
                                            value="<?php esc_html_e($location->id); ?>"><?php esc_html_e($location->address); ?></option>
								<?php } ?>
                            </select>
                        </div>
                        <div class="list-employee">
                            <h4><?php esc_attr_e('Select trainer','wpbookingpro') ?></h4>
                            <i class="fas fa-sort-down arrow-down"></i>
                            <select name="employee_id[]" multiple class="list-employee">
                                <option value=""><?php esc_attr_e('SELECT_ALL') ?></option>
								<?php foreach ($this->form->list_employee as $employee) { ?>
                                    <option <?php echo ($employee_id == $employee->id) ? 'selected' : '' ?>
                                            value="<?php esc_html_e($employee->id); ?>"><?php esc_html_e($employee->full_name); ?></option>
								<?php } ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    <div class="wrapper-search-result">
                        <div class="search">
                            <i class="icon-nb-search icon-keyword-search"></i>
                            <input type="text" class="search form-control" name="keyword"  placeholder="<?php esc_attr_e('Search Keyword','wpbookingpro')?>" />
                        </div>
                        <div class="wrapper-search-result-body">
                            <h3><span class="count-result">4</span> <?php esc_attr_e('Results found','wpbookingpro') ?></h3>
                            <div class="sorting pull-right">
                            </div>
                        </div>
                        <div class="list-result">
                        </div>
                        <div style="display: none" class="row">
                            <div class="col-md-12">
                                <div class="pagination-list-service"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <input type="hidden" name="task" value="rates.ajax_search_rate" />
        </form>
        <div id="dialog-confirm" class="form-booking" title="Form booking">
            <form action="<?php $this->frontendGoToLink('booking.paynow') ?>" method="post" name="client-form">
                <div class="modal-header form-input-info-header">
                    <h3 class="modal-title" id="gridSystemModalLabel"><?php esc_attr_e('Booking info','wpbookingpro')?></h3>
                </div>
                <div class="modal-body form-input-info-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="wrapper-service">
                                <div class="img-box">
                                    <div>
                                        <img class="service-cover" src="<?php echo Factory::getRootUrlPlugin() . 'assets/images/cover.jpg' ?>" alt="service-cover" />
                                    </div>
                                </div>
                                <h4 class="service-name">Vinyasa Yoga</h4>
                            </div>
                        </div>
                    </div>
                    <div class="detail-time-and-location">
                        <div class="row">
                            <div class="col-sm-4">
                                <div class="column-title">
                                    <p><?php esc_attr_e('Trainer','wpbookingpro') ?></p>
                                </div>
                                <div class="column-content">
                                    <div class="img-box-trainer">
                                        <div>
                                            <img class="employee-cover pull-left" src="<?php echo Factory::getRootUrlPlugin() . 'assets/images/employeee.jpg' ?>" alt="employee-cover" />
                                        </div>
                                    </div>
                                    <p class="pull-left employee-name">Minnie Foss</p>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="column-title">
                                    <p><?php esc_attr_e('Date','wpbookingpro') ?></p>
                                </div>
                                <div class="column-content">
                                    <p class="date-detail">December 11, 2019</p>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="column-title">
                                    <p><?php esc_attr_e('Local_time','wpbookingpro') ?></p>
                                </div>
                                <div class="column-content">
                                    <p class="time-detail"> 9:00 am</p>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="column-title">
                                    <p><?php esc_attr_e('Location','wpbookingpro') ?></p>
                                </div>
                                <div class="column-content">
                                    <p class="address-detail">34th Street</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-customer-info">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="input-firstname">
                                    <?php
                                    $field = $this->form_booking->getField('first_name');
                                    echo($field->input);
                                    ?>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="input-lastname">
                                    <?php
                                    $field = $this->form_booking->getField('last_name');
                                    echo($field->input);
                                    ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="input-email">
                                    <?php
                                    $field = $this->form_booking->getField('email');
                                    echo($field->input);
                                    ?>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="input-phone">
                                    <?php
                                    $field = $this->form_booking->getField('phone');
                                    $field->setId('phone' . rand(700, 30000));
                                    echo($field->input);
                                    ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-6">
                                <p><?php esc_attr_e('Quantity','wpbookingpro')?></p>
                                <div class="increment-button">
                                    <?php
                                    $field = $this->form_booking->getField('number_person');
                                    ?>
                                    <?php echo($field->input) ?>
                                </div>
                            </div>
                            <?php
                            $field = $this->form_booking->getField('payment_id');
                            $disable_payment_online = (boolean)isset($item->disable_payment_online) ? $item->disable_payment_online : false;
                            $field->setDisablePaymentOnline($disable_payment_online);
                            ?>
                            <div class="col-sm-6">
                                <p><?php esc_attr_e('Select payment','wpbookingpro')?></p>
                                <?php echo($field->input); ?>
                            </div>
                        </div>
                    </div>
                    <div class="form-info-payment">
                        <div class="row">
                        <div class="col-sm-6"></div>
                        <div class="col-sm-6">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="block-payment-item">
                                        <p><?php esc_attr_e('Payment info','wpbookingpro') ?></p>
                                        <div class="detail-payment-item">
                                            <span><?php esc_attr_e('Total number of persons','wpbookingpro') ?>:</span>
                                            <span class="total-person">1</span>
                                        </div>
                                        <div class="detail-payment-item">
                                            <span><?php esc_attr_e('Base price','wpbookingpro') ?>:</span>
                                            <span class="base-price"
                                                  data-price="<?php esc_html_e($item->price) ?>">
                                                                <?php
                                                                echo WpBookingPro_FrontEndHelper::format_currency($item->price)
                                                                ?>
                                                            </span>
                                        </div>
                                        <div class="detail-payment-item" style="display: none">
                                            <span><?php esc_attr_e('Discount','wpbookingpro') ?>:</span>
                                            <span>$0.00</span>
                                        </div>
                                        <div class="add-coupon" style="display: none">
                                            <span><?php esc_attr_e('Add_coupon','wpbookingpro') ?>:</span>
                                            <div class="add-coupon-input">
                                                <input type="text" class="coupon_code" />
                                                <button type="button" class="btn btn-primary">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                            </div>
                                        </div>
                                        <div class="detail-payment-item total-cost">
                                            <span><?php esc_attr_e('Total cost','wpbookingpro') ?>:</span>
                                            <span class="total-cost-sum">$15.00</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    </div>
                <div class="modal-footer form-input-info-footer">
                    <button type="button" class="btn btn-primary btn-close-modal" data-dismiss="modal"><span><?php esc_attr_e('Close','wpbookingpro')?></span></button>
                    <button type="submit" class="btn btn-danger btn-booking-modal-now"><span><?php esc_attr_e('Booking now','wpbookingpro')?></span></button>
					<?php if ($is_multi_product_in_cart) { ?>
                        <button type="button" class="btn btn-primary btn-add-to-cart">
                            <span><?php esc_attr_e('Add to cart','wpbookingpro')?></span></button>
					<?php } ?>
                </div>
                <input type="hidden" name="task" value="cart.add_to_cart" />
                <input type="hidden" name="service_id" />
                <input type="hidden" name="employee_id" />
                <input type="hidden" name="rate_id" />
            </form>
        </div>
    </div>

<?php
$doc->addScriptApplySelector('.view-search-event','view_find_event',array(
        "service_item" => $render_service_item()
),'nb_apps/nb_woobooking/assets/js/view_find_event.js');