<?php

use WooBooking\CMS\Utilities\Utility;
WpBookingPro_HtmlFrontend::_('jquery.fontawesome');
$doc = Factory::getDocument();
$doc->addLessStyleSheet('nb_apps/nb_woobooking/assets/less/view_list_employee.less');
$doc->addStyleSheet('nb_apps/nb_woobooking/assets/nb-font-icon/nb-font-icon.css');
?>
    <div class="view-list-employee">
        <div class="row">
            <div class="col-md-12 title">
                <h1 class="name"><?php esc_attr_e('Meet coach','wpbookingpro')?></h1>
                <p class="description "><?php esc_attr_e('P coaches','wpbookingpro') ?></p>
            </div>
			<?php foreach ($this->list as $item) { ?>
                <div class="col-sm-6 col-md-4">
                    <div class="wrapper-employee">
                        <div class="cover-image-service-trainer">
                            <div>
                                <img src="<?php echo Factory::getRootUrlPlugin() ?>/<?php esc_html_e($item->image) ?>" alt="image-service-trainer" />
                            </div>
                        </div>
                        <div class="tes-content">
                            <h3 class="name"><?php esc_html_e($item->full_name) ?></h3>
                            <p class="category"><?php esc_html_e($item->category[0]->name) ?></p>
                            <div class="content">
                                <p>
                                    <?php esc_html_e($item->note_internal) ?>
                                </p>
                            </div>
                            <div class="team-social">
                                <a href="<?php esc_html_e($item->mobile) ?>"><i
                                            class="icon-nb-phone-call"></i> </a>
                                <a href="<?php esc_html_e($item->params->get('facebook')) ?>"><i class="icon-nb-facebook"></i></a>
                                <a href="<?php esc_html_e($item->params->get('instagram')) ?>"><i
                                            class="icon-nb-instagram"></i> </a>
                            </div>
                        </div>
                    </div>
                </div>
			<?php } ?>
        </div>
    </div>

<?php
$doc->addScriptApplySelector('.view-list-employee','view_list_employee',array(),'nb_apps/nb_woobooking/assets/js/employee/view_list_employee.js');