<?php

use WooBooking\CMS\Utilities\Utility;

$doc = Factory::getDocument();
$doc->addLessStyleSheet('nb_apps/nb_woobooking/assets/less/view_checkout.less');
WpBookingPro_HtmlFrontend::_('jquery.confirm');
WpBookingPro_HtmlFrontend::_('jquery.validate');
WpBookingPro_HtmlFrontend::_('jquery.icheck');
$total=0;
?>
    <div class="view-checkout-page">
        <div class="block-confirm"></div>
        <div class="row">
            <div class="col-md-12">
                <?php foreach ($this->cart as $item) { ?>
                    <?php $total += $item->total ?>
                <?php } ?>
                <?php $this->loadTemplate('list_cart');
                ?>
            </div>
        </div>
        <div class=" row form-payment">
            <form action="#" name="client-form" method="post">
                <div class="row">
                    <div class="col-md-2">
                        <h4 class="title"><?php esc_attr_e('Payment info','wpbookingpro') ?> </h4>
                    </div>
                    <div class="col-md-5">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="block-input">
                                    <?php
                                    $field= $this->form->getField('first_name');
                                    ?>
                                    <?php echo($field->input) ?>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="block-input">
                                    <?php
                                    $field= $this->form->getField('last_name');
                                    ?>
                                    <?php echo($field->input) ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="block-input">
                                    <?php
                                    $field= $this->form->getField('email');
                                    ?>
                                    <?php echo($field->input) ?>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="block-input">
                                    <?php
                                    $field= $this->form->getField('phone');
                                    ?>
                                    <?php echo($field->input) ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="block-select-payment">
                                    <h6><?php esc_attr_e('Select payment','wpbookingpro') ?> </h6>
                                    <?php
                                    $field= $this->form->getField('payment_id');
                                    ?>
                                    <?php echo($field->input) ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="block-description">
                                    <?php
                                    $field= $this->form->getField('note');
                                    ?>
                                    <?php echo($field->input) ?>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="cart-totals">
                                    <div class="detail-cart">
                                        <h3><?php esc_attr_e('Cart totals','wpbookingpro')?></h3>
                                        <div class="block-payment-total">
                                            <p><?php esc_attr_e('Cart subtotal','wpbookingpro')?></p>
                                            <p class="subtotal_price"><?php esc_html_e(WpBookingPro_FrontEndHelper::format_currency($total)); ?></p>

                                        </div>
                                        <div class="block-shipping">
                                            <p><?php esc_attr_e('Shipping','wpbookingpro')?></p>
                                            <p class="shipping-price">0</p>
                                        </div>
                                        <div class="order_total_price">
                                            <p><?php esc_attr_e('Total','wpbookingpro')?></p>
                                            <p class="total-price"><?php esc_html_e(WpBookingPro_FrontEndHelper::format_currency($total)); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="pull-right paynow">
                            <button type="submit" class="btn btn-primary btn-paynow-checkout"><?php esc_attr_e('Pay now','wpbookingpro')?></button>
                        </div>
                    </div>
                </div>
                <input type="hidden" name="rate_id[]" />
                <input type="hidden" name="service_id[]" />
                <input type="hidden" name="task" value="checkout.process_order" />
            </form>

        </div>
    </div>
<?php
$doc->addScriptApplySelector('.view-checkout-page','view_checkout_page',array(
    "list_cart" => $this->cart
),'nb_apps/nb_woobooking/assets/js/view_checkout_page.js');