<?php

use WooBooking\CMS\Utilities\Utility;

$doc = Factory::getDocument();
$doc->addLessStyleSheet('nb_apps/nb_woobooking/assets/less/view_list_cart.less');
WpBookingPro_HtmlFrontend::_('jquery.confirm');
WpBookingPro_HtmlFrontend::_('jquery.icheck');
$doc->addStyleSheet('nb_apps/nb_woobooking/assets/nb-font-icon/nb-font-icon.css');
$total = 0;
?>
    <div class="view-list-cart">
        <div class="block-confirm"></div>
        <div class="row">
            <div class="col-md-12">
                <div class="wrapper-button pull-right">
                    <button type="button" class="btn btn-primary btn-delete-cart-item-more mb-0"><?php esc_attr_e('Delete more','wpbookingpro')?></button>
                </div>
            </div>
        </div>
        <?php foreach ($this->list as $item) { ?>
            <?php $this->item = $item ?>
            <?php $this->loadTemplate('list_item') ?>
            <?php $total += $item->total ?>
        <?php } ?>
        <div class="row">
            <div class="col-md-4"></div>
            <div class="col-sm-6 col-md-4"></div>
            <div class="col-sm-6 col-md-4">
                <div class="cart-totals">
                    <div class="detail-cart">
                        <h3><?php esc_attr_e('Cart totals','wpbookingpro')?></h3>
                        <div class="block-payment-total">
                            <p><?php esc_attr_e('Cart subtotal','wpbookingpro')?></p>
                            <p class="subtotal_price"><?php echo(WpBookingPro_FrontEndHelper::format_currency($total)); ?></p>

                        </div>
                        <div class="block-shipping">
                            <p><?php esc_attr_e('Shipping','wpbookingpro')?></p>
                            <p class="shipping-price">0</p>
                        </div>
                        <div class="order_total_price">
                            <p><?php esc_attr_e('Total','wpbookingpro')?></p>
                            <p class="total-price"><?php echo(WpBookingPro_FrontEndHelper::format_currency($total)); ?></p>
                        </div>
                    </div>
                    <div class="checkout-cart">
                        <a href="<?php echo($this->frontendGoToLink('checkout.list')); ?>" class="btn btn-primary"><?php esc_attr_e('Check out','wpbookingpro')?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php
$doc->addScriptApplySelector('.view-list-cart','view_list_cart',array(
        "list_cart" => $this->list
),'nb_apps/nb_woobooking/assets/js/view_list_cart.js');