<?php
$doc = Factory::getDocument();
$doc->addScript('resources/js/twbs-pagination/jquery.twbsPagination.js');
$doc->addLessStyleSheet('nb_apps/nb_woobooking/less/view_list_event.less');
?>
<div class="view-list-event">
    <div class="toolbar">
        <div class="row">
            <div class="col-md-3"><h3><?php esc_attr_e('List event','wpbookingpro')?></h3></div>
            <div class="col-md-9">
                <div class="pull-right">
                    <button class="btn btn-primary btn-add-new"><?php esc_attr_e('Add new','wpbookingpro')?></button>
                    <button class="btn btn-primary btn-delete"><?php esc_attr_e('Delete','wpbookingpro')?></button>
                </div>
            </div>
        </div>
    </div>
    <div class="filter">
        <div class="row">
            <div class="col-md-12">
                <?php
                echo LayoutHelper::render('WooBooking.searchtools.default', array('view' => $this));
                ?>
            </div>
        </div>
    </div>
    <table class="table table-bordered tab-content table-striped table-hover list-event main-table">
        <thead>
        <tr>
            <th><?php esc_attr_e('Name','wpbookingpro')?></th>
            <th><?php esc_attr_e('Spot','wpbookingpro')?></th>
            <th><?php esc_attr_e('Recurring','wpbookingpro')?></th>
            <th><?php esc_attr_e('Booking opens','wpbookingpro')?></th>
            <th><?php esc_attr_e('Booking close','wpbookingpro')?></th>
            <th><?php esc_attr_e('Status','wpbookingpro')?></th>
            <th></th>
            <th></th>
        </tr>
        </thead>
        <tbody>
		<?php foreach ($this->list as $item) { ?>
			<?php $this->item = $item ?>
			<?php $this->loadTemplate('list_item') ?>
		<?php } ?>
        </tbody>
    </table>
    <div class="row">
        <div class="col-md-12">
            <div class="pagination-list-event"></div>
        </div>
    </div>
</div>
<?php
$doc->addScriptApplySelector('.view-list-event','view_list_event',array(
    "list_event" => $this->list
),'nb_apps/nb_woobooking/assets/js/view_list_event.js');