<?php
defined('_WPBOOKINGPRO_EXEC') or die;
use WooBooking\CMS\Filesystem\File as FileAlias;
use WooBooking\CMS\Form\Form;
use WooBooking\CMS\Utilities\Utility;
if(!class_exists("WpBookingPro_BlockView")) {
    /**
     * Class WpBookingPro_BlockView
     */
    class WpBookingPro_BlockView extends WooBookingView
    {
        /**
         * @var
         */
        public $list;
        /**
         * @var
         */
        public $filterForm;
        /**
         * @var
         */
        public $from;
        /**
         * @var
         */
        public $item;
        /**
         * @var
         */
        public $items;
        /**
         * @var string
         */
        public $view = "block";

        /**
         * @param null $block_name
         * @return false|string
         * @throws Exception
         */
        public function display_config_block($block_name = null)
        {
            $input = Factory::getInput();
            $modelBlock = WoobookingModel::getInstance('block');
            $block_id = $input->getInt('block_id', 0);
            $this->item = $modelBlock->getItem($block_id);
            $this->form = $modelBlock->getFormConfigBlockModule($block_name);
            return self::display_block_config($block_name);
        }

        /**
         * @param $tpl
         * @return false|string
         * @throws Exception
         */
        public function display($tpl)
        {
            $input = Factory::getInput();
            $modelBlock = WoobookingModel::getInstance('block');
            switch ($tpl) {
                case "preview":
                    $id = $input->getInt('id', 0);
                    $this->item = $modelBlock->getItem($id);
                    $this->form = $modelBlock->getFormBlockPreview($this->item->id);
                    break;
                case "config":
                    $id = $input->getInt('id', 0);
                    $this->item = $modelBlock->getItem($id);
                    $this->form = $modelBlock->getFormBlockConfig($this->item->id);

                case "list":
                    $modelBlocks = WoobookingModel::getInstance('blocks');
                    $this->items = $modelBlocks->getList();


                    break;
            }
            return parent::display($tpl);
        }

        /**
         * @param $block_name
         * @return false|string
         * @throws Exception
         */
        public function display_block_config($block_name)
        {
            $tmpl_short_path = "/blocks/block_$block_name/config.php";
            $tmpl_path = WPBOOKINGPRO_PATH_ROOT . $tmpl_short_path;
            $open_source = Factory::getOpenSource();
            $debug = "";
            if (file_exists($tmpl_path)) {
                ob_start();
                include $tmpl_path;
                $content = ob_get_clean();
                if (!trim($content)) {
                    $content = "<div class='wrapper-woo-booking'><p>layout <b>$tmpl_short_path</b> empty please add content to it</p>$debug</div>";
                }
                $content = "<div class=\"wrapper-woo-booking\">$content $debug</div>";
                $doc = Factory::getDocument();
                $headDocument = $doc->loadRenderer('head');
                $headDocument->render('head');
                return $content;
            } else {
                throw new Exception("Error:tpl <b>$block_name</b> not exits, please create it in block <b>" . $block_name . "</b>");
            }
        }

        /**
         * @param int $block_id
         * @param null $block_name
         * @return false|string
         * @throws Exception
         */
        public function display_block($block_id = 0, $block_name = null)
        {
            $input = Factory::getInput();
            $modelBlock = WoobookingModel::getInstance('block');
            $this->item = $modelBlock->getItem($block_id);
            $this->form = $modelBlock->getFormViewBlockModule($block_name);
            return self::display_view_block($block_name);
        }

        /**
         * @param $block_name
         * @return false|string
         * @throws Exception
         */
        public function display_view_block($block_name)
        {
            $tmpl_short_path = "/blocks/block_$block_name/$block_name.php";
            $tmpl_path = WPBOOKINGPRO_PATH_ROOT . $tmpl_short_path;
            Form::addFormPath(WPBOOKINGPRO_PATH_ROOT . "/blocks/block_$block_name/forms");
            $open_source = Factory::getOpenSource();
            $debug = "";
            if (file_exists($tmpl_path)) {
                ob_start();
                include $tmpl_path;
                $content = ob_get_clean();
                if (!trim($content)) {
                    $content = "<div class='wrapper-woo-booking'><p>layout <b>$tmpl_short_path</b> empty please add content to it</p>$debug</div>";
                }
                $content = "<div class=\"wrapper-woo-booking\">$content $debug</div>";
                $doc = Factory::getDocument();
                $headDocument = $doc->loadRenderer('head');
                $headDocument->render('head');
                return $content;
            } else {
                throw new Exception("Error:tpl <b>$block_name</b> not exits, please create it in block <b>" . $block_name . "</b>");
            }
        }
    }
}