<?php

use WooBooking\CMS\Utilities\Utility;

$doc = Factory::getDocument();
$doc->addLessStyleSheet('nb_apps/nb_woobooking/assets/less/view_list_account.less');
$doc->addStyleSheet('nb_apps/nb_woobooking/assets/nb-font-icon/nb-font-icon.css');
?>
    <div class="view-list-account">
        <div class="row">
            <div class="col-md-3">
                <?php $this->loadSharedTemplate('account_menu.account_menu') ?>
            </div>
            <div class="col-md-2">
                    <div class="img-box-avatar">
                        <div>
                            <img src="<?php echo Factory::getRootUrlPlugin() ?>/upload/account/images/image 44.png" alt="avatar" />
                        </div>
                    </div>
            </div>
            <div class="col-md-7">
                    <div class="block-content-right">
                        <div class="intro-description">
                            <p class="welcome"><?php esc_attr_e('Welcome','wpbookingpro')?></p>
                            <h3 class="user-name">DONALD MCKINNEY</h3>
                            <p class="business"><?php esc_attr_e('JUNIOR UI/UX DEVERLOPER','wpbookingpro')?></p>
                            <p class="description">Questa linea di ricerca, finalizzata allo studio degli ecosistemi marini pelagici e costieri, è incentrata sulla progettazione e la realizzazione di nuovi strumenti e sensori per la misura di variabili biologiche, ottiche, fisiche e chimiche dell'acqua di mare, e di nuove piattaforme di misura per lo studio degli ecosistemi marini a differenti scale spaziali e temporali.</p>
                        </div>
                        <div class="info-detail-my-account">
                            <div class="block-item-info">
                                <span><i class="icon-nb-calendar"></i></span>
                                <span><?php echo WpBookingPro_HtmlFrontend::_('date', 31/12/1992,WoobookingText::_('BIRTHDAY')) ?></span>
                            </div>
                            <div class="block-item-info">
                                <span><i class="icon-nb-phone-call"></i></span>
                                <span>446954783</span>
                            </div>
                            <div class="block-item-info">
                                <span><i class="icon-nb-email"></i></span>
                                <span><?php esc_html_e($this->user->user_email); ?></span>
                            </div>
                            <div class="block-item-info">
                                <span><i class="icon-nb-home-run"></i></span>
                                <span>Santa monica bullevand</span>
                            </div>
                        </div>
                        <div class="social-link-my-account">
                            <a href="facebook.com"><i class="icon-nb-facebook"></i></a>
                            <a href="instagram.com"><i class="icon-nb-instagram"></i></a>
                            <a href="twister.com"><i class="icon-nb-twitter"></i></a>
                        </div>
                    </div>
            </div>
        </div>
    </div>
<?php
$doc->addScriptApplySelector('.view-list-account','view_list_account',array(),'nb_apps/nb_woobooking/assets/js/view_list_account.js');