<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_servicesModel")) {
    /**
     * Class WpBookingPro_servicesModel
     */
    class WpBookingPro_servicesModel extends WoobookingModelList
    {
        /**
         * @var string
         */
        public $table_name = "service";
        /**
         * @var string
         */
        public $context = "services";

        /**
         * @return mixed
         * @throws Exception
         */
        public function getListServiceCategory()
        {
            $db = Factory::getDBO();
            $query = $db->getQuery(true);
            $modelCategories = $this->getModel('categories');
            $list_service_category = $modelCategories->getList();
            foreach ($list_service_category as &$category) {
                $query->clear()
                    ->select('service.*')
                    ->from(WoobookingTable::getWBTable('service') . ' AS service')
                    ->where('category_id=' . $category->id);
                $category->list_service = $db->setQuery($query)->loadObjectList();
            }
            return $list_service_category;
        }

        /**
         * @param $list_rate_id
         * @return mixed
         */
        public function getListServiceByListRateId($list_rate_id)
        {
            $db = Factory::getDBO();
            $query = $db->getQuery(true);
            $query->select("service.*")
                ->from($this->getTableName('service') . ' AS service')
                ->leftJoin($this->getTableName('event') . ' AS event ON event.service_id=service.id')
                ->leftJoin($this->getTableName('rate') . ' AS rate ON rate.object_id=event.id')
                ->leftJoin($this->getTableName('gallery') . ' AS gallery ON gallery.object_id=service.id AND type=' . $query->quote('service'))
                ->select('gallery.path AS service_image_intro')
                ->where('rate.id IN(' . implode(",", $list_rate_id) . ')')
                ->where('rate.type=' . $query->quote(WpBookingPro_RateHelper::getEventName()));
            $list = $db->setQuery($query)->loadObjectList();
            return $list;
        }

        /**
         * @param $category_id
         * @return mixed
         */
        public function getListServiceByCategoryId($category_id)
        {
            $db = Factory::getDBO();
            $query = $db->getQuery(true);
            $query->select("service.*")
                ->from($this->getTableName('service') . ' AS service')
                ->leftJoin($this->getTableName('service_employee') . ' AS service_employee ON service_employee.service_id=service.id')
                ->leftJoin($this->getTableName('gallery') . ' AS gallery ON gallery.object_id=service.id AND type=' . $query->quote('service'))
                ->select('gallery.path AS service_image_intro')
                ->where('service.category_id=' . (int)$category_id)
                ->group('service.id');
            $list = $db->setQuery($query)->loadObjectList();
            foreach ($list as &$item) {
                $query->clear()
                    ->select('employee.*')
                    ->from($this->getTableName('employee') . ' AS employee')
                    ->leftJoin($this->getTableName('service_employee') . ' as service_employee ON service_employee.employee_id=employee.id')
                    ->where('service_employee.service_id=' . (int)$item->id);
                $item->list_employee = $this->db->setQuery($query)->loadObjectList();
            }
            return $list;
        }

        /**
         * @param $list_service_id
         * @return mixed
         */
        public function getListServiceByArrayServiceId($list_service_id)
        {
            $query = $this->db->getQuery(true);
            $query->select("service.*")
                ->from($this->getTableName('service') . ' AS service');
            if (is_array($list_service_id) && count($list_service_id) > 0) {
                $query->where('service.id IN(' . implode(',', $list_service_id) . ')');
            }
            $listService = $this->db->setQuery($query)->loadObjectList();
            return $listService;
        }

        /**
         * @param $service_id
         * @return mixed
         */
        public function get_service_available_rate_by_service_id($service_id)
        {
            $query = $this->db->getQuery(true);
            $now = Factory::getDate();
            $query->select('service.*')
                ->from($this->getTableName() . ' AS service')
                ->leftJoin($this->getTableName('event') . ' AS event ON event.service_id=' . (int)$service_id)
                ->select('event.id AS event_id')
                ->where('service.id=' . (int)$service_id);
            $list = $this->db->setQuery($query)->loadObjectList();
            foreach ($list as &$item) {
                $query->clear()
                    ->select('DISTINCT rate.*')
                    ->from($this->getTableName('rate') . ' AS rate')
                    ->where('rate.object_id=' . (int)$item->event_id . ' AND rate.to >=' . $query->quote($now));
                $list_rate = $this->db->setQuery($query)->loadObjectList();
                foreach ($list_rate as &$rate) {
                    $from = Factory::getDate($rate->from);
                    $to = Factory::getDate($rate->to);
                    //h:i:s A
                    $rate->start_time = $from->format('h:i A');
                    $rate->end_time = $to->format('h:i A');
                }
                $item->list_rate = $list_rate;
            }
            return $list;
        }

        public function get_service_available($data) {
            $db = Factory::getDBO();
            $query = $db->getQuery(true);
            $query->clear()
                ->select('DISTINCT service.*')
                ->from($this->getTableName('service').' AS service')
                ->leftJoin($this->getTableName('category').' AS category ON category.id=service.category_id')
                ->where('category.published=1')
                ->where('service.published=1')
                ;
            $service_id = $data['service_id'];
            $category_id = $data['category_id'];
            if(is_array($category_id) && !empty($category_id)) {
                    $category_id = array_filter($category_id);
                    $query->where('service.category_id IN (' . implode(",", $category_id) . ')');
            }
            if (is_array($service_id) && !empty($service_id)) {
                $service_id = array_filter($service_id);
                $query->where('service.id IN (' . implode(",", $service_id) . ')');
            } else {
                if ($service_id) {
                    $query->where('service.id=' . (int)$service_id);
                }
            }
            $keywork = $data['keyword'];
            if (trim($keywork) != "") {
                $query->where('service.name LIKE ' . $query->quote("%$keywork%"));
            }

            $employee_id = $data['employee_id'];
            if (trim($employee_id) != '') {
                $query->leftJoin($this->getTableName('service_employee'). ' AS service_employee ON service_employee.service_id=service.id')
                    ->where('service_employee.employee_id=' . ($employee_id))
                ;
            }

            $location_id = $data['location_id'];
            if (trim($location_id) != '') {
                $query->where('service.location_id=' . (int)$location_id);
            }
            $list_service = $db->setQuery($query)->loadObjectList();
            foreach ($list_service as &$service) {
                $query->clear()
                    ->select('employee.*')
                    ->from($this->getTableName('employee') . ' AS employee')
                    ->leftJoin($this->getTableName('service_employee') . ' as service_employee ON service_employee.employee_id=employee.id')
                    ->where('service_employee.service_id=' . (int)$service->id);
                $service->list_employee = $this->db->setQuery($query)->loadObjectList();
                $query->clear()
                    ->select('location.*')
                    ->from($this->getTableName('location').' AS location')
                    ->where('location.id='.(int)$service->location_id)
                    ;
                $location = $this->db->setQuery($query)->loadObjectList();
                $service->location = reset($location);
                $query->clear()
                    ->select('category.name')
                    ->from($this->getTableName('category').' AS category')
                    ->where('category.id='.(int)$service->category_id)
                ;
                $service->category_name = $this->db->setQuery($query)->loadResult();
            }
            return $list_service;
        }
    }
}
