<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_PackagesModel")) {
    /**
     * Class WpBookingPro_PackagesModel
     */
    class WpBookingPro_PackagesModel extends WoobookingModel
    {
        /**
         * @var string
         */
        public $context = "packages";
        /**
         * @var string
         */
        public $table_name = "package";

        /**
         * @param array $list_package_id
         * @return mixed
         */
        public function getListPackageByListId($list_package_id = array())
        {
            $query = $this->db->getQuery(true);
            $query->select("package.*")
                ->from($this->getTableName('package') . ' AS package');
            if (is_array($list_package_id) && count($list_package_id) > 0) {
                $query->where('package.id IN (' . implode(',', $list_package_id) . ')');
            }
            $db = Factory::getDBO();
            $list = $this->db->setQuery($query)->loadObjectList();
            foreach ($list as &$item) {
                $query->clear()
                    ->select('event.*')
                    ->from($this->getTableName('event') . ' AS event')
                    ->leftJoin($this->getTableName('package_event') . ' AS package_event ON package_event.event_id=event.id')
                    ->where('package_event.package_id=' . (int)$item->id);
                $list_event = $this->_db->setQuery($query)->loadObjectList();
                foreach ($list_event as &$event) {
                    $query->clear()
                        ->select("DISTINCT rate.*")
                        ->from($this->getTableName('rate') . ' AS rate')
                        ->where('rate.object_id=' . (int)$event->id)
                        ->where('rate.type=' . $query->quote(WpBookingPro_RateHelper::getEventName()));
                    $list_rate = $db->setQuery($query)->loadObjectList();
                    foreach ($list_rate as &$rate) {
                        $from = Factory::getDate($rate->from);
                        $to = Factory::getDate($rate->to);
                        //h:i:s A
                        $rate->start_time = $from->format('h:i A');
                        $rate->end_time = $to->format('h:i A');
                    }
                    $event->list_rate = $list_rate;
                    $query->clear()
                        ->select('employee.*')
                        ->from($this->getTableName('employee') . ' AS employee')
                        ->leftJoin($this->getTableName('event_employee') . ' AS event_employee ON event_employee.employee_id=employee.id')
                        ->where('event_employee.event_id=' . (int)$event->id);
                    $event->list_employee = $db->setQuery($query)->loadObjectList();
                }
                $item->list_event = $list_event;
            }
            return $list;
        }

        /**
         * @param $package_id
         * @return mixed
         */
        public function get_package_by_package_id($package_id)
        {
            $query = $this->db->getQuery(true);
            $query->select("package.*")
                ->from($this->getTableName('package') . ' AS package')
                ->where('package.id=' . $package_id);
            $package = $this->db->setQuery($query)->loadObject();
            return $package;
        }
    }
}
