<?php
defined('_WPBOOKINGPRO_EXEC') or die;
use WooBooking\CMS\Utilities\Utility;
if(!class_exists("WpBookingPro_PackageOrdersModel")) {
    /**
     * Class WpBookingPro_PackageOrdersModel
     */
    class WpBookingPro_PackageOrdersModel extends WoobookingModelList
    {
        /**
         * @var string
         */
        public $context = "packageOrders";
        /**
         * @var string
         */
        public $table_name = "order";

        /**
         * @return array
         */
        public function getHeader()
        {
            return array();
        }

        /**
         * @return \WooBooking\CMS\Database\DatabaseQuery
         */
        public function getListQuery()
        {
            $query = $this->db->getQuery(true);
            $query->select('a.*')
                ->from($this->getTableName() . ' AS a')
                ->where('a.type='.$query->quote(WpBookingPro_RateHelper::getNamePackage()))
            ;
            return $query;
        }

        /**
         * @return mixed
         */
        public function getList()
        {
            $list = parent::getList(); // TODO: Change the autogenerated stub
            $query = $this->db->getQuery(true);
            foreach ($list as &$item) {
                $query->clear()
                    ->select("order_package.*")
                    ->from($this->getTableName('order_package') . ' AS order_package')
                    ->leftJoin($this->getTableName('employee') . ' AS employee  ON employee.id=order_package.employee_id')
                    ->select('employee.first_name AS employee_first_name,employee.last_name AS employee_last_name,employee.image AS employee_image')
                    ->leftJoin($this->getTableName('service') . ' AS service ON service.id=order_package.service_id')
                    ->select('service.name as service_name,service.price as service_price,service.image as service_image')
                    ->leftJoin($this->getTableName('location') . ' AS location ON location.id=order_package.location_id')
                    ->select('location.address as location_address')
                    ->where('order_id=' . (int)$item->id);
                $item->list_order_package = $this->db->setQuery($query)->loadObjectList();
                $customer=[];
                $query->clear()
                    ->select('customer.*, CONCAT(customer.first_name," ", customer.last_name) AS customer_full_name')
                    ->from($this->getTableName('customer').' AS customer')
                    ->where('customer.id='. (int)$item->customer_id)
                ;
                $customer=$this->db->setQuery($query)->loadObjectList();
                $item->customer=reset($customer);
                $list_employee_full_name = [];
                $list_service_name = [];
                $package=[];
                foreach ($item->list_order_package as &$order_package) {
                    $order_package->employee_full_name = Utility::getFullName($order_package->employee_first_name, $order_package->employee_last_name);
                    $list_employee_full_name[] = $order_package->employee_full_name;
                    $list_service_name[] = $order_package->service_name;
                    $query->clear()
                        ->select("*")
                        ->from($this->getTableName('order_package_rate').' AS order_package_rate')
                        ->where('order_package_rate.order_package_id=' . (int)$order_package->id);
                    $list_rate = $this->db->setQuery($query)->loadObjectList();
                    foreach ($list_rate as &$rate) {
                        $start_date = Factory::getDate($rate->start_date);
                        $end_date = Factory::getDate($rate->end_date);
                        $since_start = $start_date->diff($end_date);
                        $rate->duration = WoobookingText::_sprintf('TIME_DURATION', $since_start->h, $since_start->i);
                        $dateStart = date_parse_from_format('Y-m-d H:i:s', $start_date);
                        $dateEnd = date_parse_from_format('Y-m-d H:i:s', $end_date);
                        $dateStartTs = mktime(0, 0, 0, $dateStart['month'], $dateStart['day'], $dateStart['year']);
                        $dateEndTs = mktime(0, 0, 0, $dateEnd['month'], $dateEnd['day'], $dateEnd['year']);
                        $timeStartTs = mktime($dateStart['hour'], $dateStart['minute'], $dateStart['second'],
                            $dateStart['month'], $dateStart['day'], $dateStart['year']);
                        $timeEndTs = mktime($dateEnd['hour'], $dateEnd['minute'], $dateEnd['second'], $dateEnd['month'],
                            $dateEnd['day'], $dateEnd['year']);
                        $startDate = date('d/m/Y', $dateStartTs);
                        $endDate = date('d/m/Y', $dateEndTs);
                        $startTime = date('H:i', $timeStartTs);
                        $endTime = date('H:i', $timeEndTs);
                        $rate->list_date_detail = ($dateStartTs == $dateEndTs) ? $startDate : $startDate . ' - ' . $endDate;
                        $rate->list_time_detail = $startTime . ' - ' . $endTime;
                    }
                    $order_package->rate = reset($list_rate);
                    $query->clear()
                        ->select('package.*')
                        ->from($this->getTableName('package').' AS package')
                        ->where('package.id='.(int)$order_package->package_id)
                    ;
                    $package=$this->db->setQuery($query)->loadObjectList();
                }
                $item->package=reset($package);

            }
            return $list;
        }
    }
}
