<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_PackageBookingModel")) {
    /**
     * Class WpBookingPro_PackageBookingModel
     */
    class WpBookingPro_PackageBookingModel extends WoobookingModelForm
    {
        /**
         * @var string
         */
        public $context = "packageBooking";
        /**
         * @var string
         */
        public $table_name = "order";
        /**
         * @param $data
         * @return array|bool
         * @throws Exception
         */
        public function book_now($data)
        {
            $app = Factory::getApplication();
            $list_employee_id = (array)$data['employee_id'];
            $list_rate_id = (array)$data['rate_id'];
            $first_name = $data['first_name'];
            $last_name = $data['last_name'];
            $email = $data['email'];
            $phone = $data['phone'];
            $package_id = $data['package_id'];
            $payment_id = $data['payment_id'];
            $customerModel = WoobookingModel::getInstance('customer');
            $data_customer = [
                "first_name" => $first_name,
                "last_name" => $last_name,
                "mobile" => $phone,
                "email" => $email
            ];
            $customer = $customerModel->save($data_customer);
            $packageModel = WoobookingModel::getInstance('package');
            $package = $packageModel->getItem($package_id);
            $total = $package->price;
            $orderModel = WoobookingModel::getInstance('order');
            $data_order = [
                "customer_id" => $customer->id,
                "payment_id" => $payment_id,
                "total" => $total,
                "type" => WpBookingPro_RateHelper::getNamePackage()
            ];
            $order = $orderModel->save($data_order);
            $i = 0;
            foreach ($list_rate_id as $rate_id) {
                $rateModel = WoobookingModel::getInstance('rate');
                $rate = $rateModel->getItem($rate_id);
                $eventModel = WoobookingModel::getInstance('event');
                $event = $eventModel->getItem($rate->object_id);
                $orderPackageModel = WoobookingModel::getInstance('orderpackage');
                $data_order_detail = [
                    "id" => 0,
                    "customer_id" => $customer->id,
                    "package_id" => $package_id,
                    "employee_id" => $list_employee_id[$i],
                    "service_id" => $event->service_id,
                    "location_id" => $event->location_id,
                    "payment_id" => $payment_id,
                    "order_id" => $order->id,
                    "quantity" => 1,
                    "total" => $total
                ];
                $oder_package = $orderPackageModel->save($data_order_detail);
                $orderPackageRateModel = WoobookingModel::getInstance('orderpackagerate');
                $data_order_detail_rate = [
                    "id" => 0,
                    "order_package_id" => $oder_package->id,
                    "start_date" => $rate->from,
                    "end_date" => $rate->to,
                    "rate_id" => $rate_id,
                    "employee_id" => $list_employee_id[$i],
                    "service_id" => $event->service_id,
                    "location_id" => $event->location_id,
                    "total" => $total,
                    "price" => $package->price,
                    "subtotal" => $total,
                    "quantity" => 1
                ];
                $order_detail_rate = $orderPackageRateModel->save($data_order_detail_rate);
                $i++;
            }
            return $order;
        }
    }
}
